/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.DigestAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.OperatorUsingSecureRandom;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricSecretKey;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.crypto.general.SecureHash;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvSecretKeySpec;
import java.io.ByteArrayOutputStream;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Utils {
    static Map<String, DigestAlgorithm> digestNameToAlgMap = new HashMap<String, DigestAlgorithm>();
    static Map<DigestAlgorithm, DigestAlgorithm> hmacToAlgMap = new HashMap<DigestAlgorithm, DigestAlgorithm>();

    Utils() {
    }

    static boolean isAuthMode(Algorithm algorithm) {
        String string = algorithm.getName();
        return string.contains("/CCM") || string.contains("/EAX") || string.contains("/GCM") || string.contains("/CFB8MAC") || string.contains("/OCB") || string.contains("/GMAC") || string.contains("/CMAC") || string.contains("/CBCMAC") || string.contains("/MAC");
    }

    static String getBaseName(Algorithm algorithm) {
        String string = algorithm.getName();
        int n2 = string.indexOf(47);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if (string.equals("TripleDES")) {
            return "DESede";
        }
        return string;
    }

    static boolean isNotNull(ASN1Encodable aSN1Encodable) {
        return aSN1Encodable != null && !DERNull.INSTANCE.equals(aSN1Encodable.toASN1Primitive());
    }

    static <T> T addRandomIfNeeded(T t2, SecureRandom secureRandom) {
        if (t2 instanceof OperatorUsingSecureRandom) {
            return ((OperatorUsingSecureRandom)t2).withSecureRandom(secureRandom);
        }
        return t2;
    }

    static byte[] getKeyEncoding(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("no encoding for key");
        }
        return byArray;
    }

    static Set<Algorithm> getActiveSet(Algorithm[] algorithmArray) {
        LinkedHashSet<Algorithm> linkedHashSet = new LinkedHashSet<Algorithm>();
        for (Algorithm algorithm : algorithmArray) {
            if (!(algorithm instanceof FipsAlgorithm)) continue;
            linkedHashSet.add(algorithm);
        }
        return linkedHashSet;
    }

    static void clearAndResetByteArrayOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
        int n2 = byteArrayOutputStream.size();
        byteArrayOutputStream.reset();
        for (int i2 = 0; i2 != n2; ++i2) {
            byteArrayOutputStream.write(0);
        }
        byteArrayOutputStream.reset();
    }

    static SymmetricKey convertKey(Algorithm algorithm, Key key) throws InvalidKeyException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key needs to be SecretKey.");
        }
        if (key instanceof ProvSecretKeySpec) {
            return ((ProvSecretKeySpec)key).getBaseKey();
        }
        return new SymmetricSecretKey(algorithm, key.getEncoded());
    }

    static DigestAlgorithm getUnderlyingDigestAlgorithm(Algorithm algorithm) {
        DigestAlgorithm digestAlgorithm = hmacToAlgMap.get(algorithm);
        if (digestAlgorithm != null) {
            return digestAlgorithm;
        }
        throw new IllegalStateException("HMAC algorithm not recognized: " + algorithm.getName());
    }

    static boolean keyNotLength(final SymmetricKey symmetricKey, int n2) {
        byte[] byArray = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                return symmetricKey.getKeyBytes();
            }
        });
        return byArray.length != (n2 + 7) / 8;
    }

    static {
        digestNameToAlgMap.put("SHA-1", FipsSHS.Algorithm.SHA1);
        digestNameToAlgMap.put("SHA-224", FipsSHS.Algorithm.SHA224);
        digestNameToAlgMap.put("SHA-256", FipsSHS.Algorithm.SHA256);
        digestNameToAlgMap.put("SHA-384", FipsSHS.Algorithm.SHA384);
        digestNameToAlgMap.put("SHA-512", FipsSHS.Algorithm.SHA512);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA1_HMAC, FipsSHS.Algorithm.SHA1);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA224_HMAC, FipsSHS.Algorithm.SHA224);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA256_HMAC, FipsSHS.Algorithm.SHA256);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA384_HMAC, FipsSHS.Algorithm.SHA384);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA512_HMAC, FipsSHS.Algorithm.SHA512);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA512_224_HMAC, FipsSHS.Algorithm.SHA512_224);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA512_256_HMAC, FipsSHS.Algorithm.SHA512_256);
        hmacToAlgMap.put(SecureHash.Algorithm.MD5_HMAC, SecureHash.Algorithm.MD5);
        hmacToAlgMap.put(SecureHash.Algorithm.GOST3411_HMAC, SecureHash.Algorithm.GOST3411);
        hmacToAlgMap.put(SecureHash.Algorithm.RIPEMD128_HMAC, SecureHash.Algorithm.RIPEMD128);
        hmacToAlgMap.put(SecureHash.Algorithm.RIPEMD160_HMAC, SecureHash.Algorithm.RIPEMD160);
        hmacToAlgMap.put(SecureHash.Algorithm.RIPEMD256_HMAC, SecureHash.Algorithm.RIPEMD256);
        hmacToAlgMap.put(SecureHash.Algorithm.RIPEMD320_HMAC, SecureHash.Algorithm.RIPEMD320);
        hmacToAlgMap.put(SecureHash.Algorithm.WHIRLPOOL_HMAC, SecureHash.Algorithm.WHIRLPOOL);
        hmacToAlgMap.put(SecureHash.Algorithm.TIGER_HMAC, SecureHash.Algorithm.TIGER);
    }
}

