/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Object;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1String;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1TaggedObject;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.x500.RDN;
import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.asn1.x500.style.BCStyle;
import com.aspose.html.internal.ms.core.bc.asn1.x509.BasicConstraints;
import com.aspose.html.internal.ms.core.bc.asn1.x509.CRLDistPoint;
import com.aspose.html.internal.ms.core.bc.asn1.x509.DistributionPoint;
import com.aspose.html.internal.ms.core.bc.asn1.x509.DistributionPointName;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralName;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralNames;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralSubtree;
import com.aspose.html.internal.ms.core.bc.asn1.x509.IssuingDistributionPoint;
import com.aspose.html.internal.ms.core.bc.asn1.x509.NameConstraintValidatorException;
import com.aspose.html.internal.ms.core.bc.asn1.x509.NameConstraints;
import com.aspose.html.internal.ms.core.bc.asn1.x509.PKIXNameConstraintValidator;
import com.aspose.html.internal.ms.core.bc.asn1.x509.PolicyInformation;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXCRLStore;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXCRLStoreSelector;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXCertStoreSelector;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXExtendedBuilderParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXExtendedParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AnnotatedException;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.CertPathValidatorUtilities;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.CertStatus;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.PKIXCRLUtil;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.PKIXPolicyNode;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ReasonsMask;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;

class RFC3280CertPathUtilities {
    private static final PKIXCRLUtil CRL_UTIL = new PKIXCRLUtil();
    public static final String CERTIFICATE_POLICIES = Extension.certificatePolicies.getId();
    public static final String POLICY_MAPPINGS = Extension.policyMappings.getId();
    public static final String INHIBIT_ANY_POLICY = Extension.inhibitAnyPolicy.getId();
    public static final String ISSUING_DISTRIBUTION_POINT = Extension.issuingDistributionPoint.getId();
    public static final String FRESHEST_CRL = Extension.freshestCRL.getId();
    public static final String DELTA_CRL_INDICATOR = Extension.deltaCRLIndicator.getId();
    public static final String POLICY_CONSTRAINTS = Extension.policyConstraints.getId();
    public static final String BASIC_CONSTRAINTS = Extension.basicConstraints.getId();
    public static final String CRL_DISTRIBUTION_POINTS = Extension.cRLDistributionPoints.getId();
    public static final String SUBJECT_ALTERNATIVE_NAME = Extension.subjectAlternativeName.getId();
    public static final String NAME_CONSTRAINTS = Extension.nameConstraints.getId();
    public static final String AUTHORITY_KEY_IDENTIFIER = Extension.authorityKeyIdentifier.getId();
    public static final String KEY_USAGE = Extension.keyUsage.getId();
    public static final String CRL_NUMBER = Extension.cRLNumber.getId();
    public static final String ANY_POLICY = "2.5.29.32.0";
    protected static final int KEY_CERT_SIGN = 5;
    protected static final int CRL_SIGN = 6;
    static final Set<String> CERT_SUPPORTED_CRITICAL_EXTENSIONS = new HashSet<String>();
    static final Set<String> CRL_SUPPORTED_CRITICAL_EXTENSIONS = new HashSet<String>();
    protected static final String[] crlReasons;

    RFC3280CertPathUtilities() {
    }

    protected static void processCRLB2(DistributionPoint distributionPoint, Object object, X509CRL x509CRL) throws AnnotatedException {
        IssuingDistributionPoint issuingDistributionPoint = null;
        try {
            issuingDistributionPoint = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRL, ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception exception) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", exception);
        }
        if (issuingDistributionPoint != null) {
            ASN1Object aSN1Object;
            if (issuingDistributionPoint.getDistributionPoint() != null) {
                Object object2;
                aSN1Object = IssuingDistributionPoint.getInstance(issuingDistributionPoint).getDistributionPoint();
                ArrayList<GeneralName> arrayList = new ArrayList<GeneralName>();
                if (((DistributionPointName)aSN1Object).getType() == 0) {
                    object2 = GeneralNames.getInstance(((DistributionPointName)aSN1Object).getName()).getNames();
                    for (int i2 = 0; i2 < ((GeneralName[])object2).length; ++i2) {
                        arrayList.add(object2[i2]);
                    }
                }
                if (((DistributionPointName)aSN1Object).getType() == 1) {
                    object2 = new ASN1EncodableVector();
                    try {
                        Enumeration enumeration = ASN1Sequence.getInstance(ASN1Sequence.fromByteArray(CertPathValidatorUtilities.getIssuerPrincipal(x509CRL).getEncoded())).getObjects();
                        while (enumeration.hasMoreElements()) {
                            ((ASN1EncodableVector)object2).add((ASN1Encodable)enumeration.nextElement());
                        }
                    }
                    catch (IOException iOException) {
                        throw new AnnotatedException("Could not read CRL issuer.", iOException);
                    }
                    ((ASN1EncodableVector)object2).add(((DistributionPointName)aSN1Object).getName());
                    arrayList.add(new GeneralName(X500Name.getInstance(new DERSequence((ASN1EncodableVector)object2))));
                }
                boolean bl2 = false;
                if (distributionPoint.getDistributionPoint() != null) {
                    int n2;
                    aSN1Object = distributionPoint.getDistributionPoint();
                    GeneralName[] generalNameArray = null;
                    if (((DistributionPointName)aSN1Object).getType() == 0) {
                        generalNameArray = GeneralNames.getInstance(((DistributionPointName)aSN1Object).getName()).getNames();
                    }
                    if (((DistributionPointName)aSN1Object).getType() == 1) {
                        if (distributionPoint.getCRLIssuer() != null) {
                            generalNameArray = distributionPoint.getCRLIssuer().getNames();
                        } else {
                            generalNameArray = new GeneralName[1];
                            try {
                                generalNameArray[0] = new GeneralName(X500Name.getInstance(CertPathValidatorUtilities.getEncodedIssuerPrincipal(object).getEncoded()));
                            }
                            catch (Exception exception) {
                                throw new AnnotatedException("Could not read certificate issuer.", exception);
                            }
                        }
                        for (n2 = 0; n2 < generalNameArray.length; ++n2) {
                            Enumeration enumeration = ASN1Sequence.getInstance(generalNameArray[n2].getName().toASN1Primitive()).getObjects();
                            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                            while (enumeration.hasMoreElements()) {
                                aSN1EncodableVector.add((ASN1Encodable)enumeration.nextElement());
                            }
                            aSN1EncodableVector.add(((DistributionPointName)aSN1Object).getName());
                            generalNameArray[n2] = new GeneralName(X500Name.getInstance(new DERSequence(aSN1EncodableVector)));
                        }
                    }
                    if (generalNameArray != null) {
                        for (n2 = 0; n2 < generalNameArray.length; ++n2) {
                            if (!arrayList.contains(generalNameArray[n2])) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    if (!bl2) {
                        throw new AnnotatedException("No match for certificate CRL issuing distribution point name to cRLIssuer CRL distribution point.");
                    }
                } else {
                    if (distributionPoint.getCRLIssuer() == null) {
                        throw new AnnotatedException("Either the cRLIssuer or the distributionPoint field must be contained in DistributionPoint.");
                    }
                    GeneralName[] generalNameArray = distributionPoint.getCRLIssuer().getNames();
                    for (int i3 = 0; i3 < generalNameArray.length; ++i3) {
                        if (!arrayList.contains(generalNameArray[i3])) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        throw new AnnotatedException("No match for certificate CRL issuing distribution point name to cRLIssuer CRL distribution point.");
                    }
                }
            }
            aSN1Object = null;
            try {
                aSN1Object = BasicConstraints.getInstance(CertPathValidatorUtilities.getExtensionValue((X509Extension)object, BASIC_CONSTRAINTS));
            }
            catch (Exception exception) {
                throw new AnnotatedException("Basic constraints extension could not be decoded.", exception);
            }
            if (object instanceof X509Certificate) {
                if (issuingDistributionPoint.onlyContainsUserCerts() && aSN1Object != null && ((BasicConstraints)aSN1Object).isCA()) {
                    throw new AnnotatedException("CA Cert CRL only contains user certificates.");
                }
                if (issuingDistributionPoint.onlyContainsCACerts() && (aSN1Object == null || !((BasicConstraints)aSN1Object).isCA())) {
                    throw new AnnotatedException("End CRL only contains CA certificates.");
                }
            }
            if (issuingDistributionPoint.onlyContainsAttributeCerts()) {
                throw new AnnotatedException("onlyContainsAttributeCerts boolean is asserted.");
            }
        }
    }

    protected static void processCRLB1(DistributionPoint distributionPoint, Object object, X509CRL x509CRL) throws AnnotatedException {
        ASN1Primitive aSN1Primitive = CertPathValidatorUtilities.getExtensionValue(x509CRL, ISSUING_DISTRIBUTION_POINT);
        boolean bl2 = false;
        if (aSN1Primitive != null && IssuingDistributionPoint.getInstance(aSN1Primitive).isIndirectCRL()) {
            bl2 = true;
        }
        byte[] byArray = CertPathValidatorUtilities.getIssuerPrincipal(x509CRL).getEncoded();
        boolean bl3 = false;
        if (distributionPoint.getCRLIssuer() != null) {
            GeneralName[] generalNameArray = distributionPoint.getCRLIssuer().getNames();
            for (int i2 = 0; i2 < generalNameArray.length; ++i2) {
                if (generalNameArray[i2].getTagNo() != 4) continue;
                try {
                    if (!Arrays.areEqual(generalNameArray[i2].getName().toASN1Primitive().getEncoded(), byArray)) continue;
                    bl3 = true;
                    continue;
                }
                catch (IOException iOException) {
                    throw new AnnotatedException("CRL issuer information from distribution point cannot be decoded.", iOException);
                }
            }
            if (bl3 && !bl2) {
                throw new AnnotatedException("Distribution point contains cRLIssuer field but CRL is not indirect.");
            }
            if (!bl3) {
                throw new AnnotatedException("CRL issuer of CRL does not match CRL issuer of distribution point.");
            }
        } else if (CertPathValidatorUtilities.getIssuerPrincipal(x509CRL).equals(CertPathValidatorUtilities.getEncodedIssuerPrincipal(object))) {
            bl3 = true;
        }
        if (!bl3) {
            throw new AnnotatedException("Cannot find matching CRL issuer for certificate.");
        }
    }

    protected static ReasonsMask processCRLD(X509CRL x509CRL, DistributionPoint distributionPoint) throws AnnotatedException {
        IssuingDistributionPoint issuingDistributionPoint = null;
        try {
            issuingDistributionPoint = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRL, ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception exception) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", exception);
        }
        if (issuingDistributionPoint != null && issuingDistributionPoint.getOnlySomeReasons() != null && distributionPoint.getReasons() != null) {
            return new ReasonsMask(distributionPoint.getReasons()).intersect(new ReasonsMask(issuingDistributionPoint.getOnlySomeReasons()));
        }
        if ((issuingDistributionPoint == null || issuingDistributionPoint.getOnlySomeReasons() == null) && distributionPoint.getReasons() == null) {
            return ReasonsMask.allReasons;
        }
        return (distributionPoint.getReasons() == null ? ReasonsMask.allReasons : new ReasonsMask(distributionPoint.getReasons())).intersect(issuingDistributionPoint == null ? ReasonsMask.allReasons : new ReasonsMask(issuingDistributionPoint.getOnlySomeReasons()));
    }

    protected static Set processCRLF(X509CRL x509CRL, Object object, X509Certificate x509Certificate, PublicKey publicKey, PKIXExtendedParameters pKIXExtendedParameters, List list, Provider provider) throws AnnotatedException {
        Object object2;
        Object object3;
        Object object4;
        Serializable serializable;
        Collection collection;
        Object object5;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            object5 = CertPathValidatorUtilities.getIssuerPrincipal(x509CRL).getEncoded();
            x509CertSelector.setSubject((byte[])object5);
        }
        catch (IOException iOException) {
            throw new AnnotatedException("Subject criteria for certificate selector to find issuer certificate for CRL could not be set.", iOException);
        }
        object5 = new PKIXCertStoreSelector.Builder(x509CertSelector).build();
        try {
            collection = CertPathValidatorUtilities.findCertificates((PKIXCertStoreSelector)object5, pKIXExtendedParameters.getCertificateStores());
            collection.addAll(CertPathValidatorUtilities.findCertificates((PKIXCertStoreSelector)object5, pKIXExtendedParameters.getCertStores()));
        }
        catch (AnnotatedException annotatedException) {
            throw new AnnotatedException("Issuer certificate for CRL cannot be searched.", annotatedException);
        }
        collection.add(x509Certificate);
        Iterator iterator = collection.iterator();
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        ArrayList<PublicKey> arrayList2 = new ArrayList<PublicKey>();
        while (iterator.hasNext()) {
            serializable = (X509Certificate)iterator.next();
            if (((Certificate)serializable).equals(x509Certificate)) {
                arrayList.add(serializable);
                arrayList2.add(publicKey);
                continue;
            }
            try {
                object4 = CertPathBuilder.getInstance("PKIX", provider);
                X509CertSelector x509CertSelector2 = new X509CertSelector();
                x509CertSelector2.setCertificate((X509Certificate)serializable);
                object3 = new PKIXExtendedParameters.Builder(pKIXExtendedParameters).setTargetConstraints(new PKIXCertStoreSelector.Builder(x509CertSelector2).build());
                if (list.contains(serializable)) {
                    ((PKIXExtendedParameters.Builder)object3).setRevocationEnabled(false);
                } else {
                    ((PKIXExtendedParameters.Builder)object3).setRevocationEnabled(true);
                }
                object2 = new PKIXExtendedBuilderParameters.Builder(((PKIXExtendedParameters.Builder)object3).build()).build();
                List<? extends Certificate> list2 = ((CertPathBuilder)object4).build((CertPathParameters)object2).getCertPath().getCertificates();
                arrayList.add(serializable);
                arrayList2.add(CertPathValidatorUtilities.getNextWorkingKey(list2, 0, provider));
            }
            catch (CertPathBuilderException certPathBuilderException) {
                throw new AnnotatedException("CertPath for CRL signer failed to validate.", certPathBuilderException);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new AnnotatedException("Public key of issuer certificate of CRL could not be retrieved.", certPathValidatorException);
            }
            catch (Exception exception) {
                throw new AnnotatedException(exception.getMessage());
            }
        }
        serializable = new HashSet();
        object4 = null;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            object3 = (X509Certificate)arrayList.get(i2);
            object2 = ((X509Certificate)object3).getKeyUsage();
            if (!(object2 == null || ((boolean[])object2).length >= 7 && object2[6])) {
                object4 = new AnnotatedException("Issuer certificate key usage extension does not permit CRL signing.");
                continue;
            }
            serializable.add(arrayList2.get(i2));
        }
        if (serializable.isEmpty() && object4 == null) {
            throw new AnnotatedException("Cannot find a valid issuer certificate.");
        }
        if (serializable.isEmpty() && object4 != null) {
            throw object4;
        }
        return serializable;
    }

    protected static PublicKey processCRLG(X509CRL x509CRL, Set set) throws AnnotatedException {
        Exception exception = null;
        for (PublicKey publicKey : set) {
            try {
                x509CRL.verify(publicKey);
                return publicKey;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        throw new AnnotatedException("Cannot verify CRL.", exception);
    }

    protected static X509CRL processCRLH(Set set, PublicKey publicKey) throws AnnotatedException {
        Exception exception = null;
        for (X509CRL x509CRL : set) {
            try {
                x509CRL.verify(publicKey);
                return x509CRL;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        if (exception != null) {
            throw new AnnotatedException("Cannot verify delta CRL.", exception);
        }
        return null;
    }

    protected static Set processCRLA1i(Date date, PKIXExtendedParameters pKIXExtendedParameters, X509Certificate x509Certificate, X509CRL x509CRL) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        if (pKIXExtendedParameters.isUseDeltasEnabled()) {
            CRLDistPoint cRLDistPoint = null;
            try {
                cRLDistPoint = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, FRESHEST_CRL));
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Freshest CRL extension could not be decoded from certificate.", annotatedException);
            }
            if (cRLDistPoint == null) {
                try {
                    cRLDistPoint = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRL, FRESHEST_CRL));
                }
                catch (AnnotatedException annotatedException) {
                    throw new AnnotatedException("Freshest CRL extension could not be decoded from CRL.", annotatedException);
                }
            }
            if (cRLDistPoint != null) {
                ArrayList<PKIXCRLStore> arrayList = new ArrayList<PKIXCRLStore>();
                arrayList.addAll(pKIXExtendedParameters.getCRLStores());
                try {
                    arrayList.addAll(CertPathValidatorUtilities.getAdditionalStoresFromCRLDistributionPoint(cRLDistPoint, pKIXExtendedParameters.getNamedCRLStoreMap()));
                }
                catch (AnnotatedException annotatedException) {
                    throw new AnnotatedException("No new delta CRL locations could be added from Freshest CRL extension.", annotatedException);
                }
                try {
                    hashSet.addAll(CertPathValidatorUtilities.getDeltaCRLs(date, x509CRL, pKIXExtendedParameters.getCertStores(), arrayList));
                }
                catch (AnnotatedException annotatedException) {
                    throw new AnnotatedException("Exception obtaining delta CRLs.", annotatedException);
                }
            }
        }
        return hashSet;
    }

    protected static Set[] processCRLA1ii(Date date, PKIXExtendedParameters pKIXExtendedParameters, X509Certificate x509Certificate, X509CRL x509CRL) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        x509CRLSelector.setCertificateChecking(x509Certificate);
        try {
            x509CRLSelector.addIssuerName(x509CRL.getIssuerX500Principal().getEncoded());
        }
        catch (IOException iOException) {
            throw new AnnotatedException("Cannot extract issuer from CRL." + iOException, iOException);
        }
        PKIXCRLStoreSelector<? extends CRL> pKIXCRLStoreSelector = new PKIXCRLStoreSelector.Builder(x509CRLSelector).setCompleteCRLEnabled(true).build();
        Date date2 = date;
        if (pKIXExtendedParameters.getDate() != null) {
            date2 = pKIXExtendedParameters.getDate();
        }
        Set set = CRL_UTIL.findCRLs(pKIXCRLStoreSelector, date2, pKIXExtendedParameters.getCertStores(), pKIXExtendedParameters.getCRLStores());
        if (pKIXExtendedParameters.isUseDeltasEnabled()) {
            try {
                hashSet.addAll(CertPathValidatorUtilities.getDeltaCRLs(date2, x509CRL, pKIXExtendedParameters.getCertStores(), pKIXExtendedParameters.getCRLStores()));
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Exception obtaining delta CRLs.", annotatedException);
            }
        }
        return new Set[]{set, hashSet};
    }

    protected static void processCRLC(X509CRL x509CRL, X509CRL x509CRL2, PKIXExtendedParameters pKIXExtendedParameters) throws AnnotatedException {
        if (x509CRL == null) {
            return;
        }
        IssuingDistributionPoint issuingDistributionPoint = null;
        try {
            issuingDistributionPoint = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRL2, ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception exception) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", exception);
        }
        if (pKIXExtendedParameters.isUseDeltasEnabled()) {
            if (!x509CRL.getIssuerX500Principal().equals(x509CRL2.getIssuerX500Principal())) {
                throw new AnnotatedException("Complete CRL issuer does not match delta CRL issuer.");
            }
            IssuingDistributionPoint issuingDistributionPoint2 = null;
            try {
                issuingDistributionPoint2 = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRL, ISSUING_DISTRIBUTION_POINT));
            }
            catch (Exception exception) {
                throw new AnnotatedException("Issuing distribution point extension from delta CRL could not be decoded.", exception);
            }
            boolean bl2 = false;
            if (issuingDistributionPoint == null) {
                if (issuingDistributionPoint2 == null) {
                    bl2 = true;
                }
            } else if (issuingDistributionPoint.equals(issuingDistributionPoint2)) {
                bl2 = true;
            }
            if (!bl2) {
                throw new AnnotatedException("Issuing distribution point extension from delta CRL and complete CRL does not match.");
            }
            ASN1Primitive aSN1Primitive = null;
            try {
                aSN1Primitive = CertPathValidatorUtilities.getExtensionValue(x509CRL2, AUTHORITY_KEY_IDENTIFIER);
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Authority key identifier extension could not be extracted from complete CRL.", annotatedException);
            }
            ASN1Primitive aSN1Primitive2 = null;
            try {
                aSN1Primitive2 = CertPathValidatorUtilities.getExtensionValue(x509CRL, AUTHORITY_KEY_IDENTIFIER);
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Authority key identifier extension could not be extracted from delta CRL.", annotatedException);
            }
            if (aSN1Primitive == null) {
                throw new AnnotatedException("CRL authority key identifier is null.");
            }
            if (aSN1Primitive2 == null) {
                throw new AnnotatedException("Delta CRL authority key identifier is null.");
            }
            if (!aSN1Primitive.equals(aSN1Primitive2)) {
                throw new AnnotatedException("Delta CRL authority key identifier does not match complete CRL authority key identifier.");
            }
        }
    }

    protected static void processCRLI(Date date, X509CRL x509CRL, Object object, CertStatus certStatus, PKIXExtendedParameters pKIXExtendedParameters) throws AnnotatedException {
        if (pKIXExtendedParameters.isUseDeltasEnabled() && x509CRL != null) {
            CertPathValidatorUtilities.getCertStatus(date, x509CRL, object, certStatus);
        }
    }

    protected static void processCRLJ(Date date, X509CRL x509CRL, Object object, CertStatus certStatus) throws AnnotatedException {
        if (certStatus.getCertStatus() == 11) {
            CertPathValidatorUtilities.getCertStatus(date, x509CRL, object, certStatus);
        }
    }

    protected static PKIXPolicyNode prepareCertB(CertPath certPath, int n2, List[] listArray, PKIXPolicyNode pKIXPolicyNode, int n3) throws CertPathValidatorException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        int n4 = list.size();
        int n5 = n4 - n2;
        ASN1Sequence aSN1Sequence = null;
        try {
            aSN1Sequence = ASN1Sequence.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, POLICY_MAPPINGS));
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException("Policy mappings extension could not be decoded.", (Throwable)annotatedException, certPath, n2);
        }
        PKIXPolicyNode pKIXPolicyNode2 = pKIXPolicyNode;
        if (aSN1Sequence != null) {
            Object object3;
            Object object2;
            ASN1Sequence aSN1Sequence2 = aSN1Sequence;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HashSet<String> hashSet = new HashSet<String>();
            for (int i2 = 0; i2 < aSN1Sequence2.size(); ++i2) {
                ASN1Sequence object3 = (ASN1Sequence)aSN1Sequence2.getObjectAt(i2);
                String iterator = ((ASN1ObjectIdentifier)object3.getObjectAt(0)).getId();
                object2 = ((ASN1ObjectIdentifier)object3.getObjectAt(1)).getId();
                if (!hashMap.containsKey(iterator)) {
                    object3 = new HashSet();
                    object3.add(object2);
                    hashMap.put(iterator, object3);
                    hashSet.add(iterator);
                    continue;
                }
                object3 = (Set)hashMap.get(iterator);
                object3.add(object2);
            }
            block9: for (String string : hashSet) {
                Iterable iterable;
                if (n3 > 0) {
                    boolean bl2 = false;
                    for (Object object3 : listArray[n5]) {
                        if (!((PKIXPolicyNode)object3).getValidPolicy().equals(string)) continue;
                        bl2 = true;
                        ((PKIXPolicyNode)object3).expectedPolicies = (Set)hashMap.get(string);
                        break;
                    }
                    if (bl2) continue;
                    for (Object object3 : listArray[n5]) {
                        PKIXPolicyNode certPathValidatorException;
                        if (!ANY_POLICY.equals(((PKIXPolicyNode)object3).getValidPolicy())) continue;
                        Set set = null;
                        iterable = null;
                        try {
                            iterable = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(x509Certificate, CERTIFICATE_POLICIES);
                        }
                        catch (AnnotatedException i4) {
                            throw new CertPathValidatorException("Certificate policies extension could not be decoded.", (Throwable)i4, certPath, n2);
                        }
                        Enumeration enumeration = ((ASN1Sequence)iterable).getObjects();
                        while (enumeration.hasMoreElements()) {
                            PolicyInformation pKIXPolicyNode5 = null;
                            try {
                                pKIXPolicyNode5 = PolicyInformation.getInstance(enumeration.nextElement());
                            }
                            catch (Exception exception) {
                                throw new CertPathValidatorException("Policy information could not be decoded.", (Throwable)exception, certPath, n2);
                            }
                            if (!ANY_POLICY.equals(pKIXPolicyNode5.getPolicyIdentifier().getId())) continue;
                            try {
                                set = CertPathValidatorUtilities.getQualifierSet(pKIXPolicyNode5.getPolicyQualifiers());
                                break;
                            }
                            catch (CertPathValidatorException certPathValidatorException2) {
                                throw new CertPathValidatorException("Policy qualifier info set could not be decoded.", (Throwable)certPathValidatorException2, certPath, n2);
                            }
                        }
                        boolean bl3 = false;
                        if (x509Certificate.getCriticalExtensionOIDs() != null) {
                            bl3 = x509Certificate.getCriticalExtensionOIDs().contains(CERTIFICATE_POLICIES);
                        }
                        if (!ANY_POLICY.equals((certPathValidatorException = (PKIXPolicyNode)((PKIXPolicyNode)object3).getParent()).getValidPolicy())) continue block9;
                        PKIXPolicyNode pKIXPolicyNode3 = new PKIXPolicyNode(new ArrayList(), n5, (Set)hashMap.get(string), certPathValidatorException, set, string, bl3);
                        certPathValidatorException.addChild(pKIXPolicyNode3);
                        listArray[n5].add(pKIXPolicyNode3);
                        continue block9;
                    }
                    continue;
                }
                if (n3 > 0) continue;
                Iterator iterator = listArray[n5].iterator();
                while (iterator.hasNext()) {
                    object2 = (PKIXPolicyNode)iterator.next();
                    if (!((PKIXPolicyNode)object2).getValidPolicy().equals(string)) continue;
                    object3 = (PKIXPolicyNode)((PKIXPolicyNode)object2).getParent();
                    ((PKIXPolicyNode)object3).removeChild((PKIXPolicyNode)object2);
                    iterator.remove();
                    for (int i2 = n5 - 1; i2 >= 0; --i2) {
                        PKIXPolicyNode pKIXPolicyNode4;
                        iterable = listArray[i2];
                        for (int i3 = 0; i3 < iterable.size() && ((pKIXPolicyNode4 = (PKIXPolicyNode)iterable.get(i3)).hasChildren() || (pKIXPolicyNode2 = CertPathValidatorUtilities.removePolicyNode(pKIXPolicyNode2, listArray, pKIXPolicyNode4)) != null); ++i3) {
                        }
                    }
                }
            }
        }
        return pKIXPolicyNode2;
    }

    protected static void prepareNextCertA(CertPath certPath, int n2) throws CertPathValidatorException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        ASN1Sequence aSN1Sequence = null;
        try {
            aSN1Sequence = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, POLICY_MAPPINGS));
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException("Policy mappings extension could not be decoded.", (Throwable)annotatedException, certPath, n2);
        }
        if (aSN1Sequence != null) {
            ASN1Sequence aSN1Sequence2 = aSN1Sequence;
            for (int i2 = 0; i2 < aSN1Sequence2.size(); ++i2) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = null;
                ASN1ObjectIdentifier aSN1ObjectIdentifier2 = null;
                try {
                    ASN1Sequence aSN1Sequence3 = DERSequence.getInstance(aSN1Sequence2.getObjectAt(i2));
                    aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(aSN1Sequence3.getObjectAt(0));
                    aSN1ObjectIdentifier2 = ASN1ObjectIdentifier.getInstance(aSN1Sequence3.getObjectAt(1));
                }
                catch (Exception exception) {
                    throw new CertPathValidatorException("Policy mappings extension contents could not be decoded.", (Throwable)exception, certPath, n2);
                }
                if (ANY_POLICY.equals(aSN1ObjectIdentifier.getId())) {
                    throw new CertPathValidatorException("IssuerDomainPolicy is anyPolicy", null, certPath, n2);
                }
                if (!ANY_POLICY.equals(aSN1ObjectIdentifier2.getId())) continue;
                throw new CertPathValidatorException("SubjectDomainPolicy is anyPolicy,", null, certPath, n2);
            }
        }
    }

    protected static void processCertF(CertPath certPath, int n2, PKIXPolicyNode pKIXPolicyNode, int n3) throws CertPathValidatorException {
        if (n3 <= 0 && pKIXPolicyNode == null) {
            throw new CertPathValidatorException("No valid policy tree found when one expected.", null, certPath, n2);
        }
    }

    protected static PKIXPolicyNode processCertE(CertPath certPath, int n2, PKIXPolicyNode pKIXPolicyNode) throws CertPathValidatorException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        ASN1Sequence aSN1Sequence = null;
        try {
            aSN1Sequence = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, CERTIFICATE_POLICIES));
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException("Could not read certificate policies extension from certificate.", (Throwable)annotatedException, certPath, n2);
        }
        if (aSN1Sequence == null) {
            pKIXPolicyNode = null;
        }
        return pKIXPolicyNode;
    }

    protected static void processCertBC(CertPath certPath, int n2, PKIXNameConstraintValidator pKIXNameConstraintValidator) throws CertPathValidatorException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        int n3 = list.size();
        int n4 = n3 - n2;
        if (!CertPathValidatorUtilities.isSelfIssued(x509Certificate) || n4 >= n3) {
            X500Name x500Name;
            try {
                x500Name = CertPathValidatorUtilities.getSubjectDN(x509Certificate);
            }
            catch (Exception exception) {
                throw new CertPathValidatorException("Exception extracting subject name when checking subtrees.", (Throwable)exception, certPath, n2);
            }
            try {
                pKIXNameConstraintValidator.checkPermitted(new GeneralName(x500Name));
                pKIXNameConstraintValidator.checkExcluded(new GeneralName(x500Name));
            }
            catch (NameConstraintValidatorException nameConstraintValidatorException) {
                throw new CertPathValidatorException("Subtree check for certificate subject failed.", (Throwable)nameConstraintValidatorException, certPath, n2);
            }
            GeneralNames generalNames = null;
            try {
                generalNames = GeneralNames.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, SUBJECT_ALTERNATIVE_NAME));
            }
            catch (Exception exception) {
                throw new CertPathValidatorException("Subject alternative name extension could not be decoded.", (Throwable)exception, certPath, n2);
            }
            RDN[] rDNArray = X500Name.getInstance(x500Name).getRDNs(BCStyle.EmailAddress);
            for (int i2 = 0; i2 != rDNArray.length; ++i2) {
                String string = ((ASN1String)((Object)rDNArray[i2].getFirst().getValue())).getString();
                GeneralName generalName = new GeneralName(1, string);
                try {
                    pKIXNameConstraintValidator.checkPermitted(generalName);
                    pKIXNameConstraintValidator.checkExcluded(generalName);
                    continue;
                }
                catch (NameConstraintValidatorException nameConstraintValidatorException) {
                    throw new CertPathValidatorException("Subtree check for certificate subject alternative email failed.", (Throwable)nameConstraintValidatorException, certPath, n2);
                }
            }
            if (generalNames != null) {
                GeneralName[] generalNameArray = null;
                try {
                    generalNameArray = generalNames.getNames();
                }
                catch (Exception exception) {
                    throw new CertPathValidatorException("Subject alternative name contents could not be decoded.", (Throwable)exception, certPath, n2);
                }
                for (int i3 = 0; i3 < generalNameArray.length; ++i3) {
                    try {
                        pKIXNameConstraintValidator.checkPermitted(generalNameArray[i3]);
                        pKIXNameConstraintValidator.checkExcluded(generalNameArray[i3]);
                        continue;
                    }
                    catch (NameConstraintValidatorException nameConstraintValidatorException) {
                        throw new CertPathValidatorException("Subtree check for certificate subject alternative name failed.", (Throwable)nameConstraintValidatorException, certPath, n2);
                    }
                }
            }
        }
    }

    protected static PKIXPolicyNode processCertD(CertPath certPath, int n2, Set set, PKIXPolicyNode pKIXPolicyNode, List[] listArray, int n3) throws CertPathValidatorException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        int n4 = list.size();
        int n5 = n4 - n2;
        ASN1Sequence aSN1Sequence = null;
        try {
            aSN1Sequence = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, CERTIFICATE_POLICIES));
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException("Could not read certificate policies extension from certificate.", (Throwable)annotatedException, certPath, n2);
        }
        if (aSN1Sequence != null && pKIXPolicyNode != null) {
            PKIXPolicyNode pKIXPolicyNode2;
            int n6;
            Collection collection;
            Object object;
            Object object2;
            Enumeration enumeration = aSN1Sequence.getObjects();
            HashSet<String> hashSet = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                object2 = PolicyInformation.getInstance(enumeration.nextElement());
                object = ((PolicyInformation)object2).getPolicyIdentifier();
                hashSet.add(((ASN1ObjectIdentifier)object).getId());
                if (ANY_POLICY.equals(((ASN1ObjectIdentifier)object).getId())) continue;
                collection = null;
                try {
                    collection = CertPathValidatorUtilities.getQualifierSet(((PolicyInformation)object2).getPolicyQualifiers());
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    throw new CertPathValidatorException("Policy qualifier info set could not be build.", (Throwable)certPathValidatorException, certPath, n2);
                }
                n6 = CertPathValidatorUtilities.processCertD1i(n5, listArray, (ASN1ObjectIdentifier)object, (Set)collection);
                if (n6 != 0) continue;
                CertPathValidatorUtilities.processCertD1ii(n5, listArray, (ASN1ObjectIdentifier)object, collection);
            }
            if (set.isEmpty() || set.contains(ANY_POLICY)) {
                set.clear();
                set.addAll(hashSet);
            } else {
                object2 = set.iterator();
                object = new HashSet();
                while (object2.hasNext()) {
                    collection = (Collection)object2.next();
                    if (!hashSet.contains(collection)) continue;
                    object.add(collection);
                }
                set.clear();
                set.addAll(object);
            }
            if (n3 > 0 || n5 < n4 && CertPathValidatorUtilities.isSelfIssued(x509Certificate)) {
                enumeration = aSN1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    object2 = PolicyInformation.getInstance(enumeration.nextElement());
                    if (!ANY_POLICY.equals(((PolicyInformation)object2).getPolicyIdentifier().getId())) continue;
                    object = CertPathValidatorUtilities.getQualifierSet(((PolicyInformation)object2).getPolicyQualifiers());
                    collection = listArray[n5 - 1];
                    for (n6 = 0; n6 < collection.size(); ++n6) {
                        pKIXPolicyNode2 = (PKIXPolicyNode)collection.get(n6);
                        for (Object e2 : pKIXPolicyNode2.getExpectedPolicies()) {
                            Object object3;
                            String string;
                            if (e2 instanceof String) {
                                string = (String)e2;
                            } else {
                                if (!(e2 instanceof ASN1ObjectIdentifier)) continue;
                                string = ((ASN1ObjectIdentifier)e2).getId();
                            }
                            boolean bl2 = false;
                            Iterator iterator = pKIXPolicyNode2.getChildren();
                            while (iterator.hasNext()) {
                                object3 = (PKIXPolicyNode)iterator.next();
                                if (!string.equals(((PKIXPolicyNode)object3).getValidPolicy())) continue;
                                bl2 = true;
                            }
                            if (bl2) continue;
                            object3 = new HashSet();
                            object3.add(string);
                            PKIXPolicyNode pKIXPolicyNode3 = new PKIXPolicyNode(new ArrayList(), n5, (Set)object3, pKIXPolicyNode2, (Set)object, string, false);
                            pKIXPolicyNode2.addChild(pKIXPolicyNode3);
                            listArray[n5].add(pKIXPolicyNode3);
                        }
                    }
                }
            }
            object2 = pKIXPolicyNode;
            for (int i2 = n5 - 1; i2 >= 0; --i2) {
                collection = listArray[i2];
                for (n6 = 0; n6 < collection.size() && ((pKIXPolicyNode2 = (PKIXPolicyNode)collection.get(n6)).hasChildren() || (object2 = CertPathValidatorUtilities.removePolicyNode((PKIXPolicyNode)object2, listArray, pKIXPolicyNode2)) != null); ++n6) {
                }
            }
            Set<String> set2 = x509Certificate.getCriticalExtensionOIDs();
            if (set2 != null) {
                boolean bl3 = set2.contains(CERTIFICATE_POLICIES);
                List list2 = listArray[n5];
                for (int i3 = 0; i3 < list2.size(); ++i3) {
                    PKIXPolicyNode pKIXPolicyNode4 = (PKIXPolicyNode)list2.get(i3);
                    pKIXPolicyNode4.setCritical(bl3);
                }
            }
            return object2;
        }
        return null;
    }

    protected static void processCertA(CertPath certPath, PKIXExtendedParameters pKIXExtendedParameters, int n2, PublicKey publicKey, boolean bl2, X500Principal x500Principal, X509Certificate x509Certificate, Provider provider) throws CertPathValidatorException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate2 = (X509Certificate)list.get(n2);
        if (!bl2) {
            try {
                CertPathValidatorUtilities.verifyX509Certificate(x509Certificate2, publicKey, pKIXExtendedParameters.getSigProvider());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CertPathValidatorException("Could not validate certificate signature.", (Throwable)generalSecurityException, certPath, n2);
            }
        }
        try {
            x509Certificate2.checkValidity(CertPathValidatorUtilities.getValidCertDateFromValidityModel(pKIXExtendedParameters, certPath, n2));
        }
        catch (CertificateExpiredException certificateExpiredException) {
            throw new CertPathValidatorException("Could not validate certificate: " + certificateExpiredException.getMessage(), (Throwable)certificateExpiredException, certPath, n2);
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            throw new CertPathValidatorException("Could not validate certificate: " + certificateNotYetValidException.getMessage(), (Throwable)certificateNotYetValidException, certPath, n2);
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException("Could not validate time of certificate.", (Throwable)annotatedException, certPath, n2);
        }
        if (pKIXExtendedParameters.isRevocationEnabled()) {
            try {
                RFC3280CertPathUtilities.checkCRLs(pKIXExtendedParameters, x509Certificate2, CertPathValidatorUtilities.getValidCertDateFromValidityModel(pKIXExtendedParameters, certPath, n2), x509Certificate, publicKey, list, provider);
            }
            catch (AnnotatedException annotatedException) {
                Throwable throwable = annotatedException;
                if (null != annotatedException.getCause()) {
                    throwable = annotatedException.getCause();
                }
                throw new CertPathValidatorException(annotatedException.getMessage(), throwable, certPath, n2);
            }
        }
        if (!CertPathValidatorUtilities.getEncodedIssuerPrincipal(x509Certificate2).equals(x500Principal)) {
            throw new CertPathValidatorException("IssuerName(" + CertPathValidatorUtilities.getEncodedIssuerPrincipal(x509Certificate2) + ") does not match SubjectName(" + x500Principal + ") of signing certificate.", null, certPath, n2);
        }
    }

    protected static int prepareNextCertI1(CertPath certPath, int n2, int n3) throws CertPathValidatorException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        ASN1Sequence aSN1Sequence = null;
        try {
            aSN1Sequence = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, POLICY_CONSTRAINTS));
        }
        catch (Exception exception) {
            throw new CertPathValidatorException("Policy constraints extension cannot be decoded.", (Throwable)exception, certPath, n2);
        }
        if (aSN1Sequence != null) {
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                try {
                    ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement());
                    if (aSN1TaggedObject.getTagNo() != 0) continue;
                    int n4 = ASN1Integer.getInstance(aSN1TaggedObject, false).getValue().intValue();
                    if (n4 < n3) {
                        return n4;
                    }
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CertPathValidatorException("Policy constraints extension contents cannot be decoded.", (Throwable)illegalArgumentException, certPath, n2);
                }
            }
        }
        return n3;
    }

    protected static int prepareNextCertI2(CertPath certPath, int n2, int n3) throws CertPathValidatorException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        ASN1Sequence aSN1Sequence = null;
        try {
            aSN1Sequence = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, POLICY_CONSTRAINTS));
        }
        catch (Exception exception) {
            throw new CertPathValidatorException("Policy constraints extension cannot be decoded.", (Throwable)exception, certPath, n2);
        }
        if (aSN1Sequence != null) {
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                try {
                    ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement());
                    if (aSN1TaggedObject.getTagNo() != 1) continue;
                    int n4 = ASN1Integer.getInstance(aSN1TaggedObject, false).getValue().intValue();
                    if (n4 < n3) {
                        return n4;
                    }
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CertPathValidatorException("Policy constraints extension contents cannot be decoded.", (Throwable)illegalArgumentException, certPath, n2);
                }
            }
        }
        return n3;
    }

    protected static void prepareNextCertG(CertPath certPath, int n2, PKIXNameConstraintValidator pKIXNameConstraintValidator) throws CertPathValidatorException {
        GeneralSubtree[] generalSubtreeArray;
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        NameConstraints nameConstraints = null;
        try {
            generalSubtreeArray = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, NAME_CONSTRAINTS));
            if (generalSubtreeArray != null) {
                nameConstraints = NameConstraints.getInstance(generalSubtreeArray);
            }
        }
        catch (Exception exception) {
            throw new CertPathValidatorException("Name constraints extension could not be decoded.", (Throwable)exception, certPath, n2);
        }
        if (nameConstraints != null) {
            GeneralSubtree[] generalSubtreeArray2;
            generalSubtreeArray = nameConstraints.getPermittedSubtrees();
            if (generalSubtreeArray != null) {
                try {
                    pKIXNameConstraintValidator.intersectPermittedSubtree(generalSubtreeArray);
                }
                catch (Exception exception) {
                    throw new CertPathValidatorException("Permitted subtrees cannot be build from name constraints extension.", (Throwable)exception, certPath, n2);
                }
            }
            if ((generalSubtreeArray2 = nameConstraints.getExcludedSubtrees()) != null) {
                for (int i2 = 0; i2 != generalSubtreeArray2.length; ++i2) {
                    try {
                        pKIXNameConstraintValidator.addExcludedSubtree(generalSubtreeArray2[i2]);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new CertPathValidatorException("Excluded subtrees cannot be build from name constraints extension.", (Throwable)exception, certPath, n2);
                    }
                }
            }
        }
    }

    private static void checkCRL(DistributionPoint distributionPoint, PKIXExtendedParameters pKIXExtendedParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey, CertStatus certStatus, ReasonsMask reasonsMask, List list, Provider provider) throws AnnotatedException {
        Date date2 = new Date(System.currentTimeMillis());
        if (date.getTime() > date2.getTime()) {
            throw new AnnotatedException("Validation time is in future.");
        }
        Set set = CertPathValidatorUtilities.getCompleteCRLs(distributionPoint, x509Certificate, date2, pKIXExtendedParameters);
        boolean bl2 = false;
        AnnotatedException annotatedException = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
            try {
                Set<String> set2;
                X509CRL x509CRL = (X509CRL)iterator.next();
                ReasonsMask reasonsMask2 = RFC3280CertPathUtilities.processCRLD(x509CRL, distributionPoint);
                if (!reasonsMask2.hasNewReasons(reasonsMask)) continue;
                Set set3 = RFC3280CertPathUtilities.processCRLF(x509CRL, x509Certificate, x509Certificate2, publicKey, pKIXExtendedParameters, list, provider);
                PublicKey publicKey2 = RFC3280CertPathUtilities.processCRLG(x509CRL, set3);
                X509CRL x509CRL2 = null;
                Date date3 = date2;
                if (pKIXExtendedParameters.getDate() != null) {
                    date3 = pKIXExtendedParameters.getDate();
                }
                if (pKIXExtendedParameters.isUseDeltasEnabled()) {
                    set2 = CertPathValidatorUtilities.getDeltaCRLs(date3, x509CRL, pKIXExtendedParameters.getCertStores(), pKIXExtendedParameters.getCRLStores());
                    x509CRL2 = RFC3280CertPathUtilities.processCRLH(set2, publicKey2);
                }
                if (pKIXExtendedParameters.getValidityModel() != 1 && x509Certificate.getNotAfter().getTime() < x509CRL.getThisUpdate().getTime()) {
                    throw new AnnotatedException("No valid CRL for current time found.");
                }
                RFC3280CertPathUtilities.processCRLB1(distributionPoint, x509Certificate, x509CRL);
                RFC3280CertPathUtilities.processCRLB2(distributionPoint, x509Certificate, x509CRL);
                RFC3280CertPathUtilities.processCRLC(x509CRL2, x509CRL, pKIXExtendedParameters);
                RFC3280CertPathUtilities.processCRLI(date, x509CRL2, x509Certificate, certStatus, pKIXExtendedParameters);
                RFC3280CertPathUtilities.processCRLJ(date, x509CRL, x509Certificate, certStatus);
                if (certStatus.getCertStatus() == 8) {
                    certStatus.setCertStatus(11);
                }
                reasonsMask.addReasons(reasonsMask2);
                set2 = x509CRL.getCriticalExtensionOIDs();
                if (set2 != null) {
                    set2 = new HashSet<String>(set2);
                    set2.remove(Extension.issuingDistributionPoint.getId());
                    set2.remove(Extension.deltaCRLIndicator.getId());
                    if (!set2.isEmpty()) {
                        throw new AnnotatedException("CRL contains unsupported critical extensions.");
                    }
                }
                if (x509CRL2 != null && (set2 = x509CRL2.getCriticalExtensionOIDs()) != null) {
                    set2 = new HashSet<String>(set2);
                    set2.remove(Extension.issuingDistributionPoint.getId());
                    set2.remove(Extension.deltaCRLIndicator.getId());
                    if (!set2.isEmpty()) {
                        throw new AnnotatedException("Delta CRL contains unsupported critical extension.");
                    }
                }
                bl2 = true;
            }
            catch (AnnotatedException annotatedException2) {
                annotatedException = annotatedException2;
            }
        }
        if (!bl2) {
            throw annotatedException;
        }
    }

    protected static void checkCRLs(PKIXExtendedParameters pKIXExtendedParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey, List list, Provider provider) throws AnnotatedException {
        Object object;
        Object object2;
        Object object3;
        AnnotatedException annotatedException = null;
        CRLDistPoint cRLDistPoint = null;
        try {
            cRLDistPoint = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, CRL_DISTRIBUTION_POINTS));
        }
        catch (Exception exception) {
            throw new AnnotatedException("CRL distribution point extension could not be read.", exception);
        }
        PKIXExtendedParameters.Builder builder = new PKIXExtendedParameters.Builder(pKIXExtendedParameters);
        try {
            object3 = CertPathValidatorUtilities.getAdditionalStoresFromCRLDistributionPoint(cRLDistPoint, pKIXExtendedParameters.getNamedCRLStoreMap());
            object2 = object3.iterator();
            while (object2.hasNext()) {
                builder.addCRLStore(object2.next());
            }
        }
        catch (AnnotatedException annotatedException2) {
            throw new AnnotatedException("No additional CRL locations could be decoded from CRL distribution point extension.", annotatedException2);
        }
        object3 = new CertStatus();
        object2 = new ReasonsMask();
        PKIXExtendedParameters pKIXExtendedParameters2 = builder.build();
        boolean bl2 = false;
        if (cRLDistPoint != null) {
            object = null;
            try {
                object = cRLDistPoint.getDistributionPoints();
            }
            catch (Exception exception) {
                throw new AnnotatedException("Distribution points could not be read.", exception);
            }
            if (object != null) {
                for (int i2 = 0; i2 < ((DistributionPoint[])object).length && ((CertStatus)object3).getCertStatus() == 11 && !((ReasonsMask)object2).isAllReasons(); ++i2) {
                    try {
                        RFC3280CertPathUtilities.checkCRL((DistributionPoint)object[i2], pKIXExtendedParameters2, x509Certificate, date, x509Certificate2, publicKey, (CertStatus)object3, (ReasonsMask)object2, list, provider);
                        bl2 = true;
                        continue;
                    }
                    catch (AnnotatedException annotatedException3) {
                        annotatedException = annotatedException3;
                    }
                }
            }
        }
        if (((CertStatus)object3).getCertStatus() == 11 && !((ReasonsMask)object2).isAllReasons()) {
            try {
                object = null;
                try {
                    object = ASN1Primitive.fromByteArray(CertPathValidatorUtilities.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Issuer from certificate for CRL could not be reencoded.", exception);
                }
                DistributionPoint distributionPoint = new DistributionPoint(new DistributionPointName(0, new GeneralNames(new GeneralName(4, (ASN1Encodable)object))), null, null);
                PKIXExtendedParameters pKIXExtendedParameters3 = (PKIXExtendedParameters)pKIXExtendedParameters.clone();
                RFC3280CertPathUtilities.checkCRL(distributionPoint, pKIXExtendedParameters3, x509Certificate, date, x509Certificate2, publicKey, (CertStatus)object3, (ReasonsMask)object2, list, provider);
                bl2 = true;
            }
            catch (AnnotatedException annotatedException4) {
                annotatedException = annotatedException4;
            }
        }
        if (!bl2) {
            if (annotatedException instanceof AnnotatedException) {
                throw annotatedException;
            }
            throw new AnnotatedException("No valid CRL found.", annotatedException);
        }
        if (((CertStatus)object3).getCertStatus() != 11) {
            object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("UTC"));
            String string = "Certificate revocation after " + ((DateFormat)object).format(((CertStatus)object3).getRevocationDate());
            string = string + ", reason: " + crlReasons[((CertStatus)object3).getCertStatus()];
            throw new AnnotatedException(string);
        }
        if (!((ReasonsMask)object2).isAllReasons() && ((CertStatus)object3).getCertStatus() == 11) {
            ((CertStatus)object3).setCertStatus(12);
        }
        if (((CertStatus)object3).getCertStatus() == 12) {
            throw new AnnotatedException("Certificate status could not be determined.");
        }
    }

    protected static int prepareNextCertJ(CertPath certPath, int n2, int n3) throws CertPathValidatorException {
        int n4;
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        ASN1Integer aSN1Integer = null;
        try {
            aSN1Integer = ASN1Integer.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, INHIBIT_ANY_POLICY));
        }
        catch (Exception exception) {
            throw new CertPathValidatorException("Inhibit any-policy extension cannot be decoded.", (Throwable)exception, certPath, n2);
        }
        if (aSN1Integer != null && (n4 = aSN1Integer.getValue().intValue()) < n3) {
            return n4;
        }
        return n3;
    }

    protected static void prepareNextCertK(CertPath certPath, int n2) throws CertPathValidatorException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        BasicConstraints basicConstraints = null;
        try {
            basicConstraints = BasicConstraints.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
        }
        catch (Exception exception) {
            throw new CertPathValidatorException("Basic constraints extension cannot be decoded.", (Throwable)exception, certPath, n2);
        }
        if (basicConstraints != null) {
            if (!basicConstraints.isCA()) {
                throw new CertPathValidatorException("Not a CA certificate");
            }
        } else {
            throw new CertPathValidatorException("Intermediate certificate lacks BasicConstraints");
        }
    }

    protected static int prepareNextCertL(CertPath certPath, int n2, int n3) throws CertPathValidatorException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        if (!CertPathValidatorUtilities.isSelfIssued(x509Certificate)) {
            if (n3 <= 0) {
                throw new CertPathValidatorException("Max path length not greater than zero", null, certPath, n2);
            }
            return n3 - 1;
        }
        return n3;
    }

    protected static int prepareNextCertM(CertPath certPath, int n2, int n3) throws CertPathValidatorException {
        int n4;
        BigInteger bigInteger;
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        BasicConstraints basicConstraints = null;
        try {
            basicConstraints = BasicConstraints.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
        }
        catch (Exception exception) {
            throw new CertPathValidatorException("Basic constraints extension cannot be decoded.", (Throwable)exception, certPath, n2);
        }
        if (basicConstraints != null && (bigInteger = basicConstraints.getPathLenConstraint()) != null && (n4 = bigInteger.intValue()) < n3) {
            return n4;
        }
        return n3;
    }

    protected static void prepareNextCertN(CertPath certPath, int n2) throws CertPathValidatorException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null && !blArray[5]) {
            throw new CertPathValidatorException("Issuer certificate keyusage extension is critical and does not permit key signing.", null, certPath, n2);
        }
    }

    protected static void prepareNextCertO(CertPath certPath, int n2, Set set, List list) throws CertPathValidatorException {
        List<? extends Certificate> list2 = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list2.get(n2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                ((PKIXCertPathChecker)iterator.next()).check(x509Certificate, set);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n2);
            }
        }
        if (!set.isEmpty()) {
            throw new CertPathValidatorException("Certificate has unsupported critical extension: " + set, null, certPath, n2);
        }
    }

    protected static int prepareNextCertH1(CertPath certPath, int n2, int n3) {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        if (!CertPathValidatorUtilities.isSelfIssued(x509Certificate) && n3 != 0) {
            return n3 - 1;
        }
        return n3;
    }

    protected static int prepareNextCertH2(CertPath certPath, int n2, int n3) {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        if (!CertPathValidatorUtilities.isSelfIssued(x509Certificate) && n3 != 0) {
            return n3 - 1;
        }
        return n3;
    }

    protected static int prepareNextCertH3(CertPath certPath, int n2, int n3) {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        if (!CertPathValidatorUtilities.isSelfIssued(x509Certificate) && n3 != 0) {
            return n3 - 1;
        }
        return n3;
    }

    protected static int wrapupCertA(int n2, X509Certificate x509Certificate) {
        if (!CertPathValidatorUtilities.isSelfIssued(x509Certificate) && n2 != 0) {
            --n2;
        }
        return n2;
    }

    protected static int wrapupCertB(CertPath certPath, int n2, int n3) throws CertPathValidatorException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list.get(n2);
        ASN1Sequence aSN1Sequence = null;
        try {
            aSN1Sequence = DERSequence.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, POLICY_CONSTRAINTS));
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException("Policy constraints could not be decoded.", (Throwable)annotatedException, certPath, n2);
        }
        if (aSN1Sequence != null) {
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        int n4;
                        try {
                            n4 = ASN1Integer.getInstance(aSN1TaggedObject, false).getValue().intValue();
                        }
                        catch (Exception exception) {
                            throw new CertPathValidatorException("Policy constraints requireExplicitPolicy field could not be decoded.", (Throwable)exception, certPath, n2);
                        }
                        if (n4 != 0) break;
                        return 0;
                    }
                }
            }
        }
        return n3;
    }

    protected static void wrapupCertF(CertPath certPath, int n2, List list, Set set) throws CertPathValidatorException {
        List<? extends Certificate> list2 = certPath.getCertificates();
        X509Certificate x509Certificate = (X509Certificate)list2.get(n2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                ((PKIXCertPathChecker)iterator.next()).check(x509Certificate, set);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Additional certificate path checker failed.", (Throwable)certPathValidatorException, certPath, n2);
            }
        }
        if (!set.isEmpty()) {
            throw new CertPathValidatorException("Certificate has unsupported critical extension: " + set, null, certPath, n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static PKIXPolicyNode wrapupCertG(CertPath certPath, PKIXExtendedParameters pKIXExtendedParameters, Set set, int n2, List[] listArray, PKIXPolicyNode pKIXPolicyNode, Set set2) throws CertPathValidatorException {
        PKIXPolicyNode pKIXPolicyNode2;
        int n3 = certPath.getCertificates().size();
        if (pKIXPolicyNode == null) {
            if (pKIXExtendedParameters.isExplicitPolicyRequired()) {
                throw new CertPathValidatorException("Explicit policy requested but none available.", null, certPath, n2);
            }
            pKIXPolicyNode2 = null;
        } else if (CertPathValidatorUtilities.isAnyPolicy(set)) {
            if (pKIXExtendedParameters.isExplicitPolicyRequired()) {
                void var11_19;
                Object object;
                if (set2.isEmpty()) {
                    throw new CertPathValidatorException("Explicit policy requested but none available.", null, certPath, n2);
                }
                HashSet hashSet = new HashSet();
                for (int i2 = 0; i2 < listArray.length; ++i2) {
                    List object2 = listArray[i2];
                    for (int list = 0; list < object2.size(); ++list) {
                        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)object2.get(list);
                        if (!ANY_POLICY.equals(pKIXPolicyNode3.getValidPolicy())) continue;
                        object = pKIXPolicyNode3.getChildren();
                        while (object.hasNext()) {
                            hashSet.add(object.next());
                        }
                    }
                }
                for (PKIXPolicyNode object3 : hashSet) {
                    String string = object3.getValidPolicy();
                    if (set2.contains(string)) continue;
                }
                int i8 = n3 - 1;
                while (var11_19 >= 0) {
                    List list = listArray[var11_19];
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        object = (PKIXPolicyNode)list.get(i2);
                        if (((PKIXPolicyNode)object).hasChildren()) continue;
                        pKIXPolicyNode = CertPathValidatorUtilities.removePolicyNode(pKIXPolicyNode, listArray, (PKIXPolicyNode)object);
                    }
                    --var11_19;
                }
            }
            pKIXPolicyNode2 = pKIXPolicyNode;
        } else {
            Object object;
            HashSet<PKIXPolicyNode> hashSet = new HashSet<PKIXPolicyNode>();
            for (int i6 = 0; i6 < listArray.length; ++i6) {
                List list = listArray[i6];
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    PKIXPolicyNode pKIXPolicyNode4 = (PKIXPolicyNode)list.get(i3);
                    if (!ANY_POLICY.equals(pKIXPolicyNode4.getValidPolicy())) continue;
                    object = pKIXPolicyNode4.getChildren();
                    while (object.hasNext()) {
                        PKIXPolicyNode pKIXPolicyNode5 = (PKIXPolicyNode)object.next();
                        if (ANY_POLICY.equals(pKIXPolicyNode5.getValidPolicy())) continue;
                        hashSet.add(pKIXPolicyNode5);
                    }
                }
            }
            for (PKIXPolicyNode pKIXPolicyNode6 : hashSet) {
                String string = pKIXPolicyNode6.getValidPolicy();
                if (set.contains(string)) continue;
                pKIXPolicyNode = CertPathValidatorUtilities.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode6);
            }
            if (pKIXPolicyNode != null) {
                void var11_24;
                int n4 = n3 - 1;
                while (var11_24 >= 0) {
                    List list = listArray[var11_24];
                    for (int i4 = 0; i4 < list.size(); ++i4) {
                        object = (PKIXPolicyNode)list.get(i4);
                        if (((PKIXPolicyNode)object).hasChildren()) continue;
                        pKIXPolicyNode = CertPathValidatorUtilities.removePolicyNode(pKIXPolicyNode, listArray, (PKIXPolicyNode)object);
                    }
                    --var11_24;
                }
            }
            pKIXPolicyNode2 = pKIXPolicyNode;
        }
        return pKIXPolicyNode2;
    }

    static {
        CERT_SUPPORTED_CRITICAL_EXTENSIONS.add(KEY_USAGE);
        CERT_SUPPORTED_CRITICAL_EXTENSIONS.add(CERTIFICATE_POLICIES);
        CERT_SUPPORTED_CRITICAL_EXTENSIONS.add(POLICY_MAPPINGS);
        CERT_SUPPORTED_CRITICAL_EXTENSIONS.add(INHIBIT_ANY_POLICY);
        CERT_SUPPORTED_CRITICAL_EXTENSIONS.add(ISSUING_DISTRIBUTION_POINT);
        CERT_SUPPORTED_CRITICAL_EXTENSIONS.add(DELTA_CRL_INDICATOR);
        CERT_SUPPORTED_CRITICAL_EXTENSIONS.add(POLICY_CONSTRAINTS);
        CERT_SUPPORTED_CRITICAL_EXTENSIONS.add(BASIC_CONSTRAINTS);
        CERT_SUPPORTED_CRITICAL_EXTENSIONS.add(SUBJECT_ALTERNATIVE_NAME);
        CERT_SUPPORTED_CRITICAL_EXTENSIONS.add(NAME_CONSTRAINTS);
        CRL_SUPPORTED_CRITICAL_EXTENSIONS.add(ISSUING_DISTRIBUTION_POINT);
        CRL_SUPPORTED_CRITICAL_EXTENSIONS.add(DELTA_CRL_INDICATOR);
        crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};
    }
}

