/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1InputStream;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Object;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.bc.EncryptedObjectStoreData;
import com.aspose.html.internal.ms.core.bc.asn1.bc.EncryptedPrivateKeyData;
import com.aspose.html.internal.ms.core.bc.asn1.bc.EncryptedSecretKeyData;
import com.aspose.html.internal.ms.core.bc.asn1.bc.ObjectData;
import com.aspose.html.internal.ms.core.bc.asn1.bc.ObjectDataSequence;
import com.aspose.html.internal.ms.core.bc.asn1.bc.ObjectStore;
import com.aspose.html.internal.ms.core.bc.asn1.bc.ObjectStoreData;
import com.aspose.html.internal.ms.core.bc.asn1.bc.ObjectStoreIntegrityCheck;
import com.aspose.html.internal.ms.core.bc.asn1.bc.PbkdMacIntegrityCheck;
import com.aspose.html.internal.ms.core.bc.asn1.bc.SecretKeyData;
import com.aspose.html.internal.ms.core.bc.asn1.cms.CCMParameters;
import com.aspose.html.internal.ms.core.bc.asn1.nist.NISTObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.EncryptionScheme;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.KeyDerivationFunc;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PBES2Parameters;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PBKDF2Params;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.crypto.CipherOutputStream;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordBasedDeriver;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordConverter;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricSecretKey;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAES;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsOutputAEADDecryptor;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsOutputAEADEncryptor;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsPBKD;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.jcajce.ConsistentKeyPair;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AlgorithmProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvIOException;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.X509CertificateObject;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

class ProvBCFKS
extends AlgorithmProvider {
    private static final Map<String, ASN1ObjectIdentifier> oidMap = new HashMap<String, ASN1ObjectIdentifier>();
    private static final Map<ASN1ObjectIdentifier, String> publicAlgMap = new HashMap<ASN1ObjectIdentifier, String>();
    private static final String PREFIX = "com.aspose.html.internal.ms.core.bc.jcajce.provider.keystore.bcfks.";

    ProvBCFKS() {
    }

    private static String getPublicKeyAlg(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = publicAlgMap.get(aSN1ObjectIdentifier);
        if (string != null) {
            return string;
        }
        return aSN1ObjectIdentifier.getId();
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.BCFKS", "com.aspose.html.internal.ms.core.bc.jcajce.provider.keystore.bcfks.BCFKSKeyStore", new EngineCreator(){

            public Object createInstance(Object object) {
                return new BCFIPSKeyStoreSpi(bouncyCastleFipsProvider);
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.BCFKS-DEF", "com.aspose.html.internal.ms.core.bc.jcajce.provider.keystore.bcfks.BCFKSDefKeyStore", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BCFIPSKeyStoreSpi(null);
                }
            }));
        }
    }

    static {
        oidMap.put("DESEDE", OIWObjectIdentifiers.desEDE);
        oidMap.put("TRIPLEDES", OIWObjectIdentifiers.desEDE);
        oidMap.put("TDEA", OIWObjectIdentifiers.desEDE);
        oidMap.put("HMACSHA1", PKCSObjectIdentifiers.id_hmacWithSHA1);
        oidMap.put("HMACSHA224", PKCSObjectIdentifiers.id_hmacWithSHA224);
        oidMap.put("HMACSHA256", PKCSObjectIdentifiers.id_hmacWithSHA256);
        oidMap.put("HMACSHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        oidMap.put("HMACSHA512", PKCSObjectIdentifiers.id_hmacWithSHA512);
        publicAlgMap.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        publicAlgMap.put(X9ObjectIdentifiers.id_ecPublicKey, "EC");
        publicAlgMap.put(OIWObjectIdentifiers.elGamalAlgorithm, "DH");
        publicAlgMap.put(PKCSObjectIdentifiers.dhKeyAgreement, "DH");
        publicAlgMap.put(X9ObjectIdentifiers.id_dsa, "DSA");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BCFIPSKeyStoreSpi
    extends KeyStoreSpi {
        private static final BigInteger CERTIFICATE = BigInteger.valueOf(0L);
        private static final BigInteger PRIVATE_KEY = BigInteger.valueOf(1L);
        private static final BigInteger SECRET_KEY = BigInteger.valueOf(2L);
        private static final BigInteger PROTECTED_PRIVATE_KEY = BigInteger.valueOf(3L);
        private static final BigInteger PROTECTED_SECRET_KEY = BigInteger.valueOf(4L);
        private final BouncyCastleFipsProvider fipsProvider;
        private final Map<String, ObjectData> entries = new HashMap<String, ObjectData>();
        private final Map<String, PrivateKey> privateKeyCache = new HashMap<String, PrivateKey>();
        private AlgorithmIdentifier hmacAlgorithm;
        private KeyDerivationFunc hmacPkbdAlgorithm;
        private Date creationDate;
        private Date lastModifiedDate;

        BCFIPSKeyStoreSpi(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            this.fipsProvider = bouncyCastleFipsProvider;
        }

        @Override
        public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                if (objectData.getType().equals(PRIVATE_KEY) || objectData.getType().equals(PROTECTED_PRIVATE_KEY)) {
                    PrivateKey privateKey = this.privateKeyCache.get(string);
                    if (privateKey != null) {
                        return privateKey;
                    }
                    EncryptedPrivateKeyData encryptedPrivateKeyData = EncryptedPrivateKeyData.getInstance(objectData.getData());
                    EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance(encryptedPrivateKeyData.getEncryptedPrivateKeyInfo());
                    try {
                        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(this.decryptData("PRIVATE_KEY_ENCRYPTION", encryptedPrivateKeyInfo.getEncryptionAlgorithm(), cArray, encryptedPrivateKeyInfo.getEncryptedData()));
                        KeyFactory keyFactory = this.fipsProvider != null ? KeyFactory.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm().getId(), this.fipsProvider) : KeyFactory.getInstance(ProvBCFKS.getPublicKeyAlg(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()));
                        PrivateKey privateKey2 = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded()));
                        new ConsistentKeyPair(this.engineGetCertificate(string).getPublicKey(), privateKey2);
                        this.privateKeyCache.put(string, privateKey2);
                        return privateKey2;
                    }
                    catch (Exception exception) {
                        throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover private key (" + string + "): " + exception.getMessage());
                    }
                }
                if (objectData.getType().equals(SECRET_KEY) || objectData.getType().equals(PROTECTED_SECRET_KEY)) {
                    EncryptedSecretKeyData encryptedSecretKeyData = EncryptedSecretKeyData.getInstance(objectData.getData());
                    try {
                        SecretKeyData secretKeyData = SecretKeyData.getInstance(this.decryptData("SECRET_KEY_ENCRYPTION", encryptedSecretKeyData.getKeyEncryptionAlgorithm(), cArray, encryptedSecretKeyData.getEncryptedKeyData()));
                        SecretKeyFactory secretKeyFactory = this.fipsProvider != null ? SecretKeyFactory.getInstance(secretKeyData.getKeyAlgorithm().getId(), this.fipsProvider) : SecretKeyFactory.getInstance(secretKeyData.getKeyAlgorithm().getId());
                        return secretKeyFactory.generateSecret(new SecretKeySpec(secretKeyData.getKeyBytes(), secretKeyData.getKeyAlgorithm().getId()));
                    }
                    catch (Exception exception) {
                        throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover secret key (" + string + "): " + exception.getMessage());
                    }
                }
                throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover secret key (" + string + "): type not recognized");
            }
            return null;
        }

        @Override
        public Certificate[] engineGetCertificateChain(String string) {
            ObjectData objectData = this.entries.get(string);
            if (objectData != null && (objectData.getType().equals(PRIVATE_KEY) || objectData.getType().equals(PROTECTED_PRIVATE_KEY))) {
                EncryptedPrivateKeyData encryptedPrivateKeyData = EncryptedPrivateKeyData.getInstance(objectData.getData());
                com.aspose.html.internal.ms.core.bc.asn1.x509.Certificate[] certificateArray = encryptedPrivateKeyData.getCertificateChain();
                Certificate[] certificateArray2 = new X509Certificate[certificateArray.length];
                for (int i2 = 0; i2 != certificateArray2.length; ++i2) {
                    certificateArray2[i2] = this.decodeCertificate(certificateArray[i2]);
                }
                return certificateArray2;
            }
            return null;
        }

        @Override
        public Certificate engineGetCertificate(String string) {
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                if (objectData.getType().equals(PRIVATE_KEY) || objectData.getType().equals(PROTECTED_PRIVATE_KEY)) {
                    EncryptedPrivateKeyData encryptedPrivateKeyData = EncryptedPrivateKeyData.getInstance(objectData.getData());
                    com.aspose.html.internal.ms.core.bc.asn1.x509.Certificate[] certificateArray = encryptedPrivateKeyData.getCertificateChain();
                    return this.decodeCertificate(certificateArray[0]);
                }
                if (objectData.getType().equals(CERTIFICATE)) {
                    return this.decodeCertificate(objectData.getData());
                }
            }
            return null;
        }

        private Certificate decodeCertificate(Object object) {
            try {
                if (this.fipsProvider != null) {
                    return new X509CertificateObject(this.fipsProvider, com.aspose.html.internal.ms.core.bc.asn1.x509.Certificate.getInstance(object));
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    return certificateFactory.generateCertificate(new ByteArrayInputStream(com.aspose.html.internal.ms.core.bc.asn1.x509.Certificate.getInstance(object).getEncoded()));
                }
                catch (Exception exception) {
                    return new X509CertificateObject(null, com.aspose.html.internal.ms.core.bc.asn1.x509.Certificate.getInstance(object));
                }
            }
            catch (CertificateParsingException certificateParsingException) {
                return null;
            }
        }

        @Override
        public Date engineGetCreationDate(String string) {
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                try {
                    return objectData.getLastModifiedDate().getDate();
                }
                catch (ParseException parseException) {
                    return new Date();
                }
            }
            return null;
        }

        @Override
        public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
            Date date;
            Date date2 = date = new Date();
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                date = this.extractCreationDate(objectData, date);
            }
            this.privateKeyCache.remove(string);
            if (key instanceof PrivateKey) {
                if (certificateArray == null) {
                    throw new KeyStoreException("BCFKS KeyStore requires a certificate chain for private key storage.");
                }
                try {
                    new ConsistentKeyPair(certificateArray[0].getPublicKey(), (PrivateKey)key);
                    byte[] byArray = key.getEncoded();
                    KeyDerivationFunc keyDerivationFunc = this.generatePkbdAlgorithmIdentifier(32);
                    byte[] byArray2 = this.generateKey(keyDerivationFunc, "PRIVATE_KEY_ENCRYPTION", cArray != null ? cArray : new char[]{});
                    FipsAES.AEADOperatorFactory aEADOperatorFactory = new FipsAES.AEADOperatorFactory();
                    FipsAES.AuthParameters authParameters = FipsAES.CCM.withIV(this.getDefaultSecureRandom());
                    FipsOutputAEADEncryptor<FipsAES.AuthParameters> fipsOutputAEADEncryptor = aEADOperatorFactory.createOutputAEADEncryptor((SymmetricKey)new SymmetricSecretKey(FipsAES.CCM, byArray2), authParameters);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    CipherOutputStream cipherOutputStream = fipsOutputAEADEncryptor.getEncryptingStream(byteArrayOutputStream);
                    cipherOutputStream.write(byArray);
                    ((OutputStream)cipherOutputStream).close();
                    PBES2Parameters pBES2Parameters = new PBES2Parameters(keyDerivationFunc, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, new CCMParameters(authParameters.getIV(), authParameters.getMACSizeInBits() / 8)));
                    EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pBES2Parameters), byteArrayOutputStream.toByteArray());
                    EncryptedPrivateKeyData encryptedPrivateKeyData = this.createPrivateKeySequence(encryptedPrivateKeyInfo, certificateArray);
                    this.entries.put(string, new ObjectData(PRIVATE_KEY, string, date, date2, encryptedPrivateKeyData.getEncoded(), null));
                }
                catch (Exception exception) {
                    throw new KeyStoreException("BCFKS KeyStore exception storing private key: " + exception.toString(), exception);
                }
            } else if (key instanceof SecretKey) {
                if (certificateArray != null) {
                    throw new KeyStoreException("BCFKS KeyStore cannot store certificate chain with secret key.");
                }
                try {
                    ASN1Object aSN1Object;
                    byte[] byArray = key.getEncoded();
                    KeyDerivationFunc keyDerivationFunc = this.generatePkbdAlgorithmIdentifier(32);
                    byte[] byArray3 = this.generateKey(keyDerivationFunc, "SECRET_KEY_ENCRYPTION", cArray != null ? cArray : new char[]{});
                    FipsAES.AEADOperatorFactory aEADOperatorFactory = new FipsAES.AEADOperatorFactory();
                    FipsAES.AuthParameters authParameters = FipsAES.CCM.withIV(this.getDefaultSecureRandom());
                    FipsOutputAEADEncryptor<FipsAES.AuthParameters> fipsOutputAEADEncryptor = aEADOperatorFactory.createOutputAEADEncryptor((SymmetricKey)new SymmetricSecretKey(FipsAES.CCM, byArray3), authParameters);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    CipherOutputStream cipherOutputStream = fipsOutputAEADEncryptor.getEncryptingStream(byteArrayOutputStream);
                    String string2 = Strings.toUpperCase(key.getAlgorithm());
                    if (string2.contains("AES")) {
                        cipherOutputStream.write(new SecretKeyData(NISTObjectIdentifiers.aes, byArray).getEncoded());
                    } else {
                        aSN1Object = (ASN1ObjectIdentifier)oidMap.get(string2);
                        if (aSN1Object != null) {
                            cipherOutputStream.write(new SecretKeyData((ASN1ObjectIdentifier)aSN1Object, byArray).getEncoded());
                        } else {
                            throw new KeyStoreException("BCFKS KeyStore cannot recognize secret key (" + string2 + ") for storage.");
                        }
                    }
                    ((OutputStream)cipherOutputStream).close();
                    aSN1Object = new PBES2Parameters(keyDerivationFunc, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, new CCMParameters(authParameters.getIV(), authParameters.getMACSizeInBits() / 8)));
                    EncryptedSecretKeyData encryptedSecretKeyData = new EncryptedSecretKeyData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, aSN1Object), byteArrayOutputStream.toByteArray());
                    this.entries.put(string, new ObjectData(SECRET_KEY, string, date, date2, encryptedSecretKeyData.getEncoded(), null));
                }
                catch (Exception exception) {
                    throw new KeyStoreException("BCFKS KeyStore exception storing private key: " + exception.toString(), exception);
                }
            } else {
                throw new KeyStoreException("BCFKS KeyStore unable to recognize key.");
            }
            this.lastModifiedDate = date2;
        }

        private SecureRandom getDefaultSecureRandom() {
            if (this.fipsProvider != null) {
                return this.fipsProvider.getDefaultSecureRandom();
            }
            return new SecureRandom();
        }

        private EncryptedPrivateKeyData createPrivateKeySequence(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, Certificate[] certificateArray) throws CertificateEncodingException {
            com.aspose.html.internal.ms.core.bc.asn1.x509.Certificate[] certificateArray2 = new com.aspose.html.internal.ms.core.bc.asn1.x509.Certificate[certificateArray.length];
            for (int i2 = 0; i2 != certificateArray.length; ++i2) {
                certificateArray2[i2] = com.aspose.html.internal.ms.core.bc.asn1.x509.Certificate.getInstance(certificateArray[i2].getEncoded());
            }
            return new EncryptedPrivateKeyData(encryptedPrivateKeyInfo, certificateArray2);
        }

        @Override
        public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
            Date date;
            Date date2 = date = new Date();
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                date = this.extractCreationDate(objectData, date);
            }
            if (certificateArray != null) {
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
                try {
                    encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance(byArray);
                }
                catch (Exception exception) {
                    throw new KeyStoreException("BCFKS KeyStore private key encoding must be an EncryptedPrivateKeyInfo.", exception);
                }
                try {
                    this.privateKeyCache.remove(string);
                    this.entries.put(string, new ObjectData(PROTECTED_PRIVATE_KEY, string, date, date2, this.createPrivateKeySequence(encryptedPrivateKeyInfo, certificateArray).getEncoded(), null));
                }
                catch (Exception exception) {
                    throw new KeyStoreException("BCFKS KeyStore exception storing protected private key: " + exception.toString(), exception);
                }
            }
            try {
                this.entries.put(string, new ObjectData(PROTECTED_SECRET_KEY, string, date, date2, byArray, null));
            }
            catch (Exception exception) {
                throw new KeyStoreException("BCFKS KeyStore exception storing protected private key: " + exception.toString(), exception);
            }
            this.lastModifiedDate = date2;
        }

        @Override
        public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
            Date date;
            ObjectData objectData = this.entries.get(string);
            Date date2 = date = new Date();
            if (objectData != null) {
                if (!objectData.getType().equals(CERTIFICATE)) {
                    throw new KeyStoreException("BCFKS KeyStore already has a key entry with alias " + string);
                }
                date = this.extractCreationDate(objectData, date);
            }
            try {
                this.entries.put(string, new ObjectData(CERTIFICATE, string, date, date2, certificate.getEncoded(), null));
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new KeyStoreException("BCFKS KeyStore unable to handle certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
            }
            this.lastModifiedDate = date2;
        }

        private Date extractCreationDate(ObjectData objectData, Date date) {
            try {
                date = objectData.getCreationDate().getDate();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return date;
        }

        @Override
        public void engineDeleteEntry(String string) throws KeyStoreException {
            ObjectData objectData = this.entries.get(string);
            if (objectData == null) {
                return;
            }
            this.privateKeyCache.remove(string);
            this.entries.remove(string);
            this.lastModifiedDate = new Date();
        }

        @Override
        public Enumeration<String> engineAliases() {
            final Iterator<String> iterator = new HashSet<String>(this.entries.keySet()).iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)iterator.next();
                }
            };
        }

        @Override
        public boolean engineContainsAlias(String string) {
            if (string == null) {
                throw new NullPointerException("alias value is null");
            }
            return this.entries.containsKey(string);
        }

        @Override
        public int engineSize() {
            return this.entries.size();
        }

        @Override
        public boolean engineIsKeyEntry(String string) {
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                BigInteger bigInteger = objectData.getType();
                return bigInteger.equals(PRIVATE_KEY) || bigInteger.equals(SECRET_KEY) || bigInteger.equals(PROTECTED_PRIVATE_KEY) || bigInteger.equals(PROTECTED_SECRET_KEY);
            }
            return false;
        }

        @Override
        public boolean engineIsCertificateEntry(String string) {
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                return objectData.getType().equals(CERTIFICATE);
            }
            return false;
        }

        @Override
        public String engineGetCertificateAlias(Certificate certificate) {
            byte[] byArray;
            if (certificate == null) {
                return null;
            }
            try {
                byArray = certificate.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                return null;
            }
            for (String string : this.entries.keySet()) {
                ObjectData objectData = this.entries.get(string);
                if (objectData.getType().equals(CERTIFICATE)) {
                    if (!Arrays.areEqual(objectData.getData(), byArray)) continue;
                    return string;
                }
                if (!objectData.getType().equals(PRIVATE_KEY) && !objectData.getType().equals(PROTECTED_PRIVATE_KEY)) continue;
                try {
                    EncryptedPrivateKeyData encryptedPrivateKeyData = EncryptedPrivateKeyData.getInstance(objectData.getData());
                    if (!Arrays.areEqual(encryptedPrivateKeyData.getCertificateChain()[0].toASN1Primitive().getEncoded(), byArray)) continue;
                    return string;
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }

        private byte[] generateKey(KeyDerivationFunc keyDerivationFunc, String string, char[] cArray) throws IOException {
            Object object;
            FipsPBKD.DeriverFactory deriverFactory = new FipsPBKD.DeriverFactory();
            byte[] byArray = PasswordConverter.PKCS12.convert(cArray);
            byte[] byArray2 = PasswordConverter.PKCS12.convert(string.toCharArray());
            if (keyDerivationFunc.getAlgorithm().equals(PKCSObjectIdentifiers.id_PBKDF2)) {
                object = PBKDF2Params.getInstance(keyDerivationFunc.getParameters());
                if (!((PBKDF2Params)object).getPrf().getAlgorithm().equals(PKCSObjectIdentifiers.id_hmacWithSHA512)) {
                    throw new IOException("BCFKS KeyStore: unrecognized MAC PBKD PRF.");
                }
            } else {
                throw new IOException("BCFKS KeyStore: unrecognized MAC PBKD.");
            }
            FipsPBKD.Parameters parameters = FipsPBKD.PBKDF2.using(FipsSHS.Algorithm.SHA512_HMAC, Arrays.concatenate(byArray, byArray2)).withIterationCount(((PBKDF2Params)object).getIterationCount().intValue()).withSalt(((PBKDF2Params)object).getSalt());
            int n2 = ((PBKDF2Params)object).getKeyLength().intValue();
            object = deriverFactory.createDeriver(parameters);
            return object.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, n2);
        }

        private void verifyMac(byte[] byArray, PbkdMacIntegrityCheck pbkdMacIntegrityCheck, char[] cArray) throws NoSuchAlgorithmException, IOException {
            byte[] byArray2 = this.calculateMac(byArray, pbkdMacIntegrityCheck.getMacAlgorithm(), pbkdMacIntegrityCheck.getPbkdAlgorithm(), cArray);
            if (!Arrays.constantTimeAreEqual(byArray2, pbkdMacIntegrityCheck.getMac())) {
                throw new IOException("BCFKS KeyStore corrupted: MAC calculation failed.");
            }
        }

        private byte[] calculateMac(byte[] byArray, AlgorithmIdentifier algorithmIdentifier, KeyDerivationFunc keyDerivationFunc, char[] cArray) throws NoSuchAlgorithmException, IOException {
            String string = algorithmIdentifier.getAlgorithm().getId();
            Mac mac = this.fipsProvider != null ? Mac.getInstance(string, this.fipsProvider) : Mac.getInstance(string);
            try {
                mac.init(new SecretKeySpec(this.generateKey(keyDerivationFunc, "INTEGRITY_CHECK", cArray != null ? cArray : new char[]{}), string));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new ProvIOException("Cannot set up MAC calculation: " + invalidKeyException.getMessage(), invalidKeyException);
            }
            return mac.doFinal(byArray);
        }

        @Override
        public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
            ObjectData[] objectDataArray = this.entries.values().toArray(new ObjectData[this.entries.size()]);
            KeyDerivationFunc keyDerivationFunc = this.generatePkbdAlgorithmIdentifier(32);
            byte[] byArray = this.generateKey(keyDerivationFunc, "STORE_ENCRYPTION", cArray != null ? cArray : new char[]{});
            ObjectStoreData objectStoreData = new ObjectStoreData(this.hmacAlgorithm, this.creationDate, this.lastModifiedDate, new ObjectDataSequence(objectDataArray), null);
            FipsAES.AEADOperatorFactory aEADOperatorFactory = new FipsAES.AEADOperatorFactory();
            FipsAES.AuthParameters authParameters = FipsAES.CCM.withIV(this.getDefaultSecureRandom());
            FipsOutputAEADEncryptor<FipsAES.AuthParameters> fipsOutputAEADEncryptor = aEADOperatorFactory.createOutputAEADEncryptor((SymmetricKey)new SymmetricSecretKey(FipsAES.CCM, byArray), authParameters);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = fipsOutputAEADEncryptor.getEncryptingStream(byteArrayOutputStream);
            cipherOutputStream.write(objectStoreData.getEncoded());
            ((OutputStream)cipherOutputStream).close();
            PBES2Parameters pBES2Parameters = new PBES2Parameters(keyDerivationFunc, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, new CCMParameters(authParameters.getIV(), authParameters.getMACSizeInBits() / 8)));
            EncryptedObjectStoreData encryptedObjectStoreData = new EncryptedObjectStoreData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pBES2Parameters), byteArrayOutputStream.toByteArray());
            PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(this.hmacPkbdAlgorithm.getParameters());
            byte[] byArray2 = new byte[pBKDF2Params.getSalt().length];
            this.getDefaultSecureRandom().nextBytes(byArray2);
            this.hmacPkbdAlgorithm = new KeyDerivationFunc(this.hmacPkbdAlgorithm.getAlgorithm(), new PBKDF2Params(byArray2, pBKDF2Params.getIterationCount().intValue(), pBKDF2Params.getKeyLength().intValue(), pBKDF2Params.getPrf()));
            byte[] byArray3 = this.calculateMac(encryptedObjectStoreData.getEncoded(), this.hmacAlgorithm, this.hmacPkbdAlgorithm, cArray);
            ObjectStore objectStore = new ObjectStore(encryptedObjectStoreData, new ObjectStoreIntegrityCheck(new PbkdMacIntegrityCheck(this.hmacAlgorithm, this.hmacPkbdAlgorithm, byArray3)));
            outputStream.write(objectStore.getEncoded());
            outputStream.flush();
        }

        @Override
        public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
            ObjectStoreData objectStoreData;
            ASN1Object aSN1Object;
            Object object;
            this.entries.clear();
            this.privateKeyCache.clear();
            this.creationDate = null;
            this.lastModifiedDate = null;
            this.hmacAlgorithm = null;
            if (inputStream == null) {
                this.lastModifiedDate = this.creationDate = new Date();
                this.hmacAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE);
                this.hmacPkbdAlgorithm = this.generatePkbdAlgorithmIdentifier(64);
                return;
            }
            ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
            ObjectStore objectStore = ObjectStore.getInstance(aSN1InputStream.readObject());
            ObjectStoreIntegrityCheck objectStoreIntegrityCheck = objectStore.getIntegrityCheck();
            if (objectStoreIntegrityCheck.getType() != 0) {
                throw new IOException("BCFKS KeyStore unable to recognize integrity check.");
            }
            ASN1Encodable aSN1Encodable = PbkdMacIntegrityCheck.getInstance(objectStoreIntegrityCheck.getIntegrityCheck());
            this.hmacAlgorithm = aSN1Encodable.getMacAlgorithm();
            this.hmacPkbdAlgorithm = aSN1Encodable.getPbkdAlgorithm();
            this.verifyMac(objectStore.getStoreData().toASN1Primitive().getEncoded(), (PbkdMacIntegrityCheck)aSN1Encodable, cArray);
            aSN1Encodable = objectStore.getStoreData();
            if (aSN1Encodable instanceof EncryptedObjectStoreData) {
                object = (EncryptedObjectStoreData)aSN1Encodable;
                aSN1Object = ((EncryptedObjectStoreData)object).getEncryptionAlgorithm();
                objectStoreData = ObjectStoreData.getInstance(this.decryptData("STORE_ENCRYPTION", (AlgorithmIdentifier)aSN1Object, cArray, ((EncryptedObjectStoreData)object).getEncryptedContent().getOctets()));
            } else {
                objectStoreData = ObjectStoreData.getInstance(aSN1Encodable);
            }
            try {
                this.creationDate = objectStoreData.getCreationDate().getDate();
                this.lastModifiedDate = objectStoreData.getLastModifiedDate().getDate();
            }
            catch (ParseException parseException) {
                throw new IOException("BCFKS KeyStore unable to parse store data information.");
            }
            if (!objectStoreData.getIntegrityAlgorithm().equals(this.hmacAlgorithm)) {
                throw new IOException("BCFKS KeyStore storeData integrity algorithm does not match store integrity algorithm.");
            }
            object = objectStoreData.getObjectDataSequence().iterator();
            while (object.hasNext()) {
                aSN1Object = ObjectData.getInstance(object.next());
                this.entries.put(((ObjectData)aSN1Object).getIdentifier(), (ObjectData)aSN1Object);
            }
        }

        private byte[] decryptData(String string, AlgorithmIdentifier algorithmIdentifier, char[] cArray, byte[] byArray) throws IOException {
            if (!algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.id_PBES2)) {
                throw new IOException("BCFKS KeyStore cannot recognize protection algorithm.");
            }
            PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
            EncryptionScheme encryptionScheme = pBES2Parameters.getEncryptionScheme();
            if (!encryptionScheme.getAlgorithm().equals(NISTObjectIdentifiers.id_aes256_CCM)) {
                throw new IOException("BCFKS KeyStore cannot recognize protection encryption algorithm.");
            }
            CCMParameters cCMParameters = CCMParameters.getInstance(encryptionScheme.getParameters());
            FipsAES.AuthParameters authParameters = FipsAES.CCM.withIV(cCMParameters.getNonce()).withMACSize(cCMParameters.getIcvLen() * 8);
            FipsAES.AEADOperatorFactory aEADOperatorFactory = new FipsAES.AEADOperatorFactory();
            byte[] byArray2 = this.generateKey(pBES2Parameters.getKeyDerivationFunc(), string, cArray != null ? cArray : new char[]{});
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FipsOutputAEADDecryptor<FipsAES.AuthParameters> fipsOutputAEADDecryptor = aEADOperatorFactory.createOutputAEADDecryptor((SymmetricKey)new SymmetricSecretKey(FipsAES.CCM, byArray2), authParameters);
            CipherOutputStream cipherOutputStream = fipsOutputAEADDecryptor.getDecryptingStream(byteArrayOutputStream);
            cipherOutputStream.write(byArray);
            ((OutputStream)cipherOutputStream).close();
            return byteArrayOutputStream.toByteArray();
        }

        private KeyDerivationFunc generatePkbdAlgorithmIdentifier(int n2) {
            byte[] byArray = new byte[64];
            this.getDefaultSecureRandom().nextBytes(byArray);
            return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(byArray, 1024, n2, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE)));
        }
    }
}

