/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.internal.ms.core.bc.crypto.KeyUnwrapper;
import com.aspose.html.internal.ms.core.bc.crypto.KeyWrapOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.KeyWrapper;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.ParametersWithIV;
import com.aspose.html.internal.ms.core.bc.crypto.PlainInputProcessingException;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricSecretKey;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsKeyWrapOperatorFactory;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ParametersCreatorProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.Utils;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseWrapCipher
extends CipherSpi {
    private final BouncyCastleFipsProvider fipsProvider;
    private AlgorithmParameters engineParams = null;
    private final Map<Algorithm, Parameters> baseParametersMap;
    private Algorithm algorithm;
    private FipsKeyWrapOperatorFactory fipsKeyWrapOperatorFactory;
    private KeyWrapOperatorFactory generalKeyWrapOperatorFactory;
    private ParametersCreatorProvider fipsParametersProvider;
    private ParametersCreatorProvider generalParametersProvider;
    private Class[] availableSpecs;
    private int ivSize;
    private int keySizeInBits;
    private Parameters wrapParameters;
    private KeyWrapper keyWrapper;
    private KeyUnwrapper keyUnwrapper;

    private BaseWrapCipher(BouncyCastleFipsProvider bouncyCastleFipsProvider, Map<Algorithm, Parameters> map, Algorithm algorithm, FipsKeyWrapOperatorFactory fipsKeyWrapOperatorFactory, KeyWrapOperatorFactory keyWrapOperatorFactory, Class[] classArray, ParametersCreatorProvider parametersCreatorProvider, ParametersCreatorProvider parametersCreatorProvider2, int n2, int n3) {
        this.fipsProvider = bouncyCastleFipsProvider;
        this.baseParametersMap = map;
        this.algorithm = algorithm;
        this.fipsKeyWrapOperatorFactory = fipsKeyWrapOperatorFactory;
        this.generalKeyWrapOperatorFactory = keyWrapOperatorFactory;
        this.availableSpecs = classArray;
        this.fipsParametersProvider = parametersCreatorProvider;
        this.generalParametersProvider = parametersCreatorProvider2;
        this.keySizeInBits = n2;
        this.ivSize = n3;
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected byte[] engineGetIV() {
        if (this.wrapParameters instanceof ParametersWithIV) {
            return ((ParametersWithIV)this.wrapParameters).getIV();
        }
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    @Override
    protected int engineGetOutputSize(int n2) {
        return -1;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        ParametersWithIV parametersWithIV;
        if (this.wrapParameters instanceof ParametersWithIV && (parametersWithIV = (ParametersWithIV)this.wrapParameters).getIV() != null) {
            String string = Utils.getBaseName(this.wrapParameters.getAlgorithm());
            try {
                this.engineParams = AlgorithmParameters.getInstance(string, this.fipsProvider);
                this.engineParams.init(new DEROctetString(parametersWithIV.getIV()).getEncoded());
                return this.engineParams;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.toString(), exception);
            }
        }
        return null;
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Cannot support mode " + string);
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Padding " + string + " unknown");
    }

    @Override
    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        ParametersCreator parametersCreator = this.algorithm instanceof FipsAlgorithm ? this.fipsParametersProvider.get(this.baseParametersMap.get(this.algorithm)) : this.generalParametersProvider.get(this.baseParametersMap.get(this.algorithm));
        SymmetricSecretKey symmetricSecretKey = new SymmetricSecretKey(this.algorithm, key.getEncoded());
        if (this.keySizeInBits != 0 && Utils.keyNotLength(symmetricSecretKey, this.keySizeInBits)) {
            throw new InvalidKeyException("Cipher requires key of size " + this.keySizeInBits + " bits");
        }
        if (secureRandom == null) {
            secureRandom = this.fipsProvider.getDefaultSecureRandom();
        }
        try {
            switch (n2) {
                case 3: {
                    this.wrapParameters = parametersCreator.createParameters(true, algorithmParameterSpec, secureRandom);
                    this.keyWrapper = this.algorithm instanceof FipsAlgorithm ? this.fipsKeyWrapOperatorFactory.createKeyWrapper(symmetricSecretKey, this.wrapParameters) : this.generalKeyWrapOperatorFactory.createKeyWrapper(symmetricSecretKey, this.wrapParameters);
                    this.keyWrapper = Utils.addRandomIfNeeded(this.keyWrapper, secureRandom);
                    break;
                }
                case 4: {
                    this.wrapParameters = parametersCreator.createParameters(false, algorithmParameterSpec, secureRandom);
                    this.keyUnwrapper = this.algorithm instanceof FipsAlgorithm ? this.fipsKeyWrapOperatorFactory.createKeyUnwrapper(symmetricSecretKey, this.wrapParameters) : this.generalKeyWrapOperatorFactory.createKeyUnwrapper(symmetricSecretKey, this.wrapParameters);
                    this.keyUnwrapper = Utils.addRandomIfNeeded(this.keyUnwrapper, secureRandom);
                    break;
                }
                case 1: 
                case 2: {
                    throw new InvalidParameterException("Cipher only valid for wrapping/unwrapping");
                }
                default: {
                    throw new InvalidParameterException("Unknown mode parameter passed to init.");
                }
            }
        }
        catch (InvalidParameterException invalidParameterException) {
            throw invalidParameterException;
        }
        catch (IllegalKeyException illegalKeyException) {
            throw new InvalidKeyException(illegalKeyException.getMessage(), illegalKeyException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidAlgorithmParameterException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage(), exception);
        }
    }

    @Override
    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            for (int i2 = 0; i2 != this.availableSpecs.length; ++i2) {
                try {
                    algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(this.availableSpecs[i2]);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineParams = algorithmParameters;
        this.engineInit(n2, key, algorithmParameterSpec, secureRandom);
    }

    @Override
    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        throw new IllegalStateException("Not supported in a wrapping mode");
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        throw new IllegalStateException("Not supported in a wrapping mode");
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        throw new IllegalStateException("Not supported in a wrapping mode");
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        throw new IllegalStateException("Not supported in a wrapping mode");
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            return this.keyWrapper.wrap(byArray, 0, byArray.length);
        }
        catch (PlainInputProcessingException plainInputProcessingException) {
            throw new IllegalBlockSizeException(plainInputProcessingException.getMessage());
        }
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        try {
            byArray2 = this.keyUnwrapper.unwrap(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage(), exception.getCause());
        }
        return BaseWrapCipher.rebuildKey(string, n2, byArray2, this.fipsProvider);
    }

    static Key rebuildKey(String string, int n2, byte[] byArray, BouncyCastleFipsProvider bouncyCastleFipsProvider) throws InvalidKeyException, NoSuchAlgorithmException {
        if (n2 == 3) {
            return new SecretKeySpec(byArray, string);
        }
        if (n2 == 2) {
            try {
                if (string == null || string.equals("")) {
                    PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(byArray);
                    PrivateKey privateKey = bouncyCastleFipsProvider.getPrivateKey(privateKeyInfo);
                    if (privateKey != null) {
                        return privateKey;
                    }
                    throw new InvalidKeyException("Algorithm " + privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm() + " not supported");
                }
                KeyFactory keyFactory = KeyFactory.getInstance(string, bouncyCastleFipsProvider);
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Invalid private key encoding: " + exception.getMessage(), exception);
            }
        }
        try {
            if (string == null || string.equals("")) {
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(byArray);
                PublicKey publicKey = bouncyCastleFipsProvider.getPublicKey(subjectPublicKeyInfo);
                if (publicKey != null) {
                    return publicKey;
                }
                throw new InvalidKeyException("Algorithm " + subjectPublicKeyInfo.getAlgorithm().getAlgorithm() + " not supported");
            }
            KeyFactory keyFactory = KeyFactory.getInstance(string, bouncyCastleFipsProvider);
            return keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Invalid private key encoding: " + exception.getMessage(), exception);
        }
    }

    static class Builder {
        private final BouncyCastleFipsProvider fipsProvider;
        private final Algorithm[] algorithms;
        private final Map<Algorithm, Parameters> baseParametersMap;
        private FipsKeyWrapOperatorFactory fipsFactory;
        private KeyWrapOperatorFactory generalFactory;
        private int ivSize;
        private Class[] availableSpecs;
        private int keySizeInBits;
        private ParametersCreatorProvider fipsParametersProvider;
        private ParametersCreatorProvider generalParametersProvider;

        Builder(BouncyCastleFipsProvider bouncyCastleFipsProvider, Algorithm ... algorithmArray) {
            this.fipsProvider = bouncyCastleFipsProvider;
            this.algorithms = algorithmArray;
            this.baseParametersMap = null;
        }

        Builder(BouncyCastleFipsProvider bouncyCastleFipsProvider, Parameters ... parametersArray) {
            this.fipsProvider = bouncyCastleFipsProvider;
            this.baseParametersMap = new HashMap<Algorithm, Parameters>(parametersArray.length);
            this.algorithms = new Algorithm[parametersArray.length];
            for (int i2 = 0; i2 != parametersArray.length; ++i2) {
                this.baseParametersMap.put(parametersArray[i2].getAlgorithm(), parametersArray[i2]);
                this.algorithms[i2] = parametersArray[i2].getAlgorithm();
            }
        }

        Builder withFixedKeySize(int n2) {
            this.keySizeInBits = n2;
            return this;
        }

        Builder withIvSize(int n2) {
            this.ivSize = n2;
            return this;
        }

        Builder withFipsOperators(ParametersCreatorProvider parametersCreatorProvider, FipsKeyWrapOperatorFactory fipsKeyWrapOperatorFactory) {
            this.fipsParametersProvider = parametersCreatorProvider;
            this.fipsFactory = fipsKeyWrapOperatorFactory;
            return this;
        }

        Builder withGeneralOperators(ParametersCreatorProvider parametersCreatorProvider, KeyWrapOperatorFactory keyWrapOperatorFactory) {
            this.generalParametersProvider = parametersCreatorProvider;
            this.generalFactory = keyWrapOperatorFactory;
            return this;
        }

        Builder withParameters(Class[] classArray) {
            this.availableSpecs = classArray;
            return this;
        }

        BaseWrapCipher build() {
            boolean bl2 = CryptoServicesRegistrar.isInApprovedOnlyMode();
            if (!bl2) {
                return new BaseWrapCipher(this.fipsProvider, this.baseParametersMap, this.algorithms[0], this.fipsFactory, this.generalFactory, this.availableSpecs, this.fipsParametersProvider, this.generalParametersProvider, this.keySizeInBits, this.ivSize);
            }
            Set<Algorithm> set = Utils.getActiveSet(this.algorithms);
            if (set.isEmpty()) {
                return null;
            }
            return new BaseWrapCipher(this.fipsProvider, this.baseParametersMap, set.toArray(new Algorithm[set.size()])[0], this.fipsFactory, this.generalFactory, this.availableSpecs, this.fipsParametersProvider, this.generalParametersProvider, this.keySizeInBits, this.ivSize);
        }
    }
}

