/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.est.jcajce;

import com.aspose.html.internal.ms.core.bc.est.jcajce.SSLSocketFactoryCreator;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

class SSLSocketFactoryCreatorBuilder {
    protected String tlsVersion = "TLS";
    protected Provider tlsProvider;
    protected KeyManager[] keyManagers;
    protected X509TrustManager[] trustManagers;
    protected SecureRandom secureRandom = new SecureRandom();

    public SSLSocketFactoryCreatorBuilder(X509TrustManager trustManager) {
        if (trustManager == null) {
            throw new NullPointerException("Trust managers can not be null");
        }
        this.trustManagers = new X509TrustManager[]{trustManager};
    }

    public SSLSocketFactoryCreatorBuilder(X509TrustManager[] trustManagers) {
        if (trustManagers == null) {
            throw new NullPointerException("Trust managers can not be null");
        }
        this.trustManagers = trustManagers;
    }

    public SSLSocketFactoryCreatorBuilder withTLSVersion(String tlsVersion) {
        this.tlsVersion = tlsVersion;
        return this;
    }

    public SSLSocketFactoryCreatorBuilder withSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public SSLSocketFactoryCreatorBuilder withProvider(String tlsProviderName) throws NoSuchProviderException {
        this.tlsProvider = Security.getProvider(tlsProviderName);
        if (this.tlsProvider == null) {
            throw new NoSuchProviderException("JSSE provider not found: " + tlsProviderName);
        }
        return this;
    }

    public SSLSocketFactoryCreatorBuilder withProvider(Provider tlsProvider) {
        this.tlsProvider = tlsProvider;
        return this;
    }

    public SSLSocketFactoryCreatorBuilder withKeyManager(KeyManager keyManager) {
        this.keyManagers = keyManager == null ? null : new KeyManager[]{keyManager};
        return this;
    }

    public SSLSocketFactoryCreatorBuilder withKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
        return this;
    }

    public SSLSocketFactoryCreator build() {
        return new SSLSocketFactoryCreator(){

            public boolean isTrusted() {
                for (int i2 = 0; i2 != SSLSocketFactoryCreatorBuilder.this.trustManagers.length; ++i2) {
                    X509TrustManager x509TrustManager = SSLSocketFactoryCreatorBuilder.this.trustManagers[i2];
                    if (x509TrustManager.getAcceptedIssuers().length <= 0) continue;
                    return true;
                }
                return false;
            }

            public SSLSocketFactory createFactory() throws NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
                SSLContext sSLContext = SSLSocketFactoryCreatorBuilder.this.tlsProvider != null ? SSLContext.getInstance(SSLSocketFactoryCreatorBuilder.this.tlsVersion, SSLSocketFactoryCreatorBuilder.this.tlsProvider) : SSLContext.getInstance(SSLSocketFactoryCreatorBuilder.this.tlsVersion);
                sSLContext.init(SSLSocketFactoryCreatorBuilder.this.keyManagers, SSLSocketFactoryCreatorBuilder.this.trustManagers, SSLSocketFactoryCreatorBuilder.this.secureRandom);
                return sSLContext.getSocketFactory();
            }
        };
    }
}

