/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.est.jcajce;

import com.aspose.html.internal.ms.core.bc.est.ESTClientProvider;
import com.aspose.html.internal.ms.core.bc.est.ESTService;
import com.aspose.html.internal.ms.core.bc.est.ESTServiceBuilder;
import com.aspose.html.internal.ms.core.bc.est.jcajce.ChannelBindingProvider;
import com.aspose.html.internal.ms.core.bc.est.jcajce.DefaultESTHttpClientProvider;
import com.aspose.html.internal.ms.core.bc.est.jcajce.JcaJceUtils;
import com.aspose.html.internal.ms.core.bc.est.jcajce.JsseDefaultHostnameAuthorizer;
import com.aspose.html.internal.ms.core.bc.est.jcajce.JsseHostnameAuthorizer;
import com.aspose.html.internal.ms.core.bc.est.jcajce.SSLSocketFactoryCreator;
import com.aspose.html.internal.ms.core.bc.est.jcajce.SSLSocketFactoryCreatorBuilder;
import java.net.Socket;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509TrustManager;

public class JsseESTServiceBuilder
extends ESTServiceBuilder {
    protected SSLSocketFactoryCreator socketFactoryCreator;
    protected JsseHostnameAuthorizer hostNameAuthorizer = new JsseDefaultHostnameAuthorizer(null);
    protected int timeoutMillis = 0;
    protected ChannelBindingProvider bindingProvider;
    protected Set<String> supportedSuites = new HashSet<String>();
    protected Long absoluteLimit;
    protected SSLSocketFactoryCreatorBuilder sslSocketFactoryCreatorBuilder;
    protected boolean filterCipherSuites = true;

    public JsseESTServiceBuilder(String server, SSLSocketFactoryCreator socketFactoryCreator) {
        super(server);
        if (socketFactoryCreator == null) {
            throw new NullPointerException("No socket factory creator.");
        }
        this.socketFactoryCreator = socketFactoryCreator;
    }

    public JsseESTServiceBuilder(String server) {
        super(server);
        this.sslSocketFactoryCreatorBuilder = new SSLSocketFactoryCreatorBuilder(JcaJceUtils.getTrustAllTrustManager());
    }

    public JsseESTServiceBuilder(String server, X509TrustManager trustManager) {
        super(server);
        this.sslSocketFactoryCreatorBuilder = new SSLSocketFactoryCreatorBuilder(trustManager);
    }

    public JsseESTServiceBuilder(String server, X509TrustManager[] trustManager) {
        super(server);
        this.sslSocketFactoryCreatorBuilder = new SSLSocketFactoryCreatorBuilder(trustManager);
    }

    public JsseESTServiceBuilder withHostNameAuthorizer(JsseHostnameAuthorizer hostNameAuthorizer) {
        this.hostNameAuthorizer = hostNameAuthorizer;
        return this;
    }

    public JsseESTServiceBuilder withClientProvider(ESTClientProvider clientProvider) {
        this.clientProvider = clientProvider;
        return this;
    }

    public JsseESTServiceBuilder withTimeout(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public JsseESTServiceBuilder withReadLimit(long absoluteLimit) {
        this.absoluteLimit = absoluteLimit;
        return this;
    }

    public JsseESTServiceBuilder withChannelBindingProvider(ChannelBindingProvider channelBindingProvider) {
        this.bindingProvider = channelBindingProvider;
        return this;
    }

    public JsseESTServiceBuilder addCipherSuites(String name) {
        this.supportedSuites.add(name);
        return this;
    }

    public JsseESTServiceBuilder addCipherSuites(String[] names) {
        this.supportedSuites.addAll(Arrays.asList(names));
        return this;
    }

    public JsseESTServiceBuilder withTLSVersion(String tlsVersion) {
        if (this.socketFactoryCreator != null) {
            throw new IllegalStateException("Socket Factory Creator was defined in the constructor.");
        }
        this.sslSocketFactoryCreatorBuilder.withTLSVersion(tlsVersion);
        return this;
    }

    public JsseESTServiceBuilder withSecureRandom(SecureRandom secureRandom) {
        if (this.socketFactoryCreator != null) {
            throw new IllegalStateException("Socket Factory Creator was defined in the constructor.");
        }
        this.sslSocketFactoryCreatorBuilder.withSecureRandom(secureRandom);
        return this;
    }

    public JsseESTServiceBuilder withProvider(String tlsProviderName) throws NoSuchProviderException {
        if (this.socketFactoryCreator != null) {
            throw new IllegalStateException("Socket Factory Creator was defined in the constructor.");
        }
        this.sslSocketFactoryCreatorBuilder.withProvider(tlsProviderName);
        return this;
    }

    public JsseESTServiceBuilder withProvider(Provider tlsProvider) {
        if (this.socketFactoryCreator != null) {
            throw new IllegalStateException("Socket Factory Creator was defined in the constructor.");
        }
        this.sslSocketFactoryCreatorBuilder.withProvider(tlsProvider);
        return this;
    }

    public JsseESTServiceBuilder withKeyManager(KeyManager keyManager) {
        if (this.socketFactoryCreator != null) {
            throw new IllegalStateException("Socket Factory Creator was defined in the constructor.");
        }
        this.sslSocketFactoryCreatorBuilder.withKeyManager(keyManager);
        return this;
    }

    public JsseESTServiceBuilder withKeyManagers(KeyManager[] keyManagers) {
        if (this.socketFactoryCreator != null) {
            throw new IllegalStateException("Socket Factory Creator was defined in the constructor.");
        }
        this.sslSocketFactoryCreatorBuilder.withKeyManagers(keyManagers);
        return this;
    }

    public JsseESTServiceBuilder withFilterCipherSuites(boolean filter) {
        this.filterCipherSuites = filter;
        return this;
    }

    public ESTService build() {
        if (this.bindingProvider == null) {
            this.bindingProvider = new ChannelBindingProvider(){

                public boolean canAccessChannelBinding(Socket sock) {
                    return false;
                }

                public byte[] getChannelBinding(Socket sock, String binding) {
                    return null;
                }
            };
        }
        if (this.socketFactoryCreator == null) {
            this.socketFactoryCreator = this.sslSocketFactoryCreatorBuilder.build();
        }
        if (this.clientProvider == null) {
            this.clientProvider = new DefaultESTHttpClientProvider(this.hostNameAuthorizer, this.socketFactoryCreator, this.timeoutMillis, this.bindingProvider, this.supportedSuites, this.absoluteLimit, this.filterCipherSuites);
        }
        return super.build();
    }
}

