/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.est.jcajce;

import com.aspose.html.internal.ms.core.JavaLangSystem;
import com.aspose.html.internal.ms.core.bc.est.ESTClient;
import com.aspose.html.internal.ms.core.bc.est.ESTClientSourceProvider;
import com.aspose.html.internal.ms.core.bc.est.ESTException;
import com.aspose.html.internal.ms.core.bc.est.ESTRequest;
import com.aspose.html.internal.ms.core.bc.est.ESTRequestBuilder;
import com.aspose.html.internal.ms.core.bc.est.ESTResponse;
import com.aspose.html.internal.ms.core.bc.est.Source;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultESTClient
implements ESTClient {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private static byte[] CRLF = new byte[]{13, 10};
    private final ESTClientSourceProvider sslSocketProvider;

    public DefaultESTClient(ESTClientSourceProvider sslSocketProvider) {
        this.sslSocketProvider = sslSocketProvider;
    }

    private static void writeLine(OutputStream os, String s2) throws IOException {
        os.write(s2.getBytes());
        os.write(CRLF);
    }

    @Override
    public ESTResponse doRequest(ESTRequest req) throws IOException {
        ESTResponse eSTResponse = null;
        ESTRequest eSTRequest = req;
        int n2 = 15;
        while ((eSTRequest = this.redirectURL(eSTResponse = this.performRequest(eSTRequest))) != null && --n2 > 0) {
        }
        if (n2 == 0) {
            throw new ESTException("Too many redirects..");
        }
        return eSTResponse;
    }

    protected ESTRequest redirectURL(ESTResponse response) throws IOException {
        ESTRequest eSTRequest = null;
        if (response.getStatusCode() >= 300 && response.getStatusCode() <= 399) {
            switch (response.getStatusCode()) {
                case 301: 
                case 302: 
                case 303: 
                case 306: 
                case 307: {
                    String string = response.getHeader("Location");
                    if ("".equals(string)) {
                        throw new ESTException("Redirect status type: " + response.getStatusCode() + " but no location header");
                    }
                    ESTRequestBuilder eSTRequestBuilder = new ESTRequestBuilder(response.getOriginalRequest());
                    if (string.startsWith("http")) {
                        eSTRequest = eSTRequestBuilder.withURL(new URL(string)).build();
                        break;
                    }
                    URL uRL = response.getOriginalRequest().getURL();
                    eSTRequest = eSTRequestBuilder.withURL(new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string)).build();
                    break;
                }
                default: {
                    throw new ESTException("Client does not handle http status code: " + response.getStatusCode());
                }
            }
        }
        if (eSTRequest != null) {
            response.close();
        }
        return eSTRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ESTResponse performRequest(ESTRequest c2) throws IOException {
        ESTResponse eSTResponse = null;
        Source source = null;
        try {
            Object object;
            URL uRL;
            source = this.sslSocketProvider.makeSource(c2.getURL().getHost(), c2.getURL().getPort());
            if (c2.getListener() != null) {
                c2 = c2.getListener().onConnection(source, c2);
            }
            OutputStream outputStream = null;
            Set<String> set = DefaultESTClient.asKeySet("com.aspose.html.internal.ms.core.bc.debug.est");
            outputStream = set.contains("output") || set.contains("all") ? new PrintingOutputStream(source.getOutputStream()) : source.getOutputStream();
            String string = c2.getURL().getPath() + (c2.getURL().getQuery() != null ? c2.getURL().getQuery() : "");
            ESTRequestBuilder eSTRequestBuilder = new ESTRequestBuilder(c2);
            Map<String, String[]> map = c2.getHeaders();
            if (!map.containsKey("Connection")) {
                eSTRequestBuilder.addHeader("Connection", "close");
            }
            if ((uRL = c2.getURL()).getPort() > -1) {
                eSTRequestBuilder.setHeader("Host", String.format("%s:%d", uRL.getHost(), uRL.getPort()));
            } else {
                eSTRequestBuilder.setHeader("Host", uRL.getHost());
            }
            ESTRequest eSTRequest = eSTRequestBuilder.build();
            DefaultESTClient.writeLine(outputStream, eSTRequest.getMethod() + " " + string + " HTTP/1.1");
            for (Map.Entry<String, String[]> entry : eSTRequest.getHeaders().entrySet()) {
                String[] stringArray = entry.getValue();
                for (int i2 = 0; i2 != stringArray.length; ++i2) {
                    DefaultESTClient.writeLine(outputStream, entry.getKey() + ": " + stringArray[i2]);
                }
            }
            outputStream.write(CRLF);
            outputStream.flush();
            eSTRequest.writeData(outputStream);
            outputStream.flush();
            if (eSTRequest.getHijacker() != null) {
                eSTResponse = eSTRequest.getHijacker().hijack(eSTRequest, source);
                object = eSTResponse;
                return object;
            }
            eSTResponse = new ESTResponse(eSTRequest, source);
            object = eSTResponse;
            return object;
        }
        finally {
            if (source != null && eSTResponse == null) {
                source.close();
            }
        }
    }

    static Set<String> asKeySet(String propertyName) {
        HashSet<String> hashSet = new HashSet<String>();
        String string = DefaultESTClient.fetchProperty(propertyName);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                hashSet.add(Strings.toLowerCase(stringTokenizer.nextToken()).trim());
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static String fetchProperty(final String propertyName) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propertyName);
            }
        });
    }

    private class PrintingOutputStream
    extends OutputStream {
        private final OutputStream tgt;

        public PrintingOutputStream(OutputStream tgt) {
            this.tgt = tgt;
        }

        public void write(int b2) throws IOException {
            JavaLangSystem.out.print(String.valueOf((char)b2));
            this.tgt.write(b2);
        }
    }
}

