/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.est;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.est.AttrOrOID;
import com.aspose.html.internal.ms.core.bc.est.CsrAttrs;
import com.aspose.html.internal.ms.core.bc.est.ESTException;
import com.aspose.html.internal.ms.core.bc.util.Encodable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSRAttributesResponse
implements Encodable {
    private final CsrAttrs csrAttrs;
    private final HashMap<ASN1ObjectIdentifier, AttrOrOID> index;

    public CSRAttributesResponse(byte[] responseEncoding) throws ESTException {
        this(CSRAttributesResponse.parseBytes(responseEncoding));
    }

    public CSRAttributesResponse(CsrAttrs csrAttrs) throws ESTException {
        this.csrAttrs = csrAttrs;
        this.index = new HashMap(csrAttrs.size());
        AttrOrOID[] attrOrOIDArray = csrAttrs.getAttrOrOIDs();
        for (int i2 = 0; i2 != attrOrOIDArray.length; ++i2) {
            AttrOrOID attrOrOID = attrOrOIDArray[i2];
            if (attrOrOID.isOid()) {
                this.index.put(attrOrOID.getOid(), attrOrOID);
                continue;
            }
            this.index.put(attrOrOID.getAttribute().getAttrType(), attrOrOID);
        }
    }

    private static CsrAttrs parseBytes(byte[] responseEncoding) throws ESTException {
        try {
            return CsrAttrs.getInstance(ASN1Primitive.fromByteArray(responseEncoding));
        }
        catch (Exception exception) {
            throw new ESTException("malformed data: " + exception.getMessage(), exception);
        }
    }

    public boolean hasRequirement(ASN1ObjectIdentifier requirementOid) {
        return this.index.containsKey(requirementOid);
    }

    public boolean isAttribute(ASN1ObjectIdentifier requirementOid) {
        if (this.index.containsKey(requirementOid)) {
            return !this.index.get(requirementOid).isOid();
        }
        return false;
    }

    public boolean isEmpty() {
        return this.csrAttrs.size() == 0;
    }

    public Collection<ASN1ObjectIdentifier> getRequirements() {
        return this.index.keySet();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.csrAttrs.getEncoded();
    }
}

