/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.eac.operator.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.eac.EACObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.eac.operator.EACSignatureVerifier;
import com.aspose.html.internal.ms.core.bc.eac.operator.jcajce.DefaultEACHelper;
import com.aspose.html.internal.ms.core.bc.eac.operator.jcajce.EACHelper;
import com.aspose.html.internal.ms.core.bc.eac.operator.jcajce.NamedEACHelper;
import com.aspose.html.internal.ms.core.bc.eac.operator.jcajce.ProviderEACHelper;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.internal.ms.core.bc.operator.OperatorStreamException;
import com.aspose.html.internal.ms.core.bc.operator.RuntimeOperatorException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class JcaEACSignatureVerifierBuilder {
    private EACHelper helper = new DefaultEACHelper();

    public JcaEACSignatureVerifierBuilder setProvider(String providerName) {
        this.helper = new NamedEACHelper(providerName);
        return this;
    }

    public JcaEACSignatureVerifierBuilder setProvider(Provider provider) {
        this.helper = new ProviderEACHelper(provider);
        return this;
    }

    public EACSignatureVerifier build(final ASN1ObjectIdentifier usageOid, PublicKey pubKey) throws OperatorCreationException {
        Signature signature;
        try {
            signature = this.helper.getSignature(usageOid);
            signature.initVerify(pubKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new OperatorCreationException("unable to find algorithm: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new OperatorCreationException("unable to find provider: " + noSuchProviderException.getMessage(), noSuchProviderException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new OperatorCreationException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        final SignatureOutputStream signatureOutputStream = new SignatureOutputStream(signature);
        return new EACSignatureVerifier(){

            public ASN1ObjectIdentifier getUsageIdentifier() {
                return usageOid;
            }

            public OutputStream getOutputStream() {
                return signatureOutputStream;
            }

            public boolean verify(byte[] expected) {
                try {
                    if (usageOid.on(EACObjectIdentifiers.id_TA_ECDSA)) {
                        try {
                            byte[] byArray = JcaEACSignatureVerifierBuilder.derEncode(expected);
                            return signatureOutputStream.verify(byArray);
                        }
                        catch (Exception exception) {
                            return false;
                        }
                    }
                    return signatureOutputStream.verify(expected);
                }
                catch (SignatureException signatureException) {
                    throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
                }
            }
        };
    }

    private static byte[] derEncode(byte[] rawSign) throws IOException {
        int n2 = rawSign.length / 2;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        System.arraycopy(rawSign, 0, byArray, 0, n2);
        System.arraycopy(rawSign, n2, byArray2, 0, n2);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(new BigInteger(1, byArray)));
        aSN1EncodableVector.add(new ASN1Integer(new BigInteger(1, byArray2)));
        DERSequence dERSequence = new DERSequence(aSN1EncodableVector);
        return dERSequence.getEncoded();
    }

    private class SignatureOutputStream
    extends OutputStream {
        private Signature sig;

        SignatureOutputStream(Signature sig) {
            this.sig = sig;
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            try {
                this.sig.update(bytes, off, len);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        public void write(byte[] bytes) throws IOException {
            try {
                this.sig.update(bytes);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        public void write(int b2) throws IOException {
            try {
                this.sig.update((byte)b2);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        boolean verify(byte[] expected) throws SignatureException {
            return this.sig.verify(expected);
        }
    }
}

