/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.internal.io;

import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Mac;
import com.aspose.html.internal.ms.core.bc.crypto.internal.io.Utils;
import java.io.IOException;

public class MacOutputStream
extends UpdateOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    protected Mac mac;

    public MacOutputStream(Mac mac) {
        this.algorithmName = mac.getAlgorithmName();
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.mac = mac;
    }

    public void write(int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.mac.update((byte)n2);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.mac.update(byArray, n2, n3);
    }

    public byte[] getMac() {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        byte[] byArray = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray, 0);
        return byArray;
    }
}

