/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.InvalidWrappingException;
import com.aspose.html.internal.ms.core.bc.crypto.Key;
import com.aspose.html.internal.ms.core.bc.crypto.KeyUnwrapper;
import com.aspose.html.internal.ms.core.bc.crypto.KeyWrapOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.KeyWrapper;
import com.aspose.html.internal.ms.core.bc.crypto.KeyWrapperUsingSecureRandom;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsStatus;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.internal.ms.core.bc.crypto.general.Utils;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Wrapper;
import java.security.SecureRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GuardedKeyWrapOperatorFactory<T extends Parameters, K extends Key>
implements KeyWrapOperatorFactory<T, K> {
    GuardedKeyWrapOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
    }

    @Override
    public KeyWrapper<T> createKeyWrapper(K k2, T t2) {
        return new GuardedWrapper(this, k2, t2, null);
    }

    @Override
    public KeyUnwrapper<T> createKeyUnwrapper(K k2, T t2) {
        return new GuardedUnwrapper(this, t2.getAlgorithm(), t2, this.createWrapper(false, k2, t2, null));
    }

    protected abstract Wrapper createWrapper(boolean var1, K var2, T var3, SecureRandom var4);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GuardedUnwrapper
    implements KeyUnwrapper<T> {
        private final Algorithm algorithm;
        private final T parameters;
        private final Wrapper wrapper;
        final /* synthetic */ GuardedKeyWrapOperatorFactory this$0;

        GuardedUnwrapper(Algorithm algorithm, T t2, Wrapper wrapper) {
            this.this$0 = var1_1;
            this.algorithm = algorithm;
            this.parameters = t2;
            this.wrapper = wrapper;
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidWrappingException {
            Utils.approveModeCheck(this.algorithm);
            try {
                return this.wrapper.unwrap(byArray, n2, n3);
            }
            catch (Exception exception) {
                throw new InvalidWrappingException("Unable to unwrap key: " + exception.getMessage(), exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GuardedWrapper
    implements KeyWrapperUsingSecureRandom<T> {
        private final Algorithm algorithm;
        private final K key;
        private final T parameters;
        private final SecureRandom random;
        private Wrapper wrapper;
        final /* synthetic */ GuardedKeyWrapOperatorFactory this$0;

        GuardedWrapper(K k2, T t2, SecureRandom secureRandom) {
            this.this$0 = var1_1;
            this.algorithm = t2.getAlgorithm();
            this.key = k2;
            this.parameters = t2;
            this.random = secureRandom;
        }

        void setUp() {
            if (this.wrapper == null) {
                this.wrapper = this.this$0.createWrapper(true, this.key, this.parameters, this.random);
            }
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public byte[] wrap(byte[] byArray, int n2, int n3) {
            Utils.approveModeCheck(this.algorithm);
            this.setUp();
            return this.wrapper.wrap(byArray, n2, n3);
        }

        @Override
        public KeyWrapperUsingSecureRandom<T> withSecureRandom(SecureRandom secureRandom) {
            return new GuardedWrapper(this.this$0, this.key, this.parameters, secureRandom);
        }
    }
}

