/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.general.CipherKeyGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.internal.KeyGenerationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DesParameters;

class DesKeyGenerator
extends CipherKeyGenerator {
    DesKeyGenerator() {
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        super.init(keyGenerationParameters);
        if (this.strength == 0 || this.strength == 7) {
            this.strength = 8;
        } else if (this.strength != 8) {
            throw new IllegalArgumentException("DES key must be 64 bits long.");
        }
    }

    public byte[] generateKey() {
        byte[] byArray = new byte[8];
        do {
            this.random.nextBytes(byArray);
            DesParameters.setOddParity(byArray);
        } while (DesParameters.isWeakKey(byArray, 0));
        return byArray;
    }
}

