/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.crypto.InvalidSignatureException;
import com.aspose.html.internal.ms.core.bc.crypto.OutputVerifier;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.internal.ms.core.bc.crypto.general.DSAUtils;
import com.aspose.html.internal.ms.core.bc.crypto.general.DSTU4145Signer;
import com.aspose.html.internal.ms.core.bc.crypto.general.EcGost3410Signer;
import com.aspose.html.internal.ms.core.bc.crypto.general.Gost3410Signer;
import com.aspose.html.internal.ms.core.bc.crypto.internal.DSA;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.internal.ms.core.bc.crypto.internal.io.DigestOutputStream;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DSAOutputVerifier<T extends Parameters>
implements OutputVerifier<T> {
    private final DSA dsa;
    private final Digest digest;
    private final T parameter;
    private final boolean reverse;

    DSAOutputVerifier(DSA dSA, Digest digest, T t2) {
        this(dSA, digest, t2, false);
    }

    DSAOutputVerifier(DSA dSA, Digest digest, T t2, boolean bl2) {
        this.dsa = dSA;
        this.digest = digest;
        this.parameter = t2;
        this.reverse = bl2;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public UpdateOutputStream getVerifyingStream() {
        return new DigestOutputStream(this.digest);
    }

    @Override
    public boolean isVerified(byte[] byArray) throws InvalidSignatureException {
        try {
            BigInteger[] bigIntegerArray = this.decode(byArray);
            byte[] byArray2 = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(byArray2, 0);
            return this.dsa.verifySignature(byArray2, bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (IOException iOException) {
            throw new InvalidSignatureException("Unable to process signature: " + iOException.getMessage(), iOException);
        }
    }

    public BigInteger[] decode(byte[] byArray) throws IOException {
        BigInteger[] bigIntegerArray = new BigInteger[2];
        if (this.dsa instanceof EcGost3410Signer || this.dsa instanceof Gost3410Signer) {
            byte[] byArray2 = new byte[32];
            byte[] byArray3 = new byte[32];
            if (byArray.length != 64) {
                throw new IOException("malformed signature");
            }
            System.arraycopy(byArray, 0, byArray3, 0, 32);
            System.arraycopy(byArray, 32, byArray2, 0, 32);
            bigIntegerArray[0] = new BigInteger(1, byArray2);
            bigIntegerArray[1] = new BigInteger(1, byArray3);
        } else if (this.dsa instanceof DSTU4145Signer) {
            byte[] byArray4 = ((ASN1OctetString)ASN1OctetString.fromByteArray(byArray)).getOctets();
            byte[] byArray5 = new byte[byArray4.length / 2];
            byte[] byArray6 = new byte[byArray4.length / 2];
            if (this.reverse) {
                DSAUtils.reverseBytes(byArray4);
            }
            System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length / 2);
            System.arraycopy(byArray4, byArray4.length / 2, byArray5, 0, byArray4.length / 2);
            bigIntegerArray = new BigInteger[]{new BigInteger(1, byArray5), new BigInteger(1, byArray6)};
        } else {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
            if (aSN1Sequence.size() != 2) {
                throw new IOException("malformed signature");
            }
            if (!Arrays.areEqual(byArray, aSN1Sequence.getEncoded("DER"))) {
                throw new IOException("malformed signature");
            }
            bigIntegerArray[0] = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue();
            bigIntegerArray[1] = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue();
        }
        return bigIntegerArray;
    }
}

