/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.cms.KeyAgreeRecipientIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.cms.OriginatorPublicKey;
import com.aspose.html.internal.ms.core.bc.asn1.cms.RecipientEncryptedKey;
import com.aspose.html.internal.ms.core.bc.asn1.cms.RecipientKeyIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.cms.ecc.MQVuserKeyingMaterial;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.KeyAgreeRecipientInfoGenerator;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.CMSUtils;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.DefaultJcaJceExtHelper;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.EnvelopedDataHelper;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.KeyMaterialGenerator;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.NamedJcaJceExtHelper;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.ProviderJcaJceExtHelper;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.RFC5753KeyMaterialGenerator;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.MQVParameterSpec;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.UserKeyingMaterialSpec;
import com.aspose.html.internal.ms.core.bc.operator.DefaultSecretKeySizeProvider;
import com.aspose.html.internal.ms.core.bc.operator.GenericKey;
import com.aspose.html.internal.ms.core.bc.operator.SecretKeySizeProvider;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;

public class JceKeyAgreeRecipientInfoGenerator
extends KeyAgreeRecipientInfoGenerator {
    private SecretKeySizeProvider keySizeProvider = new DefaultSecretKeySizeProvider();
    private List recipientIDs = new ArrayList();
    private List recipientKeys = new ArrayList();
    private PublicKey senderPublicKey;
    private PrivateKey senderPrivateKey;
    private EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
    private SecureRandom random;
    private KeyPair ephemeralKP;
    private byte[] userKeyingMaterial;
    private static KeyMaterialGenerator ecc_cms_Generator = new RFC5753KeyMaterialGenerator();

    public JceKeyAgreeRecipientInfoGenerator(ASN1ObjectIdentifier keyAgreementOID, PrivateKey senderPrivateKey, PublicKey senderPublicKey, ASN1ObjectIdentifier keyEncryptionOID) {
        super(keyAgreementOID, SubjectPublicKeyInfo.getInstance(senderPublicKey.getEncoded()), keyEncryptionOID);
        this.senderPublicKey = senderPublicKey;
        this.senderPrivateKey = senderPrivateKey;
    }

    public JceKeyAgreeRecipientInfoGenerator setUserKeyingMaterial(byte[] userKeyingMaterial) {
        this.userKeyingMaterial = Arrays.clone(userKeyingMaterial);
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(String providerName) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(X509Certificate recipientCert) throws CertificateEncodingException {
        this.recipientIDs.add(new KeyAgreeRecipientIdentifier(CMSUtils.getIssuerAndSerialNumber(recipientCert)));
        this.recipientKeys.add(recipientCert.getPublicKey());
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(byte[] subjectKeyID, PublicKey publicKey) throws CertificateEncodingException {
        this.recipientIDs.add(new KeyAgreeRecipientIdentifier(new RecipientKeyIdentifier(subjectKeyID)));
        this.recipientKeys.add(publicKey);
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ASN1Sequence generateRecipientEncryptedKeys(AlgorithmIdentifier keyAgreeAlgorithm, AlgorithmIdentifier keyEncryptionAlgorithm, GenericKey contentEncryptionKey) throws CMSException {
        if (this.recipientIDs.isEmpty()) {
            throw new CMSException("No recipients associated with generator - use addRecipient()");
        }
        this.init(keyAgreeAlgorithm.getAlgorithm());
        PrivateKey privateKey = this.senderPrivateKey;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = keyAgreeAlgorithm.getAlgorithm();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.recipientIDs.size(); ++i2) {
            PublicKey publicKey = (PublicKey)this.recipientKeys.get(i2);
            KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = (KeyAgreeRecipientIdentifier)this.recipientIDs.get(i2);
            try {
                void var10_10;
                Object object;
                ASN1ObjectIdentifier aSN1ObjectIdentifier2 = keyEncryptionAlgorithm.getAlgorithm();
                if (CMSUtils.isMQV(aSN1ObjectIdentifier)) {
                    MQVParameterSpec mQVParameterSpec = new MQVParameterSpec(this.ephemeralKP, publicKey, this.userKeyingMaterial);
                } else if (CMSUtils.isEC(aSN1ObjectIdentifier)) {
                    object = ecc_cms_Generator.generateKDFMaterial(keyEncryptionAlgorithm, this.keySizeProvider.getKeySize(aSN1ObjectIdentifier2), this.userKeyingMaterial);
                    UserKeyingMaterialSpec userKeyingMaterialSpec = new UserKeyingMaterialSpec((byte[])object);
                } else if (CMSUtils.isRFC2631(aSN1ObjectIdentifier)) {
                    if (this.userKeyingMaterial != null) {
                        UserKeyingMaterialSpec userKeyingMaterialSpec = new UserKeyingMaterialSpec(this.userKeyingMaterial);
                    } else {
                        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_alg_SSDH)) {
                            throw new CMSException("User keying material must be set for static keys.");
                        }
                        Object var10_14 = null;
                    }
                } else {
                    if (!CMSUtils.isGOST(aSN1ObjectIdentifier)) throw new CMSException("Unknown key agreement algorithm: " + aSN1ObjectIdentifier);
                    if (this.userKeyingMaterial == null) throw new CMSException("User keying material must be set for static keys.");
                    UserKeyingMaterialSpec userKeyingMaterialSpec = new UserKeyingMaterialSpec(this.userKeyingMaterial);
                }
                object = this.helper.createKeyAgreement(aSN1ObjectIdentifier);
                ((KeyAgreement)object).init(privateKey, (AlgorithmParameterSpec)var10_10, this.random);
                ((KeyAgreement)object).doPhase(publicKey, true);
                SecretKey secretKey = ((KeyAgreement)object).generateSecret(aSN1ObjectIdentifier2.getId());
                Cipher cipher = this.helper.createCipher(aSN1ObjectIdentifier2);
                cipher.init(3, (Key)secretKey, this.random);
                byte[] byArray = cipher.wrap(this.helper.getJceKey(contentEncryptionKey));
                DEROctetString dEROctetString = new DEROctetString(byArray);
                aSN1EncodableVector.add(new RecipientEncryptedKey(keyAgreeRecipientIdentifier, dEROctetString));
                continue;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("cannot perform agreement step: " + generalSecurityException.getMessage(), generalSecurityException);
            }
        }
        return new DERSequence(aSN1EncodableVector);
    }

    protected byte[] getUserKeyingMaterial(AlgorithmIdentifier keyAgreeAlg) throws CMSException {
        this.init(keyAgreeAlg.getAlgorithm());
        if (this.ephemeralKP != null) {
            OriginatorPublicKey originatorPublicKey = this.createOriginatorPublicKey(SubjectPublicKeyInfo.getInstance(this.ephemeralKP.getPublic().getEncoded()));
            try {
                if (this.userKeyingMaterial != null) {
                    return new MQVuserKeyingMaterial(originatorPublicKey, new DEROctetString(this.userKeyingMaterial)).getEncoded();
                }
                return new MQVuserKeyingMaterial(originatorPublicKey, null).getEncoded();
            }
            catch (IOException iOException) {
                throw new CMSException("unable to encode user keying material: " + iOException.getMessage(), iOException);
            }
        }
        return this.userKeyingMaterial;
    }

    private void init(ASN1ObjectIdentifier keyAgreementOID) throws CMSException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (CMSUtils.isMQV(keyAgreementOID) && this.ephemeralKP == null) {
            try {
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(this.senderPublicKey.getEncoded());
                AlgorithmParameters algorithmParameters = this.helper.createAlgorithmParameters(keyAgreementOID);
                algorithmParameters.init(subjectPublicKeyInfo.getAlgorithm().getParameters().toASN1Primitive().getEncoded());
                KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator(keyAgreementOID);
                keyPairGenerator.initialize(algorithmParameters.getParameterSpec(AlgorithmParameterSpec.class), this.random);
                this.ephemeralKP = keyPairGenerator.generateKeyPair();
            }
            catch (Exception exception) {
                throw new CMSException("cannot determine MQV ephemeral key pair parameters from public key: " + exception, exception);
            }
        }
    }
}

