/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.cms.ecc.ECCCMSSharedInfo;
import com.aspose.html.internal.ms.core.bc.asn1.cms.ecc.MQVuserKeyingMaterial;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.KeyAgreeRecipient;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.CMSUtils;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.DefaultJcaJceExtHelper;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.EnvelopedDataHelper;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.KeyMaterialGenerator;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.NamedJcaJceExtHelper;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.ProviderJcaJceExtHelper;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.RFC5753KeyMaterialGenerator;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.MQVParameterSpec;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.UserKeyingMaterialSpec;
import com.aspose.html.internal.ms.core.bc.operator.DefaultSecretKeySizeProvider;
import com.aspose.html.internal.ms.core.bc.operator.SecretKeySizeProvider;
import com.aspose.html.internal.ms.core.bc.util.Pack;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public abstract class JceKeyAgreeRecipient
implements KeyAgreeRecipient {
    private static final Set possibleOldMessages = new HashSet();
    private PrivateKey recipientKey;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;
    private SecretKeySizeProvider keySizeProvider;
    private static KeyMaterialGenerator old_ecc_cms_Generator;
    private static KeyMaterialGenerator ecc_cms_Generator;

    public JceKeyAgreeRecipient(PrivateKey recipientKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
        this.keySizeProvider = new DefaultSecretKeySizeProvider();
        this.recipientKey = recipientKey;
    }

    public JceKeyAgreeRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKeyAgreeRecipient setProvider(String providerName) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    public JceKeyAgreeRecipient setContentProvider(Provider provider) {
        this.contentHelper = CMSUtils.createContentHelper(provider);
        return this;
    }

    public JceKeyAgreeRecipient setContentProvider(String providerName) {
        this.contentHelper = CMSUtils.createContentHelper(providerName);
        return this;
    }

    private SecretKey calculateAgreedWrapKey(AlgorithmIdentifier keyEncAlg, AlgorithmIdentifier wrapAlg, PublicKey senderPublicKey, ASN1OctetString userKeyingMaterial, PrivateKey receiverPrivateKey, KeyMaterialGenerator kmGen) throws CMSException, GeneralSecurityException, IOException {
        if (CMSUtils.isMQV(keyEncAlg.getAlgorithm())) {
            byte[] byArray;
            MQVuserKeyingMaterial mQVuserKeyingMaterial = MQVuserKeyingMaterial.getInstance(userKeyingMaterial.getOctets());
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(this.getPrivateKeyAlgorithmIdentifier(), mQVuserKeyingMaterial.getEphemeralPublicKey().getPublicKey().getBytes());
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            KeyFactory keyFactory = this.helper.createKeyFactory(keyEncAlg.getAlgorithm());
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            KeyAgreement keyAgreement = this.helper.createKeyAgreement(keyEncAlg.getAlgorithm());
            byte[] byArray2 = byArray = mQVuserKeyingMaterial.getAddedukm() != null ? mQVuserKeyingMaterial.getAddedukm().getOctets() : null;
            if (kmGen == old_ecc_cms_Generator) {
                byArray = old_ecc_cms_Generator.generateKDFMaterial(wrapAlg, this.keySizeProvider.getKeySize(wrapAlg), byArray);
            }
            keyAgreement.init((Key)receiverPrivateKey, new MQVParameterSpec(receiverPrivateKey, publicKey, byArray));
            keyAgreement.doPhase(senderPublicKey, true);
            return keyAgreement.generateSecret(wrapAlg.getAlgorithm().getId());
        }
        KeyAgreement keyAgreement = this.helper.createKeyAgreement(keyEncAlg.getAlgorithm());
        UserKeyingMaterialSpec userKeyingMaterialSpec = null;
        if (CMSUtils.isEC(keyEncAlg.getAlgorithm())) {
            if (userKeyingMaterial != null) {
                byte[] byArray = kmGen.generateKDFMaterial(wrapAlg, this.keySizeProvider.getKeySize(wrapAlg), userKeyingMaterial.getOctets());
                userKeyingMaterialSpec = new UserKeyingMaterialSpec(byArray);
            } else {
                byte[] byArray = kmGen.generateKDFMaterial(wrapAlg, this.keySizeProvider.getKeySize(wrapAlg), null);
                userKeyingMaterialSpec = new UserKeyingMaterialSpec(byArray);
            }
        } else if (CMSUtils.isRFC2631(keyEncAlg.getAlgorithm())) {
            if (userKeyingMaterial != null) {
                userKeyingMaterialSpec = new UserKeyingMaterialSpec(userKeyingMaterial.getOctets());
            }
        } else if (CMSUtils.isGOST(keyEncAlg.getAlgorithm())) {
            if (userKeyingMaterial != null) {
                userKeyingMaterialSpec = new UserKeyingMaterialSpec(userKeyingMaterial.getOctets());
            }
        } else {
            throw new CMSException("Unknown key agreement algorithm: " + keyEncAlg.getAlgorithm());
        }
        keyAgreement.init((Key)receiverPrivateKey, userKeyingMaterialSpec);
        keyAgreement.doPhase(senderPublicKey, true);
        return keyAgreement.generateSecret(wrapAlg.getAlgorithm().getId());
    }

    private Key unwrapSessionKey(ASN1ObjectIdentifier wrapAlg, SecretKey agreedKey, ASN1ObjectIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException, InvalidKeyException, NoSuchAlgorithmException {
        Cipher cipher = this.helper.createCipher(wrapAlg);
        cipher.init(4, agreedKey);
        return cipher.unwrap(encryptedContentEncryptionKey, this.helper.getBaseCipherName(contentEncryptionAlgorithm), 3);
    }

    protected Key extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier contentEncryptionAlgorithm, SubjectPublicKeyInfo senderKey, ASN1OctetString userKeyingMaterial, byte[] encryptedContentEncryptionKey) throws CMSException {
        try {
            AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance(keyEncryptionAlgorithm.getParameters());
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(senderKey.getEncoded());
            KeyFactory keyFactory = this.helper.createKeyFactory(senderKey.getAlgorithm().getAlgorithm());
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            try {
                SecretKey secretKey = this.calculateAgreedWrapKey(keyEncryptionAlgorithm, algorithmIdentifier, publicKey, userKeyingMaterial, this.recipientKey, ecc_cms_Generator);
                return this.unwrapSessionKey(algorithmIdentifier.getAlgorithm(), secretKey, contentEncryptionAlgorithm.getAlgorithm(), encryptedContentEncryptionKey);
            }
            catch (InvalidKeyException invalidKeyException) {
                if (possibleOldMessages.contains(keyEncryptionAlgorithm.getAlgorithm())) {
                    SecretKey secretKey = this.calculateAgreedWrapKey(keyEncryptionAlgorithm, algorithmIdentifier, publicKey, userKeyingMaterial, this.recipientKey, old_ecc_cms_Generator);
                    return this.unwrapSessionKey(algorithmIdentifier.getAlgorithm(), secretKey, contentEncryptionAlgorithm.getAlgorithm(), encryptedContentEncryptionKey);
                }
                throw invalidKeyException;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new CMSException("originator key spec invalid.", invalidKeySpecException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (Exception exception) {
            throw new CMSException("originator key invalid.", exception);
        }
    }

    public AlgorithmIdentifier getPrivateKeyAlgorithmIdentifier() {
        return PrivateKeyInfo.getInstance(this.recipientKey.getEncoded()).getPrivateKeyAlgorithm();
    }

    static {
        possibleOldMessages.add(X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme);
        possibleOldMessages.add(X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme);
        old_ecc_cms_Generator = new KeyMaterialGenerator(){

            public byte[] generateKDFMaterial(AlgorithmIdentifier keyAlgorithm, int keySize, byte[] userKeyMaterialParameters) {
                ECCCMSSharedInfo eCCCMSSharedInfo = new ECCCMSSharedInfo(new AlgorithmIdentifier(keyAlgorithm.getAlgorithm(), DERNull.INSTANCE), userKeyMaterialParameters, Pack.intToBigEndian(keySize));
                try {
                    return eCCCMSSharedInfo.getEncoded("DER");
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Unable to create KDF material: " + iOException);
                }
            }
        };
        ecc_cms_Generator = new RFC5753KeyMaterialGenerator();
    }
}

