/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.cms.IssuerAndSerialNumber;
import com.aspose.html.internal.ms.core.bc.asn1.cms.KeyTransRecipientInfo;
import com.aspose.html.internal.ms.core.bc.asn1.cms.RecipientIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.cms.RecipientInfo;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.RecipientInfoGenerator;
import com.aspose.html.internal.ms.core.bc.operator.AsymmetricKeyWrapper;
import com.aspose.html.internal.ms.core.bc.operator.GenericKey;
import com.aspose.html.internal.ms.core.bc.operator.OperatorException;

public abstract class KeyTransRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final AsymmetricKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KeyTransRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerial, AsymmetricKeyWrapper wrapper) {
        this.issuerAndSerial = issuerAndSerial;
        this.wrapper = wrapper;
    }

    protected KeyTransRecipientInfoGenerator(byte[] subjectKeyIdentifier, AsymmetricKeyWrapper wrapper) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.wrapper = wrapper;
    }

    public final RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        byte[] byArray;
        try {
            byArray = this.wrapper.generateWrappedKey(contentEncryptionKey);
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
        RecipientIdentifier recipientIdentifier = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new KeyTransRecipientInfo(recipientIdentifier, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(byArray)));
    }
}

