/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.selector.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.cert.selector.X509CertificateHolderSelector;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509CertSelector;

public class JcaX509CertSelectorConverter {
    protected X509CertSelector doConversion(X500Name issuer, BigInteger serialNumber, byte[] subjectKeyIdentifier) {
        X509CertSelector x509CertSelector = new X509CertSelector();
        if (issuer != null) {
            try {
                x509CertSelector.setIssuer(issuer.getEncoded());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to convert issuer: " + iOException.getMessage());
            }
        }
        if (serialNumber != null) {
            x509CertSelector.setSerialNumber(serialNumber);
        }
        if (subjectKeyIdentifier != null) {
            try {
                x509CertSelector.setSubjectKeyIdentifier(new DEROctetString(subjectKeyIdentifier).getEncoded());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to convert issuer: " + iOException.getMessage());
            }
        }
        return x509CertSelector;
    }

    public X509CertSelector getCertSelector(X509CertificateHolderSelector holderSelector) {
        return this.doConversion(holderSelector.getIssuer(), holderSelector.getSerialNumber(), holderSelector.getSubjectKeyIdentifier());
    }
}

