/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.path.validations;

import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.cert.X509CRLHolder;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidation;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidationContext;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidationException;
import com.aspose.html.internal.ms.core.bc.util.Memoable;
import com.aspose.html.internal.ms.core.bc.util.Selector;
import com.aspose.html.internal.ms.core.bc.util.Store;
import java.util.Collection;

public class CRLValidation
implements CertPathValidation {
    private Store crls;
    private X500Name workingIssuerName;

    public CRLValidation(X500Name trustAnchorName, Store crls) {
        this.workingIssuerName = trustAnchorName;
        this.crls = crls;
    }

    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        Collection collection = this.crls.getMatches(new Selector(){

            public boolean match(Object obj) {
                X509CRLHolder x509CRLHolder = (X509CRLHolder)obj;
                return x509CRLHolder.getIssuer().equals(CRLValidation.this.workingIssuerName);
            }

            public Object clone() {
                return this;
            }
        });
        if (collection.isEmpty()) {
            throw new CertPathValidationException("CRL for " + this.workingIssuerName + " not found");
        }
        for (X509CRLHolder x509CRLHolder : collection) {
            if (x509CRLHolder.getRevokedCertificate(certificate.getSerialNumber()) == null) continue;
            throw new CertPathValidationException("Certificate revoked");
        }
        this.workingIssuerName = certificate.getSubject();
    }

    public Memoable copy() {
        return new CRLValidation(this.workingIssuerName, this.crls);
    }

    public void reset(Memoable other) {
        CRLValidation cRLValidation = (CRLValidation)other;
        this.workingIssuerName = cRLValidation.workingIssuerName;
        this.crls = cRLValidation.crls;
    }
}

