/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.path.validations;

import com.aspose.html.internal.ms.core.bc.asn1.x509.BasicConstraints;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidation;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidationContext;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidationException;
import com.aspose.html.internal.ms.core.bc.util.Memoable;
import java.math.BigInteger;

public class BasicConstraintsValidation
implements CertPathValidation {
    private boolean isMandatory;
    private BasicConstraints bc;
    private int pathLengthRemaining;
    private BigInteger maxPathLength;

    public BasicConstraintsValidation() {
        this(true);
    }

    public BasicConstraintsValidation(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        if (this.maxPathLength != null && this.pathLengthRemaining < 0) {
            throw new CertPathValidationException("BasicConstraints path length exceeded");
        }
        context.addHandledExtension(Extension.basicConstraints);
        BasicConstraints basicConstraints = BasicConstraints.fromExtensions(certificate.getExtensions());
        if (basicConstraints != null) {
            if (this.bc != null) {
                int n2;
                BigInteger bigInteger;
                if (basicConstraints.isCA() && (bigInteger = basicConstraints.getPathLenConstraint()) != null && (n2 = bigInteger.intValue()) < this.pathLengthRemaining) {
                    this.pathLengthRemaining = n2;
                    this.bc = basicConstraints;
                }
            } else {
                this.bc = basicConstraints;
                if (basicConstraints.isCA()) {
                    this.maxPathLength = basicConstraints.getPathLenConstraint();
                    if (this.maxPathLength != null) {
                        this.pathLengthRemaining = this.maxPathLength.intValue();
                    }
                }
            }
        } else if (this.bc != null) {
            --this.pathLengthRemaining;
        }
        if (this.isMandatory && this.bc == null) {
            throw new CertPathValidationException("BasicConstraints not present in path");
        }
    }

    public Memoable copy() {
        BasicConstraintsValidation basicConstraintsValidation = new BasicConstraintsValidation(this.isMandatory);
        basicConstraintsValidation.bc = this.bc;
        basicConstraintsValidation.pathLengthRemaining = this.pathLengthRemaining;
        return basicConstraintsValidation;
    }

    public void reset(Memoable other) {
        BasicConstraintsValidation basicConstraintsValidation = (BasicConstraintsValidation)other;
        this.isMandatory = basicConstraintsValidation.isMandatory;
        this.bc = basicConstraintsValidation.bc;
        this.pathLengthRemaining = basicConstraintsValidation.pathLengthRemaining;
    }
}

