/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.path;

import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathUtils;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidation;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidationContext;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidationException;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidationResult;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidationResultBuilder;

public class CertPath {
    private final X509CertificateHolder[] certificates;

    public CertPath(X509CertificateHolder[] certificates) {
        this.certificates = this.copyArray(certificates);
    }

    public X509CertificateHolder[] getCertificates() {
        return this.copyArray(this.certificates);
    }

    public CertPathValidationResult validate(CertPathValidation[] ruleSet) {
        CertPathValidationContext certPathValidationContext = new CertPathValidationContext(CertPathUtils.getCriticalExtensionsOIDs(this.certificates));
        for (int i2 = 0; i2 != ruleSet.length; ++i2) {
            for (int i3 = this.certificates.length - 1; i3 >= 0; --i3) {
                try {
                    certPathValidationContext.setIsEndEntity(i3 == 0);
                    ruleSet[i2].validate(certPathValidationContext, this.certificates[i3]);
                    continue;
                }
                catch (CertPathValidationException certPathValidationException) {
                    return new CertPathValidationResult(certPathValidationContext, i3, i2, certPathValidationException);
                }
            }
        }
        return new CertPathValidationResult(certPathValidationContext);
    }

    public CertPathValidationResult evaluate(CertPathValidation[] ruleSet) {
        CertPathValidationContext certPathValidationContext = new CertPathValidationContext(CertPathUtils.getCriticalExtensionsOIDs(this.certificates));
        CertPathValidationResultBuilder certPathValidationResultBuilder = new CertPathValidationResultBuilder(certPathValidationContext);
        for (int i2 = 0; i2 != ruleSet.length; ++i2) {
            for (int i3 = this.certificates.length - 1; i3 >= 0; --i3) {
                try {
                    certPathValidationContext.setIsEndEntity(i3 == 0);
                    ruleSet[i2].validate(certPathValidationContext, this.certificates[i3]);
                    continue;
                }
                catch (CertPathValidationException certPathValidationException) {
                    certPathValidationResultBuilder.addException(i3, i2, certPathValidationException);
                }
            }
        }
        return certPathValidationResultBuilder.build();
    }

    private X509CertificateHolder[] copyArray(X509CertificateHolder[] array) {
        X509CertificateHolder[] x509CertificateHolderArray = new X509CertificateHolder[array.length];
        System.arraycopy(array, 0, x509CertificateHolderArray, 0, x509CertificateHolderArray.length);
        return x509CertificateHolderArray;
    }

    public int length() {
        return this.certificates.length;
    }
}

