/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.crmf.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.jcajce.CRMFHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.DefaultJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.NamedJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.ProviderJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.operator.DefaultSecretKeySizeProvider;
import com.aspose.html.internal.ms.core.bc.operator.GenericKey;
import com.aspose.html.internal.ms.core.bc.operator.OutputEncryptor;
import com.aspose.html.internal.ms.core.bc.operator.SecretKeySizeProvider;
import com.aspose.html.internal.ms.core.bc.operator.jcajce.JceGenericKey;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class JceCRMFEncryptorBuilder {
    private static final SecretKeySizeProvider KEY_SIZE_PROVIDER = DefaultSecretKeySizeProvider.INSTANCE;
    private final ASN1ObjectIdentifier encryptionOID;
    private final int keySize;
    private CRMFHelper helper = new CRMFHelper(new DefaultJcaJceHelper());
    private SecureRandom random;

    public JceCRMFEncryptorBuilder(ASN1ObjectIdentifier encryptionOID) {
        this(encryptionOID, -1);
    }

    public JceCRMFEncryptorBuilder(ASN1ObjectIdentifier encryptionOID, int keySize) {
        this.encryptionOID = encryptionOID;
        this.keySize = keySize;
    }

    public JceCRMFEncryptorBuilder setProvider(Provider provider) {
        this.helper = new CRMFHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceCRMFEncryptorBuilder setProvider(String providerName) {
        this.helper = new CRMFHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JceCRMFEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public OutputEncryptor build() throws CRMFException {
        return new CRMFOutputEncryptor(this.encryptionOID, this.keySize, this.random);
    }

    private class CRMFOutputEncryptor
    implements OutputEncryptor {
        private SecretKey encKey;
        private AlgorithmIdentifier algorithmIdentifier;
        private Cipher cipher;

        CRMFOutputEncryptor(ASN1ObjectIdentifier encryptionOID, int keySize, SecureRandom random) throws CRMFException {
            KeyGenerator keyGenerator = JceCRMFEncryptorBuilder.this.helper.createKeyGenerator(encryptionOID);
            if (random == null) {
                random = new SecureRandom();
            }
            if (keySize < 0) {
                keySize = KEY_SIZE_PROVIDER.getKeySize(encryptionOID);
            }
            if (keySize < 0) {
                keyGenerator.init(random);
            } else {
                keyGenerator.init(keySize, random);
            }
            this.cipher = JceCRMFEncryptorBuilder.this.helper.createCipher(encryptionOID);
            this.encKey = keyGenerator.generateKey();
            AlgorithmParameters algorithmParameters = JceCRMFEncryptorBuilder.this.helper.generateParameters(encryptionOID, this.encKey, random);
            try {
                this.cipher.init(1, (Key)this.encKey, algorithmParameters, random);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CRMFException("unable to initialize cipher: " + generalSecurityException.getMessage(), generalSecurityException);
            }
            if (algorithmParameters == null) {
                algorithmParameters = this.cipher.getParameters();
            }
            this.algorithmIdentifier = JceCRMFEncryptorBuilder.this.helper.getAlgorithmIdentifier(encryptionOID, algorithmParameters);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmIdentifier;
        }

        public OutputStream getOutputStream(OutputStream dOut) {
            return new CipherOutputStream(dOut, this.cipher);
        }

        public GenericKey getKey() {
            return new JceGenericKey(this.algorithmIdentifier, this.encKey);
        }
    }
}

