/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.crmf;

import com.aspose.html.internal.ms.core.bc.asn1.crmf.EncryptedValue;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Certificate;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.EncryptedValuePadder;
import com.aspose.html.internal.ms.core.bc.cert.crmf.ValueDecryptorGenerator;
import com.aspose.html.internal.ms.core.bc.operator.InputDecryptor;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import com.aspose.html.internal.ms.core.bc.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EncryptedValueParser {
    private EncryptedValue value;
    private EncryptedValuePadder padder;

    public EncryptedValueParser(EncryptedValue value) {
        this.value = value;
    }

    public EncryptedValueParser(EncryptedValue value, EncryptedValuePadder padder) {
        this.value = value;
        this.padder = padder;
    }

    public AlgorithmIdentifier getIntendedAlg() {
        return this.value.getIntendedAlg();
    }

    private byte[] decryptValue(ValueDecryptorGenerator decGen) throws CRMFException {
        if (this.value.getValueHint() != null) {
            throw new UnsupportedOperationException();
        }
        InputDecryptor inputDecryptor = decGen.getValueDecryptor(this.value.getKeyAlg(), this.value.getSymmAlg(), this.value.getEncSymmKey().getBytes());
        InputStream inputStream = inputDecryptor.getInputStream(new ByteArrayInputStream(this.value.getEncValue().getBytes()));
        try {
            byte[] byArray = Streams.readAll(inputStream);
            if (this.padder != null) {
                return this.padder.getUnpaddedData(byArray);
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new CRMFException("Cannot parse decrypted data: " + iOException.getMessage(), iOException);
        }
    }

    public X509CertificateHolder readCertificateHolder(ValueDecryptorGenerator decGen) throws CRMFException {
        return new X509CertificateHolder(Certificate.getInstance(this.decryptValue(decGen)));
    }

    public PrivateKeyInfo readPrivateKeyInfo(ValueDecryptorGenerator decGen) throws CRMFException {
        return PrivateKeyInfo.getInstance(this.decryptValue(decGen));
    }

    public char[] readPassphrase(ValueDecryptorGenerator decGen) throws CRMFException {
        return Strings.fromUTF8ByteArray(this.decryptValue(decGen)).toCharArray();
    }
}

