/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.crmf;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.DERUTF8String;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.AttributeTypeAndValue;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.CRMFObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.CertReqMsg;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.CertTemplate;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.Controls;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.PKIArchiveOptions;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.PKMACValue;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.POPOSigningKey;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.ProofOfPossession;
import com.aspose.html.internal.ms.core.bc.cert.CertIOException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.AuthenticatorControl;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFUtil;
import com.aspose.html.internal.ms.core.bc.cert.crmf.Control;
import com.aspose.html.internal.ms.core.bc.cert.crmf.PKIArchiveControl;
import com.aspose.html.internal.ms.core.bc.cert.crmf.PKMACBuilder;
import com.aspose.html.internal.ms.core.bc.cert.crmf.PKMACValueVerifier;
import com.aspose.html.internal.ms.core.bc.cert.crmf.RegTokenControl;
import com.aspose.html.internal.ms.core.bc.operator.ContentVerifier;
import com.aspose.html.internal.ms.core.bc.operator.ContentVerifierProvider;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.internal.ms.core.bc.util.Encodable;
import java.io.IOException;

public class CertificateRequestMessage
implements Encodable {
    public static final int popRaVerified = 0;
    public static final int popSigningKey = 1;
    public static final int popKeyEncipherment = 2;
    public static final int popKeyAgreement = 3;
    private final CertReqMsg certReqMsg;
    private final Controls controls;

    private static CertReqMsg parseBytes(byte[] encoding) throws IOException {
        try {
            return CertReqMsg.getInstance(ASN1Primitive.fromByteArray(encoding));
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public CertificateRequestMessage(byte[] certReqMsg) throws IOException {
        this(CertificateRequestMessage.parseBytes(certReqMsg));
    }

    public CertificateRequestMessage(CertReqMsg certReqMsg) {
        this.certReqMsg = certReqMsg;
        this.controls = certReqMsg.getCertReq().getControls();
    }

    public CertReqMsg toASN1Structure() {
        return this.certReqMsg;
    }

    public CertTemplate getCertTemplate() {
        return this.certReqMsg.getCertReq().getCertTemplate();
    }

    public boolean hasControls() {
        return this.controls != null;
    }

    public boolean hasControl(ASN1ObjectIdentifier type) {
        return this.findControl(type) != null;
    }

    public Control getControl(ASN1ObjectIdentifier type) {
        AttributeTypeAndValue attributeTypeAndValue = this.findControl(type);
        if (attributeTypeAndValue != null) {
            if (attributeTypeAndValue.getType().equals(CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions)) {
                return new PKIArchiveControl(PKIArchiveOptions.getInstance(attributeTypeAndValue.getValue()));
            }
            if (attributeTypeAndValue.getType().equals(CRMFObjectIdentifiers.id_regCtrl_regToken)) {
                return new RegTokenControl(DERUTF8String.getInstance(attributeTypeAndValue.getValue()));
            }
            if (attributeTypeAndValue.getType().equals(CRMFObjectIdentifiers.id_regCtrl_authenticator)) {
                return new AuthenticatorControl(DERUTF8String.getInstance(attributeTypeAndValue.getValue()));
            }
        }
        return null;
    }

    private AttributeTypeAndValue findControl(ASN1ObjectIdentifier type) {
        if (this.controls == null) {
            return null;
        }
        AttributeTypeAndValue[] attributeTypeAndValueArray = this.controls.toAttributeTypeAndValueArray();
        AttributeTypeAndValue attributeTypeAndValue = null;
        for (int i2 = 0; i2 != attributeTypeAndValueArray.length; ++i2) {
            if (!attributeTypeAndValueArray[i2].getType().equals(type)) continue;
            attributeTypeAndValue = attributeTypeAndValueArray[i2];
            break;
        }
        return attributeTypeAndValue;
    }

    public boolean hasProofOfPossession() {
        return this.certReqMsg.getPopo() != null;
    }

    public int getProofOfPossessionType() {
        return this.certReqMsg.getPopo().getType();
    }

    public boolean hasSigningKeyProofOfPossessionWithPKMAC() {
        ProofOfPossession proofOfPossession = this.certReqMsg.getPopo();
        if (proofOfPossession.getType() == 1) {
            POPOSigningKey pOPOSigningKey = POPOSigningKey.getInstance(proofOfPossession.getObject());
            return pOPOSigningKey.getPoposkInput().getPublicKeyMAC() != null;
        }
        return false;
    }

    public boolean isValidSigningKeyPOP(ContentVerifierProvider verifierProvider) throws CRMFException, IllegalStateException {
        ProofOfPossession proofOfPossession = this.certReqMsg.getPopo();
        if (proofOfPossession.getType() == 1) {
            POPOSigningKey pOPOSigningKey = POPOSigningKey.getInstance(proofOfPossession.getObject());
            if (pOPOSigningKey.getPoposkInput() != null && pOPOSigningKey.getPoposkInput().getPublicKeyMAC() != null) {
                throw new IllegalStateException("verification requires password check");
            }
            return this.verifySignature(verifierProvider, pOPOSigningKey);
        }
        throw new IllegalStateException("not Signing Key type of proof of possession");
    }

    public boolean isValidSigningKeyPOP(ContentVerifierProvider verifierProvider, PKMACBuilder macBuilder, char[] password) throws CRMFException, IllegalStateException {
        ProofOfPossession proofOfPossession = this.certReqMsg.getPopo();
        if (proofOfPossession.getType() == 1) {
            POPOSigningKey pOPOSigningKey = POPOSigningKey.getInstance(proofOfPossession.getObject());
            if (pOPOSigningKey.getPoposkInput() == null || pOPOSigningKey.getPoposkInput().getSender() != null) {
                throw new IllegalStateException("no PKMAC present in proof of possession");
            }
            PKMACValueVerifier pKMACValueVerifier = new PKMACValueVerifier(macBuilder);
            PKMACValue pKMACValue = pOPOSigningKey.getPoposkInput().getPublicKeyMAC();
            if (pKMACValueVerifier.isValid(pKMACValue, password, this.getCertTemplate().getPublicKey())) {
                return this.verifySignature(verifierProvider, pOPOSigningKey);
            }
            return false;
        }
        throw new IllegalStateException("not Signing Key type of proof of possession");
    }

    private boolean verifySignature(ContentVerifierProvider verifierProvider, POPOSigningKey popoSign) throws CRMFException {
        ContentVerifier contentVerifier;
        try {
            contentVerifier = verifierProvider.get(popoSign.getAlgorithmIdentifier());
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CRMFException("unable to create verifier: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        if (popoSign.getPoposkInput() != null) {
            CRMFUtil.derEncodeToStream(popoSign.getPoposkInput(), contentVerifier.getOutputStream());
        } else {
            CRMFUtil.derEncodeToStream(this.certReqMsg.getCertReq(), contentVerifier.getOutputStream());
        }
        return contentVerifier.verify(popoSign.getSignature().getOctets());
    }

    public byte[] getEncoded() throws IOException {
        return this.certReqMsg.getEncoded();
    }
}

