/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.cmp;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1GeneralizedTime;
import com.aspose.html.internal.ms.core.bc.asn1.DERBitString;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.CMPCertificate;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.InfoTypeAndValue;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.PKIBody;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.PKIFreeText;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.PKIHeader;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.PKIHeaderBuilder;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.PKIMessage;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralName;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.cmp.CMPException;
import com.aspose.html.internal.ms.core.bc.cert.cmp.ProtectedPKIMessage;
import com.aspose.html.internal.ms.core.bc.operator.ContentSigner;
import com.aspose.html.internal.ms.core.bc.operator.MacCalculator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProtectedPKIMessageBuilder {
    private PKIHeaderBuilder hdrBuilder;
    private PKIBody body;
    private List generalInfos = new ArrayList();
    private List extraCerts = new ArrayList();

    public ProtectedPKIMessageBuilder(GeneralName sender, GeneralName recipient) {
        this(2, sender, recipient);
    }

    public ProtectedPKIMessageBuilder(int pvno, GeneralName sender, GeneralName recipient) {
        this.hdrBuilder = new PKIHeaderBuilder(pvno, sender, recipient);
    }

    public ProtectedPKIMessageBuilder setTransactionID(byte[] tid) {
        this.hdrBuilder.setTransactionID(tid);
        return this;
    }

    public ProtectedPKIMessageBuilder setFreeText(PKIFreeText freeText) {
        this.hdrBuilder.setFreeText(freeText);
        return this;
    }

    public ProtectedPKIMessageBuilder addGeneralInfo(InfoTypeAndValue genInfo) {
        this.generalInfos.add(genInfo);
        return this;
    }

    public ProtectedPKIMessageBuilder setMessageTime(Date time) {
        this.hdrBuilder.setMessageTime(new ASN1GeneralizedTime(time));
        return this;
    }

    public ProtectedPKIMessageBuilder setRecipKID(byte[] kid) {
        this.hdrBuilder.setRecipKID(kid);
        return this;
    }

    public ProtectedPKIMessageBuilder setRecipNonce(byte[] nonce) {
        this.hdrBuilder.setRecipNonce(nonce);
        return this;
    }

    public ProtectedPKIMessageBuilder setSenderKID(byte[] kid) {
        this.hdrBuilder.setSenderKID(kid);
        return this;
    }

    public ProtectedPKIMessageBuilder setSenderNonce(byte[] nonce) {
        this.hdrBuilder.setSenderNonce(nonce);
        return this;
    }

    public ProtectedPKIMessageBuilder setBody(PKIBody body) {
        this.body = body;
        return this;
    }

    public ProtectedPKIMessageBuilder addCMPCertificate(X509CertificateHolder extraCert) {
        this.extraCerts.add(extraCert);
        return this;
    }

    public ProtectedPKIMessage build(MacCalculator macCalculator) throws CMPException {
        this.finaliseHeader(macCalculator.getAlgorithmIdentifier());
        PKIHeader pKIHeader = this.hdrBuilder.build();
        try {
            DERBitString dERBitString = new DERBitString(this.calculateMac(macCalculator, pKIHeader, this.body));
            return this.finaliseMessage(pKIHeader, dERBitString);
        }
        catch (IOException iOException) {
            throw new CMPException("unable to encode MAC input: " + iOException.getMessage(), iOException);
        }
    }

    public ProtectedPKIMessage build(ContentSigner signer) throws CMPException {
        this.finaliseHeader(signer.getAlgorithmIdentifier());
        PKIHeader pKIHeader = this.hdrBuilder.build();
        try {
            DERBitString dERBitString = new DERBitString(this.calculateSignature(signer, pKIHeader, this.body));
            return this.finaliseMessage(pKIHeader, dERBitString);
        }
        catch (IOException iOException) {
            throw new CMPException("unable to encode signature input: " + iOException.getMessage(), iOException);
        }
    }

    private void finaliseHeader(AlgorithmIdentifier algorithmIdentifier) {
        this.hdrBuilder.setProtectionAlg(algorithmIdentifier);
        if (!this.generalInfos.isEmpty()) {
            InfoTypeAndValue[] infoTypeAndValueArray = new InfoTypeAndValue[this.generalInfos.size()];
            this.hdrBuilder.setGeneralInfo(this.generalInfos.toArray(infoTypeAndValueArray));
        }
    }

    private ProtectedPKIMessage finaliseMessage(PKIHeader header, DERBitString protection) {
        if (!this.extraCerts.isEmpty()) {
            CMPCertificate[] cMPCertificateArray = new CMPCertificate[this.extraCerts.size()];
            for (int i2 = 0; i2 != cMPCertificateArray.length; ++i2) {
                cMPCertificateArray[i2] = new CMPCertificate(((X509CertificateHolder)this.extraCerts.get(i2)).toASN1Structure());
            }
            return new ProtectedPKIMessage(new PKIMessage(header, this.body, protection, cMPCertificateArray));
        }
        return new ProtectedPKIMessage(new PKIMessage(header, this.body, protection));
    }

    private byte[] calculateSignature(ContentSigner signer, PKIHeader header, PKIBody body) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(header);
        aSN1EncodableVector.add(body);
        OutputStream outputStream = signer.getOutputStream();
        outputStream.write(new DERSequence(aSN1EncodableVector).getEncoded("DER"));
        outputStream.close();
        return signer.getSignature();
    }

    private byte[] calculateMac(MacCalculator macCalculator, PKIHeader header, PKIBody body) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(header);
        aSN1EncodableVector.add(body);
        OutputStream outputStream = macCalculator.getOutputStream();
        outputStream.write(new DERSequence(aSN1EncodableVector).getEncoded("DER"));
        outputStream.close();
        return macCalculator.getMac();
    }
}

