/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.cmp;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.PKIBody;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.PKIHeader;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.PKIMessage;
import com.aspose.html.internal.ms.core.bc.cert.CertIOException;
import java.io.IOException;

public class GeneralPKIMessage {
    private final PKIMessage pkiMessage;

    private static PKIMessage parseBytes(byte[] encoding) throws IOException {
        try {
            return PKIMessage.getInstance(ASN1Primitive.fromByteArray(encoding));
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public GeneralPKIMessage(byte[] encoding) throws IOException {
        this(GeneralPKIMessage.parseBytes(encoding));
    }

    public GeneralPKIMessage(PKIMessage pkiMessage) {
        this.pkiMessage = pkiMessage;
    }

    public PKIHeader getHeader() {
        return this.pkiMessage.getHeader();
    }

    public PKIBody getBody() {
        return this.pkiMessage.getBody();
    }

    public boolean hasProtection() {
        return this.pkiMessage.getHeader().getProtectionAlg() != null;
    }

    public PKIMessage toASN1Structure() {
        return this.pkiMessage;
    }
}

