/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.asn1.icao;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Object;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.icao.DataGroupHash;
import com.aspose.html.internal.ms.core.bc.asn1.icao.ICAOObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.icao.LDSVersionInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class LDSSecurityObject
extends ASN1Object
implements ICAOObjectIdentifiers {
    public static final int ub_DataGroups = 16;
    private ASN1Integer version = new ASN1Integer(0L);
    private AlgorithmIdentifier digestAlgorithmIdentifier;
    private DataGroupHash[] datagroupHash;
    private LDSVersionInfo versionInfo;

    public static LDSSecurityObject getInstance(Object object) {
        if (object instanceof LDSSecurityObject) {
            return (LDSSecurityObject)object;
        }
        if (object != null) {
            return new LDSSecurityObject(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private LDSSecurityObject(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence == null || aSN1Sequence.size() == 0) {
            throw new IllegalArgumentException("null or empty sequence passed.");
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.version = ASN1Integer.getInstance(enumeration.nextElement());
        this.digestAlgorithmIdentifier = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(enumeration.nextElement());
        if (this.version.getValue().intValue() == 1) {
            this.versionInfo = LDSVersionInfo.getInstance(enumeration.nextElement());
        }
        this.checkDatagroupHashSeqSize(aSN1Sequence2.size());
        this.datagroupHash = new DataGroupHash[aSN1Sequence2.size()];
        for (int i2 = 0; i2 < aSN1Sequence2.size(); ++i2) {
            this.datagroupHash[i2] = DataGroupHash.getInstance(aSN1Sequence2.getObjectAt(i2));
        }
    }

    public LDSSecurityObject(AlgorithmIdentifier algorithmIdentifier, DataGroupHash[] dataGroupHashArray) {
        this.version = new ASN1Integer(0L);
        this.digestAlgorithmIdentifier = algorithmIdentifier;
        this.datagroupHash = (DataGroupHash[])dataGroupHashArray.clone();
        this.checkDatagroupHashSeqSize(dataGroupHashArray.length);
    }

    public LDSSecurityObject(AlgorithmIdentifier algorithmIdentifier, DataGroupHash[] dataGroupHashArray, LDSVersionInfo lDSVersionInfo) {
        this.version = new ASN1Integer(1L);
        this.digestAlgorithmIdentifier = algorithmIdentifier;
        this.datagroupHash = (DataGroupHash[])dataGroupHashArray.clone();
        this.versionInfo = lDSVersionInfo;
        this.checkDatagroupHashSeqSize(dataGroupHashArray.length);
    }

    private void checkDatagroupHashSeqSize(int n2) {
        if (n2 < 2 || n2 > 16) {
            throw new IllegalArgumentException("wrong size in DataGroupHashValues : not in (2..16)");
        }
    }

    public int getVersion() {
        return this.version.getValue().intValue();
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return this.digestAlgorithmIdentifier;
    }

    public DataGroupHash[] getDatagroupHash() {
        DataGroupHash[] dataGroupHashArray = new DataGroupHash[this.datagroupHash.length];
        System.arraycopy(this.datagroupHash, 0, dataGroupHashArray, 0, dataGroupHashArray.length);
        return dataGroupHashArray;
    }

    public LDSVersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.version);
        aSN1EncodableVector.add(this.digestAlgorithmIdentifier);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i2 = 0; i2 < this.datagroupHash.length; ++i2) {
            aSN1EncodableVector2.add(this.datagroupHash[i2]);
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        if (this.versionInfo != null) {
            aSN1EncodableVector.add(this.versionInfo);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

