/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.asn1;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1OutputStream;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1String;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1TaggedObject;
import com.aspose.html.internal.ms.core.bc.asn1.StreamUtil;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.IOException;

public class DERIA5String
extends ASN1Primitive
implements ASN1String {
    private byte[] string;

    public static DERIA5String getInstance(Object object) {
        if (object == null || object instanceof DERIA5String) {
            return (DERIA5String)object;
        }
        if (object instanceof byte[]) {
            try {
                return (DERIA5String)DERIA5String.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("Illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERIA5String getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl2 || aSN1Primitive instanceof DERIA5String) {
            return DERIA5String.getInstance(aSN1Primitive);
        }
        return new DERIA5String(((ASN1OctetString)aSN1Primitive).getOctets());
    }

    DERIA5String(byte[] byArray) {
        this.string = byArray;
    }

    public DERIA5String(String string) {
        this(string, false);
    }

    public DERIA5String(String string, boolean bl2) {
        if (string == null) {
            throw new NullPointerException("string cannot be null");
        }
        if (bl2 && !DERIA5String.isIA5String(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.string = Strings.toByteArray(string);
    }

    public String getString() {
        return Strings.fromByteArray(this.string);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.writeEncoded(22, this.string);
    }

    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERIA5String)) {
            return false;
        }
        DERIA5String dERIA5String = (DERIA5String)aSN1Primitive;
        return Arrays.areEqual(this.string, dERIA5String.string);
    }

    public static boolean isIA5String(String string) {
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (c2 <= '\u007f') continue;
            return false;
        }
        return true;
    }
}

