/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.IO.File;
import com.aspose.html.internal.ms.System.IO.FileStream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;

public class ASN1 {
    private byte a;
    private byte[] b;
    private ArrayList c;

    public ASN1() {
        this(0, null);
    }

    public ASN1(byte tag) {
        this(tag, null);
    }

    public ASN1(byte tag, byte[] data) {
        this.a = tag;
        this.b = data;
    }

    public ASN1(byte[] data) {
        int n2;
        this.a = data[0];
        int n3 = 0;
        int n4 = data[1] & 0xFF;
        if (n4 > 128) {
            n3 = n4 - 128;
            n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                n4 *= 256;
                n4 += data[n2 + 2] & 0xFF;
            }
        } else if (n4 == 128) {
            throw new NotSupportedException("Undefined length encoding.");
        }
        this.b = new byte[n4];
        Buffer.blockCopy(Array.boxing(data), 2 + n3, Array.boxing(this.b), 0, n4);
        if ((this.a & 0xFF & 0x20) == 32) {
            n2 = 2 + n3;
            int[] nArray = new int[]{n2};
            this.decode(data, nArray, data.length);
            n2 = nArray[0];
        }
    }

    public int getCount() {
        if (this.c == null) {
            return 0;
        }
        return this.c.size();
    }

    public byte getTag() {
        return this.a;
    }

    public int getLength() {
        if (this.b != null) {
            return this.b.length;
        }
        return 0;
    }

    public byte[] getValue() {
        if (this.b == null) {
            this.getBytes();
        }
        return (byte[])this.b.clone();
    }

    public void setValue(byte[] value) {
        if (value != null) {
            this.b = (byte[])value.clone();
        }
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        boolean bl2;
        boolean bl3 = bl2 = byArray.length == byArray2.length;
        if (bl2) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                return false;
            }
        }
        return bl2;
    }

    public boolean equals(byte[] asn1) {
        return this.a(this.getBytes(), asn1);
    }

    public boolean compareValue(byte[] value) {
        return this.a(this.b, value);
    }

    public ASN1 add(ASN1 asn1) {
        if (asn1 != null) {
            if (this.c == null) {
                this.c = new ArrayList();
            }
            this.c.addItem(asn1);
        }
        return asn1;
    }

    public byte[] getBytes() {
        byte[] byArray;
        int n2;
        byte[] byArray2 = null;
        if (this.getCount() > 0) {
            byte[] byArray3;
            int n3 = 0;
            ArrayList arrayList = new ArrayList();
            for (ASN1 aSN1 : this.c) {
                byArray3 = aSN1.getBytes();
                arrayList.addItem(byArray3);
                n3 += byArray3.length;
            }
            byArray2 = new byte[n3];
            n2 = 0;
            for (int i2 = 0; i2 < this.c.size(); ++i2) {
                byArray3 = (byte[])arrayList.get_Item(i2);
                Buffer.blockCopy(Array.boxing(byArray3), 0, Array.boxing(byArray2), n2, byArray3.length);
                n2 += byArray3.length;
            }
        } else if (this.b != null) {
            byArray2 = this.b;
        }
        int n4 = 0;
        if (byArray2 != null) {
            n2 = byArray2.length;
            if (n2 > 127) {
                if (n2 <= 255) {
                    byArray = new byte[3 + n2];
                    Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(byArray), 3, n2);
                    n4 = 129;
                    byArray[2] = (byte)n2;
                } else if (n2 <= 65535) {
                    byArray = new byte[4 + n2];
                    Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(byArray), 4, n2);
                    n4 = 130;
                    byArray[2] = (byte)(n2 >> 8);
                    byArray[3] = (byte)n2;
                } else if (n2 <= 0xFFFFFF) {
                    byArray = new byte[5 + n2];
                    Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(byArray), 5, n2);
                    n4 = 131;
                    byArray[2] = (byte)(n2 >> 16);
                    byArray[3] = (byte)(n2 >> 8);
                    byArray[4] = (byte)n2;
                } else {
                    byArray = new byte[6 + n2];
                    Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(byArray), 6, n2);
                    n4 = 132;
                    byArray[2] = (byte)(n2 >> 24);
                    byArray[3] = (byte)(n2 >> 16);
                    byArray[4] = (byte)(n2 >> 8);
                    byArray[5] = (byte)n2;
                }
            } else {
                byArray = new byte[2 + n2];
                Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(byArray), 2, n2);
                n4 = n2;
            }
            if (this.b == null) {
                this.b = byArray2;
            }
        } else {
            byArray = new byte[]{this.a, (byte)n4};
        }
        return byArray;
    }

    protected void decode(byte[] asn1, int[] anPos, int anLength) {
        byte by2 = 0;
        int n2 = 0;
        byte[] byArray = null;
        while (anPos[0] < anLength - 1) {
            byte[] byArray2 = new byte[]{by2};
            int[] nArray = new int[]{n2};
            byte[][] byArrayArray = new byte[][]{byArray};
            this.decodeTLV(asn1, anPos, byArray2, nArray, byArrayArray);
            by2 = byArray2[0];
            n2 = nArray[0];
            byArray = byArrayArray[0];
            if (by2 == 0) continue;
            ASN1 aSN1 = this.add(new ASN1(by2, byArray));
            if ((by2 & 0xFF & 0x20) == 32) {
                int n3 = anPos[0];
                int[] nArray2 = new int[]{n3};
                aSN1.decode(asn1, nArray2, n3 + n2);
                n3 = nArray2[0];
            }
            anPos[0] = anPos[0] + n2;
        }
    }

    protected void decodeTLV(byte[] asn1, int[] pos, byte[] tag, int[] length, byte[][] content) {
        int n2 = pos[0];
        pos[0] = n2 + 1;
        tag[0] = asn1[n2];
        int n3 = pos[0];
        pos[0] = n3 + 1;
        length[0] = asn1[n3] & 0xFF;
        if ((length[0] & 0x80) == 128) {
            int n4 = length[0] & 0x7F;
            length[0] = 0;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = pos[0];
                pos[0] = n5 + 1;
                length[0] = length[0] * 256 + (asn1[n5] & 0xFF);
            }
        }
        content[0] = new byte[length[0]];
        Buffer.blockCopy(Array.boxing(asn1), pos[0], Array.boxing(content[0]), 0, length[0]);
    }

    public ASN1 get_Item(int index) {
        try {
            if (this.c == null || index >= this.c.size()) {
                return null;
            }
            return (ASN1)this.c.get_Item(index);
        }
        catch (ArgumentException argumentException) {
            return null;
        }
    }

    public ASN1 element(int index, byte anTag) {
        try {
            if (this.c == null || index >= this.c.size()) {
                return null;
            }
            ASN1 aSN1 = (ASN1)this.c.get_Item(index);
            if (aSN1.getTag() == anTag) {
                return aSN1;
            }
            return null;
        }
        catch (ArgumentException argumentException) {
            return null;
        }
    }

    public String toString() {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder.appendFormat(msStringBuilder2, "Tag: {0} {1}", ByteExtensions.toString(this.a, "X2"), Environment.NewLine);
        msStringBuilder.appendFormat(msStringBuilder2, "Length: {0} {1}", this.getValue().length, Environment.NewLine);
        msStringBuilder2.append("Value: ");
        msStringBuilder2.append(Environment.NewLine);
        for (int i2 = 0; i2 < this.getValue().length; ++i2) {
            msStringBuilder.appendFormat(msStringBuilder2, "{0} ", ByteExtensions.toString(this.getValue()[i2], "X2"));
            if ((i2 + 1) % 16 != 0) continue;
            msStringBuilder.appendFormat(msStringBuilder2, Environment.NewLine, new Object[0]);
        }
        return msStringBuilder2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(String filename) {
        if (filename == null) {
            throw new ArgumentNullException("filename");
        }
        FileStream fileStream = File.create(filename);
        try {
            byte[] byArray = this.getBytes();
            fileStream.write(byArray, 0, byArray.length);
        }
        finally {
            if (fileStream != null) {
                fileStream.close();
            }
        }
    }
}

