/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSingle;

class PngChunkOFFS
extends PngChunkSingle {
    public static final String ID = "oFFs";
    private long a;
    private long b;
    private int c;

    public PngChunkOFFS(ImageInfo info) {
        super(ID, info);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(9, true);
        PngHelperInternal.writeInt4tobytes((int)this.a, chunkRaw.data, 0);
        PngHelperInternal.writeInt4tobytes((int)this.b, chunkRaw.data, 4);
        chunkRaw.data[8] = (byte)this.c;
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunk) {
        if (chunk.len != 9) {
            throw new PngjException("bad chunk length " + chunk);
        }
        this.a = PngHelperInternal.readInt4fromBytes(chunk.data, 0);
        if (this.a < 0L) {
            this.a += 0x100000000L;
        }
        this.b = PngHelperInternal.readInt4fromBytes(chunk.data, 4);
        if (this.b < 0L) {
            this.b += 0x100000000L;
        }
        this.c = PngHelperInternal.readInt1fromByte(chunk.data, 8);
    }

    @Override
    public void cloneDataFromRead(PngChunk other) {
        PngChunkOFFS pngChunkOFFS = (PngChunkOFFS)other;
        this.a = pngChunkOFFS.a;
        this.b = pngChunkOFFS.b;
        this.c = pngChunkOFFS.c;
    }

    public int getUnits() {
        return this.c;
    }

    public void setUnits(int units) {
        this.c = units;
    }

    public long getPosX() {
        return this.a;
    }

    public void setPosX(long posX) {
        this.a = posX;
    }

    public long getPosY() {
        return this.b;
    }

    public void setPosY(long posY) {
        this.b = posY;
    }
}

