/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkLoadBehaviour;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkPredicate;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSPLT;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkTextVar;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkUNKNOWN;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class ChunkHelper {
    public static final String IHDR = "IHDR";
    public static final String PLTE = "PLTE";
    public static final String IDAT = "IDAT";
    public static final String IEND = "IEND";
    public static final byte[] b_IHDR = ChunkHelper.toBytes("IHDR");
    public static final byte[] b_PLTE = ChunkHelper.toBytes("PLTE");
    public static final byte[] b_IDAT = ChunkHelper.toBytes("IDAT");
    public static final byte[] b_IEND = ChunkHelper.toBytes("IEND");
    public static final String cHRM = "cHRM";
    public static final String gAMA = "gAMA";
    public static final String iCCP = "iCCP";
    public static final String sBIT = "sBIT";
    public static final String sRGB = "sRGB";
    public static final String bKGD = "bKGD";
    public static final String hIST = "hIST";
    public static final String tRNS = "tRNS";
    public static final String pHYs = "pHYs";
    public static final String sPLT = "sPLT";
    public static final String tIME = "tIME";
    public static final String iTXt = "iTXt";
    public static final String tEXt = "tEXt";
    public static final String zTXt = "zTXt";

    public static byte[] toBytes(String x2) {
        return PngHelperInternal.Latin1.getBytes(x2);
    }

    public static String toString(byte[] x2) {
        return PngHelperInternal.Latin1.getString(x2);
    }

    public static String toString(byte[] x2, int offset, int len) {
        return PngHelperInternal.Latin1.getString(x2, offset, len);
    }

    public static byte[] toBytesUTF8(String x2) {
        return PngHelperInternal.UTF8.getBytes(x2);
    }

    public static String toStringUTF8(byte[] x2) {
        return PngHelperInternal.UTF8.getString(x2);
    }

    public static String toStringUTF8(byte[] x2, int offset, int len) {
        return PngHelperInternal.UTF8.getString(x2, offset, len);
    }

    public static boolean isCritical(String id2) {
        return Character.isUpperCase(id2.charAt(0));
    }

    public static boolean isPublic(String id2) {
        return Character.isUpperCase(id2.charAt(1));
    }

    public static boolean isSafeToCopy(String id2) {
        return !Character.isUpperCase(id2.charAt(3));
    }

    public static boolean isUnknown(PngChunk c2) {
        return c2 instanceof PngChunkUNKNOWN;
    }

    public static int posNullByte(byte[] b2) {
        for (int i2 = 0; i2 < b2.length; ++i2) {
            if (b2[i2] != 0) continue;
            return i2;
        }
        return -1;
    }

    public static boolean shouldLoad(String id2, ChunkLoadBehaviour behav) {
        if (ChunkHelper.isCritical(id2)) {
            return true;
        }
        boolean bl2 = PngChunk.isKnown(id2);
        switch (behav) {
            case LOAD_CHUNK_ALWAYS: {
                return true;
            }
            case LOAD_CHUNK_IF_SAFE: {
                return bl2 || ChunkHelper.isSafeToCopy(id2);
            }
            case LOAD_CHUNK_KNOWN: {
                return bl2;
            }
            case LOAD_CHUNK_NEVER: {
                return false;
            }
        }
        return false;
    }

    public static final byte[] compressBytes(byte[] ori, boolean compress) {
        return ChunkHelper.compressBytes(ori, 0, ori.length, compress);
    }

    public static byte[] compressBytes(byte[] ori, int offset, int len, boolean compress) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ori, offset, len);
            InputStream inputStream = compress ? byteArrayInputStream : new InflaterInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = compress ? new DeflaterOutputStream(byteArrayOutputStream) : byteArrayOutputStream;
            ChunkHelper.a(inputStream, outputStream);
            inputStream.close();
            outputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new PngjException(exception);
        }
    }

    private static void a(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static boolean maskMatch(int v2, int mask) {
        return (v2 & mask) != 0;
    }

    public static List<PngChunk> filterList(List<PngChunk> target, ChunkPredicate predicateKeep) {
        ArrayList<PngChunk> arrayList = new ArrayList<PngChunk>();
        for (PngChunk pngChunk : target) {
            if (!predicateKeep.match(pngChunk)) continue;
            arrayList.add(pngChunk);
        }
        return arrayList;
    }

    public static int trimList(List<PngChunk> target, ChunkPredicate predicateRemove) {
        Iterator<PngChunk> iterator = target.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            PngChunk pngChunk = iterator.next();
            if (!predicateRemove.match(pngChunk)) continue;
            iterator.remove();
            ++n2;
        }
        return n2;
    }

    public static final boolean equivalent(PngChunk c1, PngChunk c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null || !c1.id.equals(c2.id)) {
            return false;
        }
        if (c1.getClass() != c2.getClass()) {
            return false;
        }
        if (!c2.allowsMultiple()) {
            return true;
        }
        if (c1 instanceof PngChunkTextVar) {
            return ((PngChunkTextVar)c1).getKey().equals(((PngChunkTextVar)c2).getKey());
        }
        if (c1 instanceof PngChunkSPLT) {
            return ((PngChunkSPLT)c1).getPalName().equals(((PngChunkSPLT)c2).getPalName());
        }
        return false;
    }

    public static boolean isText(PngChunk c2) {
        return c2 instanceof PngChunkTextVar;
    }
}

