/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc;

import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.StringExtensions;

class IccUtil {
    public static final float VerySmallNum = 1.0E-7f;

    IccUtil() {
    }

    public static boolean isUnity(float x2) {
        return x2 > 0.9999999f && x2 < 1.0000001f;
    }

    public static float negClip(float x2) {
        return x2 < 0.0f ? 0.0f : x2;
    }

    public static float unitClip(float x2) {
        if (x2 < 0.0f) {
            return 0.0f;
        }
        if (x2 > 1.0f) {
            return 1.0f;
        }
        return x2;
    }

    public static void unitClip(float[] pixel) {
        for (int i2 = 0; i2 < 3; ++i2) {
            pixel[i2] = IccUtil.unitClip(pixel[i2]);
        }
    }

    public static boolean isCompatSpace(long x2, long y2) {
        return x2 == y2 || IccUtil.isSpacePCS(x2) && IccUtil.isSpacePCS(y2) || IccUtil.isSpaceCMYK(x2) && IccUtil.isSpaceCMYK(y2);
    }

    public static boolean isSpacePCS(long x2) {
        return x2 == 1482250784L || x2 == 1281450528L;
    }

    public static boolean isSpaceCMYK(long x2) {
        return x2 == 1129142603L || x2 == 876825682L;
    }

    public static byte getDimension(int colorSpace) {
        switch (colorSpace) {
            case 1196573017: {
                return 1;
            }
            case 1281450528: 
            case 1380401696: 
            case 1482250784: {
                return 3;
            }
            case 1129142603: {
                return 4;
            }
        }
        throw new NotSupportedException(StringExtensions.format("Not supported ColorSpace: {0}", colorSpace));
    }

    public static boolean matrixInvert3x3(float[] m2) {
        float f2 = m2[4] * m2[8];
        float f3 = m2[7] * m2[5];
        float f4 = m2[3] * m2[8];
        float f5 = m2[6] * m2[5];
        float f6 = m2[3] * m2[7];
        float f7 = m2[6] * m2[4];
        float f8 = m2[0] * (f2 - f3) - m2[1] * (f4 - f5) + m2[2] * (f6 - f7);
        if (f8 == 0.0f) {
            return false;
        }
        float[] fArray = new float[]{f2 - f3, -(f4 - f5), f6 - f7, -(m2[1] * m2[8] - m2[7] * m2[2]), m2[0] * m2[8] - m2[6] * m2[2], -(m2[0] * m2[7] - m2[6] * m2[1]), m2[1] * m2[5] - m2[4] * m2[2], -(m2[0] * m2[5] - m2[3] * m2[2]), m2[0] * m2[4] - m2[3] * m2[1]};
        m2[0] = fArray[0] / f8;
        m2[1] = fArray[3] / f8;
        m2[2] = fArray[6] / f8;
        m2[3] = fArray[1] / f8;
        m2[4] = fArray[4] / f8;
        m2[5] = fArray[7] / f8;
        m2[6] = fArray[2] / f8;
        m2[7] = fArray[5] / f8;
        m2[8] = fArray[8] / f8;
        return true;
    }

    public static String convert_Rename_Namesake(int sig) {
        switch (sig) {
            case 1667789421: {
                return "ChromaticityType";
            }
            case 1668051567: {
                return "ColorantOrderType";
            }
            case 1668051572: {
                return "ColorantTableType";
            }
            case 1668441193: {
                return "CrdInfoType";
            }
            case 1668641398: {
                return "CurveType";
            }
            case 1684108385: {
                return "DataType";
            }
            case 1684628340: {
                return "DictType";
            }
            case 1685350765: {
                return "DateTimeType";
            }
            case 1684371059: {
                return "DeviceSettingsType";
            }
            case 1835430962: {
                return "Lut16Type";
            }
            case 1835430961: {
                return "Lut8Type";
            }
            case 1832993312: {
                return "LutAtoBType";
            }
            case 1833058592: {
                return "LutBtoAType";
            }
            case 1835360627: {
                return "MeasurementType";
            }
            case 1835824483: {
                return "MultiLocalizedUnicodeType";
            }
            case 1836082548: {
                return "MultiProcessElementType";
            }
            case 1852009522: {
                return "NamedColor2Type";
            }
            case 1885434465: {
                return "ParametricCurveType";
            }
            case 1886610801: {
                return "ProfileSequenceDescType";
            }
            case 1886611812: {
                return "ProfileSequceIdType";
            }
            case 1919120178: {
                return "ResponseCurveSet16Type";
            }
            case 1936077618: {
                return "S15Fixed16ArrayType";
            }
            case 1935897198: {
                return "ScreeningType";
            }
            case 1936287520: {
                return "SignatureType";
            }
            case 1952807028: {
                return "TextType";
            }
            case 1684370275: {
                return "TextDescriptionType";
            }
            case 1969632050: {
                return "U16Fixed16ArrayType";
            }
            case 1650877472: {
                return "UcrBgType";
            }
            case 1969828150: {
                return "UInt16ArrayType";
            }
            case 1969828658: {
                return "UInt32ArrayType";
            }
            case 1969829428: {
                return "UInt64ArrayType";
            }
            case 1969827896: {
                return "UInt8ArrayType";
            }
            case 1986618743: {
                return "ViewingConditionsType";
            }
            case 1482250784: {
                return "XyzType (XyzArrayType)";
            }
        }
        throw new NotSupportedException("Invalid TagTypeSignature");
    }

    public static String convert(int sig) {
        switch (sig) {
            case 1935896178: {
                return "InputClass";
            }
            case 1835955314: {
                return "DisplayClass";
            }
            case 1886549106: {
                return "OutputClass";
            }
            case 1818848875: {
                return "LinkClass";
            }
            case 1633842036: {
                return "AbstractClass";
            }
            case 1936744803: {
                return "ColorSpaceClass";
            }
            case 1852662636: {
                return "NamedColorClass";
            }
        }
        throw new NotSupportedException("Invalid ProfileClassSignature");
    }
}

