/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc;

import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccCurve;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccInvalidProfileException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccProfileReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccUtil;

class IccTagCurve
extends IccCurve {
    @Override
    public void read(IccProfileReader reader) {
        this._sig = (int)(reader.read32() & 0xFFFFFFFFL);
        this.verifyTagSignature();
        this._reserved = reader.read32();
        long l2 = reader.read32();
        this._data = reader.read16fArray((int)(l2 & 0xFFFFFFFFL));
    }

    @Override
    protected void verifyTagSignature() {
        if (this._sig != 1668641398) {
            throw new IccInvalidProfileException();
        }
    }

    @Override
    public boolean isIdentity() {
        if (this.getData().length == 0) {
            return true;
        }
        if (this.getData().length == 1) {
            return IccUtil.isUnity(this._data[0] * 65535.0f / 256.0f);
        }
        int n2 = this._data.length - 1;
        for (int i2 = 0; i2 < this._data.length; ++i2) {
            if (!(msMath.abs(this._data[i2] - (float)i2 / (float)n2) > 1.0E-7f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public float apply(float x2) {
        if ((double)x2 < 0.0) {
            x2 = 0.0f;
        }
        if ((double)x2 > 1.0) {
            x2 = 1.0f;
        }
        if (this._data.length == 0) {
            return x2;
        }
        if (this._data.length == 1) {
            return (float)msMath.pow(x2, (float)((double)this._data[0] * 65535.0 / 256.0));
        }
        int n2 = this._data.length - 1;
        int n3 = (int)(x2 * (float)n2);
        if (n3 != n2) {
            float f2 = this._data[n3];
            float f3 = x2 * (float)n2 - (float)n3;
            float f4 = f2 + (this._data[n3 + 1] - f2) * f3;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            return f4;
        }
        return this._data[n3];
    }
}

