/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc;

import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccUtil;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccXform;

class IccPcs {
    private static float[] a = new float[]{0.9642f, 1.0f, 0.8249f};

    IccPcs() {
    }

    public static void check(float[] pixel, IccXform xform1, IccXform xform2) {
        int n2 = (int)xform2.getSrcSpace();
        int n3 = xform1 != null ? (int)xform1.getDstSpace() : 0x3F3F3F3F;
        boolean bl2 = xform2.getLegacyPcs();
        boolean bl3 = xform1 != null ? xform1.getLegacyPcs() : false;
        boolean bl4 = true;
        block0 : switch (n2) {
            case 1482250784: {
                if (n3 != 1281450528) break;
                if (bl3) {
                    IccPcs.lab2ToXyz(pixel, bl4);
                    break;
                }
                IccPcs.labToXyz(pixel, bl4);
                break;
            }
            case 1281450528: {
                switch (n3) {
                    case 1482250784: {
                        if (bl2) {
                            IccPcs.xyzToLab2(pixel, bl4);
                            break block0;
                        }
                        IccPcs.xyzToLab(pixel, bl4);
                        break block0;
                    }
                    case 1281450528: {
                        if (bl3 && !bl2) {
                            IccPcs.lab2ToLab(pixel, bl4);
                            break block0;
                        }
                        if (bl3 || !bl2) break block0;
                        IccPcs.labToLab2(pixel, bl4);
                        break block0;
                    }
                }
                if (!bl2) break;
                IccPcs.labToLab2(pixel, bl4);
            }
        }
    }

    public static void checkLast(float[] pixel, IccXform xform) {
        if (xform.getDstSpace() == 1281450528L && xform.getLegacyPcs()) {
            IccPcs.lab2ToLab(pixel, true);
        }
    }

    public static void labToXyz(float[] pixel, boolean clip) {
        IccPcs.labFromPcs(pixel);
        IccPcs.labtoXYZ(pixel);
        IccPcs.xyzToPcs(pixel);
        if (clip) {
            IccUtil.unitClip(pixel);
        }
    }

    public static void xyzToLab(float[] pixel, boolean clip) {
        if (clip) {
            IccUtil.unitClip(pixel);
        }
        IccPcs.xyzFromPcs(pixel);
        IccPcs.xYZtoLab(pixel);
        IccPcs.labToPcs(pixel);
        if (clip) {
            IccUtil.unitClip(pixel);
        }
    }

    public static void lab2ToXyz(float[] pixel, boolean clip) {
        IccPcs.lab2ToLab(pixel, clip);
        IccPcs.labToXyz(pixel, clip);
    }

    public static void xyzToLab2(float[] pixel, boolean clip) {
        IccPcs.xyzToLab(pixel, clip);
        IccPcs.labToLab2(pixel, clip);
    }

    public static void lab2ToLab(float[] pixel, boolean clip) {
        pixel[0] = pixel[0] * 65535.0f / 65280.0f;
        pixel[1] = pixel[1] * 65535.0f / 65280.0f;
        pixel[2] = pixel[2] * 65535.0f / 65280.0f;
        if (clip) {
            IccUtil.unitClip(pixel);
        }
    }

    public static void labToLab2(float[] pixel, boolean clip) {
        pixel[0] = pixel[0] * 65280.0f / 65535.0f;
        pixel[1] = pixel[1] * 65280.0f / 65535.0f;
        pixel[2] = pixel[2] * 65280.0f / 65535.0f;
    }

    public static void labToPcs(float[] pixel) {
        pixel[0] = pixel[0] / 100.0f;
        pixel[1] = (pixel[1] + 128.0f) / 255.0f;
        pixel[2] = (pixel[2] + 128.0f) / 255.0f;
    }

    public static void labFromPcs(float[] pixel) {
        pixel[0] = pixel[0] * 100.0f;
        pixel[1] = pixel[1] * 255.0f - 128.0f;
        pixel[2] = pixel[2] * 255.0f - 128.0f;
    }

    public static float xYZScale(float x2) {
        return x2 * 32768.0f / 65535.0f;
    }

    public static float xYZDescale(float x2) {
        return x2 * 65535.0f / 32768.0f;
    }

    public static void xyzToPcs(float[] pixel) {
        for (int i2 = 0; i2 < 3; ++i2) {
            pixel[i2] = IccPcs.xYZScale(pixel[i2]);
        }
    }

    public static void xyzFromPcs(float[] pixel) {
        for (int i2 = 0; i2 < 3; ++i2) {
            pixel[i2] = IccPcs.xYZDescale(pixel[i2]);
        }
    }

    public static void labtoXYZ(float[] pixel) {
        float f2 = (pixel[0] + 16.0f) / 116.0f;
        pixel[0] = IccPcs.b(pixel[1] / 500.0f + f2) * a[0];
        pixel[1] = IccPcs.b(f2) * a[1];
        pixel[2] = IccPcs.b(f2 - pixel[2] / 200.0f) * a[2];
    }

    public static void xYZtoLab(float[] pixel) {
        float f2 = IccPcs.a(pixel[0] / a[0]);
        float f3 = IccPcs.a(pixel[1] / a[1]);
        float f4 = IccPcs.a(pixel[2] / a[2]);
        pixel[0] = 116.0f * f3 - 16.0f;
        pixel[1] = 500.0f * (f2 - f3);
        pixel[2] = 200.0f * (f3 - f4);
    }

    private static float a(float f2) {
        if ((double)f2 > 0.008856) {
            return (float)msMath.pow(f2, 0.3333333333333333);
        }
        return (float)(7.787037037037037 * (double)f2 + 0.13793103448275862);
    }

    private static float b(float f2) {
        if ((double)f2 > 0.20689303448275861) {
            return f2 * f2 * f2;
        }
        if ((double)f2 > 0.13793103448275862) {
            return (float)(((double)f2 - 0.13793103448275862) / 7.787037037037037);
        }
        return 0.0f;
    }
}

