/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement;

import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ByteConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;

public final class TiffBigEndianStream
extends TiffStream {
    public TiffBigEndianStream(Stream stream) {
        super(stream);
    }

    public TiffBigEndianStream(Stream stream, boolean disposeStream) {
        super(stream, disposeStream);
    }

    @Override
    protected double[] processReadDataDouble(byte[] data) {
        double[] dArray = new double[data.length / 8];
        for (int i2 = 0; i2 < data.length / 8; ++i2) {
            dArray[i2] = ByteConverter.fromBigEndianToDouble(data, i2 * 8);
        }
        return dArray;
    }

    @Override
    protected float[] processReadDataFloat(byte[] data) {
        float[] fArray = new float[data.length / 4];
        for (int i2 = 0; i2 < data.length / 4; ++i2) {
            fArray[i2] = ByteConverter.fromBigEndianToSingle(data, i2 * 4);
        }
        return fArray;
    }

    @Override
    protected int[] processReadDataLong(byte[] data) {
        int[] nArray = new int[data.length / 4];
        for (int i2 = 0; i2 < data.length / 4; ++i2) {
            nArray[i2] = ByteConverter.fromBigEndianToInt32(data, i2 * 4);
        }
        return nArray;
    }

    @Override
    protected short[] processReadDataShort(byte[] data) {
        short[] sArray = new short[data.length / 2];
        for (int i2 = 0; i2 < data.length / 2; ++i2) {
            sArray[i2] = ByteConverter.fromBigEndianToInt16(data, i2 * 2);
        }
        return sArray;
    }

    @Override
    protected long[] processReadDataULong(byte[] data) {
        long[] lArray = new long[data.length / 4];
        for (int i2 = 0; i2 < data.length / 4; ++i2) {
            lArray[i2] = (long)ByteConverter.fromBigEndianToInt32(data, i2 * 4) & 0xFFFFFFFFL;
        }
        return lArray;
    }

    @Override
    protected int[] processReadDataUShort(byte[] data) {
        int[] nArray = new int[data.length / 2];
        for (int i2 = 0; i2 < data.length / 2; ++i2) {
            nArray[i2] = ByteConverter.fromBigEndianToInt16(data, i2 * 2) & 0xFFFF;
        }
        return nArray;
    }

    @Override
    protected void processWriteDataLong(int[] data, byte[] dest) {
        for (int i2 = 0; i2 < data.length; ++i2) {
            ByteConverter.writeBigEndianBytesInt32(data[i2], dest, i2 * 4);
        }
    }

    @Override
    protected void processWriteDataULong(long[] data, byte[] dest) {
        for (int i2 = 0; i2 < data.length; ++i2) {
            ByteConverter.writeBigEndianBytesUInt32(data[i2], dest, i2 * 4);
        }
    }

    @Override
    protected void processWriteDataShort(short[] data, byte[] dest) {
        for (int i2 = 0; i2 < data.length; ++i2) {
            ByteConverter.writeBigEndianBytesInt16(data[i2], dest, i2 * 2);
        }
    }

    @Override
    protected void processWriteDataUShort(int[] data, byte[] dest) {
        for (int i2 = 0; i2 < data.length; ++i2) {
            ByteConverter.writeBigEndianBytesUInt16(data[i2], dest, i2 * 2);
        }
    }

    @Override
    protected void processWriteDataFloat(float[] data, byte[] dest) {
        for (int i2 = 0; i2 < data.length; ++i2) {
            ByteConverter.writeBigEndianBytesSingle(data[i2], dest, i2 * 4);
        }
    }

    @Override
    protected void processWriteDataDouble(double[] data, byte[] dest) {
        for (int i2 = 0; i2 < data.length; ++i2) {
            ByteConverter.writeBigEndianBytesDouble(data[i2], dest, i2 * 8);
        }
    }
}

