/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers;

import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors.DeflateCompressStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers.TiffByteConverterWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IAdvancedBufferProcessor;

public class TiffDeflateWriter
extends TiffByteConverterWriter {
    private final boolean a;
    private BufferProcessor b;
    private int c;
    private boolean d;
    private int e;
    private int f;
    private TiffByteConverterWriter.ColorConverter g;
    private int h = 6;

    public TiffDeflateWriter(TiffOptions options, int width, int height, boolean withRfc1950Header) {
        super(options, width, height);
        this.a = withRfc1950Header;
    }

    public int getBitsPerSample() {
        return this.c;
    }

    public void setBitsPerSample(int value) {
        this.c = value;
    }

    public int getRowSize() {
        return this.e;
    }

    public void setRowSize(int value) {
        this.e = value;
    }

    public int getSamplesPerPixel() {
        return this.f;
    }

    public void setSamplesPerPixel(int value) {
        this.f = value;
    }

    @Override
    public void encode(int[] colorData, Rectangle area, IAdvancedBufferProcessor partialDataWriter) {
        if (this.g == null) {
            int n2 = this.getRowsPerStrip();
            this.g = TiffByteConverterWriter.getColorConverter(this.getOptions(), this.getWidth(), this.getHeight(), n2);
            DeflateCompressStreamWrapper deflateCompressStreamWrapper = new DeflateCompressStreamWrapper(n2, partialDataWriter, this.h, this.a);
            deflateCompressStreamWrapper.startEncoding();
            this.b = new BufferProcessor(deflateCompressStreamWrapper, this.getHeight(), this.getRowsPerStrip());
        }
        this.g.convert(colorData, this.b);
    }

    private static class DeflateCompressStreamWrapper {
        private final int a;
        private final IAdvancedBufferProcessor b;
        private final int c;
        private final boolean d;
        private MemoryStream e;
        private DeflateCompressStream f;

        public DeflateCompressStreamWrapper(int rowsPerStrip, IAdvancedBufferProcessor advancedBufferProcessor, int compressionLevel, boolean withRfc1950Header) {
            this.a = rowsPerStrip;
            this.b = advancedBufferProcessor;
            this.c = compressionLevel;
            this.d = withRfc1950Header;
        }

        public void startEncoding() {
            this.e = new MemoryStream();
            this.f = new DeflateCompressStream(this.e, this.c, this.d, false);
        }

        public void finishEncoding(int rowsCount) {
            this.f.flush();
            this.f.dispose();
            byte[] byArray = this.e.toArray();
            this.b.processBuffer(byArray, byArray.length);
            this.b.finishRows(rowsCount);
        }

        public void processBuffer(byte[] buffer, int bufferLength) {
            this.f.write(buffer, 0, bufferLength);
        }
    }

    private static class BufferProcessor
    implements IAdvancedBufferProcessor {
        private final DeflateCompressStreamWrapper a;
        private final int b;
        private int c;
        private int d;

        public BufferProcessor(DeflateCompressStreamWrapper encoder, int height, int rowsPerStrip) {
            this.b = rowsPerStrip;
            this.a = encoder;
            this.c = height;
            this.d = rowsPerStrip;
        }

        @Override
        public void finishRow() {
            this.finishRows(this.b);
        }

        @Override
        public void finishRows(int rowsCount) {
            this.d -= rowsCount;
            if (this.d == 0) {
                int n2 = msMath.min(this.b, this.c);
                this.a.finishEncoding(n2);
                this.c -= n2;
                if (this.c > 0) {
                    this.d = msMath.min(this.b, this.c);
                    this.a.startEncoding();
                }
            }
        }

        @Override
        public void processBuffer(byte[] buffer, int bufferLength) {
            this.a.processBuffer(buffer, bufferLength);
        }
    }
}

