/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.readers;

import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.TiffUtils;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.EntropyTable;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.QTable;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.encodingcontrollers.JpegDecodingController;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodecDataReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageloadoptions.JpegLoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.loaders.JpegLoader;
import com.aspose.html.internal.ms.lang.Operators;

public class TiffJpegReader
extends TiffCodecDataReader {
    private byte[] a;

    public TiffJpegReader(TiffOptions options, int width, int height) {
        super(options, width, height);
    }

    public byte[] getTablesData() {
        return this.a;
    }

    public void setTablesData(byte[] value) {
        this.a = value;
    }

    @Override
    public void decode(TiffStream stream, Rectangle rectangle, IPartialArgb32PixelLoader partialLoader) {
        PartialLoader partialLoader2 = new PartialLoader(this, stream, partialLoader, this.a);
        PartialProcessor.process(rectangle.Clone(), partialLoader2);
    }

    private static class PartialLoader
    implements IPartialProcessor {
        private final IPartialArgb32PixelLoader a;
        private final TiffStream b;
        private final long[] c;
        private final byte[] d;
        private final int e;

        public PartialLoader(TiffJpegReader tiffJpegReader, TiffStream stream, IPartialArgb32PixelLoader partialLoader, byte[] data) {
            this.b = stream;
            this.a = partialLoader;
            this.d = data;
            this.c = tiffJpegReader.getOptions().getStripOffsets();
            this.e = tiffJpegReader.getOptions().getPhotometric();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(Rectangle areaToProcess) {
            long l2 = this.b.getPosition();
            int n2 = 0;
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                QTable[] qTableArray;
                EntropyTable[] entropyTableArray;
                this.b.setPosition(Operators.castToInt64(this.c[i2], 10));
                JpegLoadOptions jpegLoadOptions = new JpegLoadOptions();
                jpegLoadOptions.setColorMode(TiffUtils.tiffPhotometricToJpegColorSpace(this.e));
                if (this.d != null) {
                    entropyTableArray = JpegDecodingController.readEntropyTables(new JpegStream(new MemoryStream(this.d)));
                    qTableArray = JpegDecodingController.readQuantTables(new JpegStream(new MemoryStream(this.d)));
                    jpegLoadOptions.setEntropyTables(entropyTableArray);
                    jpegLoadOptions.setQuantTables(qTableArray);
                }
                entropyTableArray = new StreamContainer(this.b.getStream());
                try {
                    qTableArray = JpegLoader.getJpegInfo((StreamContainer)entropyTableArray, jpegLoadOptions);
                    Rectangle rectangle = new Rectangle(0, n2, qTableArray.getWidth(), qTableArray.getHeight());
                    JpegStripShifter jpegStripShifter = new JpegStripShifter(new Point(0, n2), this.a);
                    if (rectangle.intersectsWith(areaToProcess.Clone())) {
                        Rectangle rectangle2 = Rectangle.intersect(rectangle.Clone(), areaToProcess.Clone()).Clone();
                        Rectangle rectangle3 = new Rectangle(rectangle2.getX(), rectangle2.getLocation().getY() - n2, rectangle2.getWidth(), rectangle2.getHeight());
                        qTableArray.getJpegDataReader().loadPartialArgb32Pixels(rectangle3.Clone(), jpegStripShifter);
                    }
                    n2 += qTableArray.getHeight();
                    continue;
                }
                finally {
                    if (entropyTableArray != null) {
                        entropyTableArray.dispose();
                    }
                }
            }
            this.b.setPosition(l2);
        }

        private static class JpegStripShifter
        implements IPartialArgb32PixelLoader {
            private final Point a = new Point();
            private final IPartialArgb32PixelLoader b;

            public JpegStripShifter(Point rectangleOffset, IPartialArgb32PixelLoader pixelLoader) {
                rectangleOffset.CloneTo(this.a);
                this.b = pixelLoader;
            }

            @Override
            public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
                pixelsRectangle.offset(this.a.Clone());
                start.offset(this.a.Clone());
                end.offset(this.a.Clone());
                this.b.process(pixelsRectangle.Clone(), pixels, start.Clone(), end.Clone());
            }
        }
    }
}

