/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff;

import com.aspose.html.internal.ms.System.DoubleExtensions;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.lang.Operators;

public class TiffSRational {
    public static final double EPSILON = 1.0E-6;
    private int a;
    private int b;

    public TiffSRational() {
    }

    public TiffSRational(int value) {
        this.b = value;
        this.a = 1;
    }

    public TiffSRational(int nominator, int denominator) {
        this.b = nominator;
        this.a = denominator;
    }

    public int getDenominator() {
        return this.a;
    }

    public int getNominator() {
        return this.b;
    }

    public float getValue() {
        return Operators.castToFloat(this.b, 9) / (float)this.a;
    }

    public double getValueD() {
        return Operators.castToDouble(this.b, 9) / (double)this.a;
    }

    public static TiffSRational approximateFraction(double value, double epsilon) {
        int n2 = 1;
        int n3 = 1;
        double d2 = n2 / n3;
        while (msMath.abs(d2 - value) > epsilon) {
            n2 = d2 < value ? ++n2 : Operators.castToInt32(msMath.round(value * (double)(++n3)), 14);
            d2 = (double)n2 / Operators.castToDouble(n3, 9);
        }
        return new TiffSRational(n2, n3);
    }

    public static TiffSRational approximateFraction(double value) {
        return TiffSRational.approximateFraction(value, 1.0E-6);
    }

    public static TiffSRational approximateFraction(float value, double epsilon) {
        int n2 = 1;
        int n3 = 1;
        double d2 = n2 / n3;
        while (msMath.abs(d2 - (double)value) > epsilon) {
            n2 = d2 < (double)value ? ++n2 : Operators.castToInt32(msMath.round(value * (float)(++n3)), 14);
            d2 = (double)n2 / Operators.castToDouble(n3, 9);
        }
        return new TiffSRational(n2, n3);
    }

    public static TiffSRational approximateFraction(float value) {
        return TiffSRational.approximateFraction(value, 1.0E-6);
    }

    public String toString() {
        return StringExtensions.concat(DoubleExtensions.toString(this.getValueD(), "F2"), " (", Int32Extensions.toString(this.b), "/", Int32Extensions.toString(this.a), Operators.boxing(Character.valueOf(')')));
    }

    public static boolean op_Equality(TiffSRational rational1, TiffSRational rational2) {
        boolean bl2 = !ObjectExtensions.referenceEquals(rational1, null) && !ObjectExtensions.referenceEquals(rational2, null) ? rational1.b == rational2.b && rational1.a == rational2.a : ObjectExtensions.referenceEquals(rational1, null) && ObjectExtensions.referenceEquals(rational2, null);
        return bl2;
    }

    public static boolean op_Inequality(TiffSRational rational1, TiffSRational rational2) {
        return !TiffSRational.op_Equality(rational1, rational2);
    }

    public boolean equals(Object obj) {
        return TiffSRational.op_Equality(this, Operators.as(obj, TiffSRational.class));
    }

    public int hashCode() {
        return this.b ^ this.a;
    }
}

