/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PartialPixelSaver;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterCachedImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImagePixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.TransparentColorRenderProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exif.ExifData;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodec;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodecDataWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffTagsSaver;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStreamFactory;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffSShortType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffShortType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IAdvancedBufferProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.internal.ms.lang.Operators;

public final class TiffFrame
extends RasterCachedImage {
    private TiffOptions a;
    private int b;
    private int c;
    private ExifData d;

    public TiffFrame(RasterImage image) {
        this(image, new TiffOptions(0));
    }

    public TiffFrame(RasterImage image, TiffOptions options) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new RasterImagePixelLoader(image), options);
    }

    public TiffFrame(TiffOptions options, int width, int height) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        this.a = options;
        this.c = width;
        this.b = height;
    }

    public TiffFrame(TiffOptions options, int width, int height, IRasterImageArgb32PixelLoader dataReader) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        this.a = options;
        this.c = width;
        this.b = height;
        if (dataReader != null) {
            this.setDataLoader(dataReader);
        }
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return this.getFrameOptions().getBitsPerPixel();
    }

    public TiffOptions getFrameOptions() {
        this.verifyNotDisposed();
        return this.a;
    }

    @Override
    public int getHeight() {
        return this.b;
    }

    @Override
    public int getWidth() {
        return this.c;
    }

    public ExifData getExifData() {
        return this.d;
    }

    public void setExifData(ExifData value) {
        this.d = value;
    }

    public static TiffFrame copyFrame(TiffFrame tiffFrame) {
        if (tiffFrame == null) {
            throw new ArgumentNullException("tiffFrame");
        }
        TiffOptions tiffOptions = new TiffOptions(tiffFrame.a);
        TiffFrame tiffFrame2 = new TiffFrame(tiffOptions, tiffFrame.c, tiffFrame.b);
        if (tiffFrame.getDataLoader() != null) {
            tiffFrame2.setDataLoader(tiffFrame.getDataLoader());
        } else {
            tiffFrame.loadPartialArgb32Pixels(tiffFrame.getBounds().Clone(), new PartialPixelSaver(tiffFrame2));
        }
        return tiffFrame2;
    }

    public static TiffFrame createFrameFrom(TiffFrame tiffFrame, TiffOptions options) {
        if (tiffFrame == null) {
            throw new ArgumentNullException("tiffFrame");
        }
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        TiffFrame tiffFrame2 = new TiffFrame(options, tiffFrame.c, tiffFrame.b);
        tiffFrame.loadPartialArgb32Pixels(tiffFrame.getBounds().Clone(), new PartialPixelSaver(tiffFrame2));
        return tiffFrame2;
    }

    public static void save(RasterImage imageToLoadPixelsFrom, TiffStream fileStream, boolean isLastFrame, TiffOptions frameOptions, ExifData exifData) {
        TiffDataType[] tiffDataTypeArray;
        TiffDataType[] tiffDataTypeArray2;
        TiffDataType[] tiffDataTypeArray3;
        frameOptions.validate();
        frameOptions.setImageWidth(Operators.castToUInt32(imageToLoadPixelsFrom.getWidth(), 9));
        frameOptions.setImageLength(Operators.castToUInt32(imageToLoadPixelsFrom.getHeight(), 9));
        if (frameOptions.getCompression() == 7) {
            frameOptions.setRowsPerStrip(Operators.castToUInt32(imageToLoadPixelsFrom.getHeight(), 9));
            tiffDataTypeArray3 = new TiffSShortType(530);
            tiffDataTypeArray3.setValues(new short[]{2, 2});
            tiffDataTypeArray2 = new TiffShortType(284);
            tiffDataTypeArray2.setValues(new int[]{1});
            frameOptions.addTag((TiffDataType)tiffDataTypeArray3);
            frameOptions.addTag((TiffDataType)tiffDataTypeArray2);
        }
        frameOptions.setStripByteCounts(new long[]{0L});
        frameOptions.setStripOffsets(new long[]{0L});
        if (!frameOptions.isTagPresent(278)) {
            frameOptions.setRowsPerStrip(0xFFFFFFFFL);
        }
        tiffDataTypeArray3 = null;
        tiffDataTypeArray2 = null;
        if (exifData != null) {
            tiffDataTypeArray3 = exifData.getExifTags();
            tiffDataTypeArray2 = exifData.getGPSTags();
        }
        TiffTagsSaver tiffTagsSaver = new TiffTagsSaver(frameOptions.getTags(), tiffDataTypeArray3, tiffDataTypeArray2);
        long l2 = fileStream.getPosition();
        long l3 = tiffTagsSaver.estimateTagsInfoSize();
        PartialSaver partialSaver = new PartialSaver(frameOptions, Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(l2, 11), 10) + Operators.castToUInt32(l3, 10), 10), fileStream, imageToLoadPixelsFrom.getWidth(), imageToLoadPixelsFrom.getHeight());
        if (imageToLoadPixelsFrom.hasTransparentColor()) {
            tiffDataTypeArray = new TransparentColorRenderProcessor(imageToLoadPixelsFrom.getTransparentColor(), imageToLoadPixelsFrom.getBackgroundColor(), partialSaver);
            imageToLoadPixelsFrom.loadPartialArgb32Pixels(imageToLoadPixelsFrom.getBounds().Clone(), (IPartialArgb32PixelLoader)tiffDataTypeArray);
        } else {
            imageToLoadPixelsFrom.loadPartialArgb32Pixels(imageToLoadPixelsFrom.getBounds().Clone(), partialSaver);
        }
        frameOptions.setStripByteCounts(partialSaver.getWriter().getStripByteCountsArray());
        frameOptions.setStripOffsets(partialSaver.getWriter().getStripOffsetsArray());
        frameOptions.setRowsPerStrip(partialSaver.getWriter().getRowsPerStrip());
        tiffDataTypeArray = new TiffDataType[]{frameOptions.getTagByType(278), frameOptions.getTagByType(279), frameOptions.getTagByType(273)};
        tiffTagsSaver.replaceTags(tiffDataTypeArray);
        long l4 = partialSaver.getWriter().getDataOffset();
        fileStream.seek(l2, 0);
        tiffTagsSaver.writeTags(fileStream, l4, isLastFrame);
    }

    @Override
    protected void releaseManagedResources() {
        this.a = null;
        super.releaseManagedResources();
    }

    @Override
    public void saveData(Stream stream) {
        this.verifyNotDisposed();
        int n2 = 18761;
        if (Operators.is(this.getContainer(), TiffImage.class)) {
            n2 = Operators.as(this.getContainer(), TiffImage.class).getByteOrder();
        }
        TiffStream tiffStream = TiffStreamFactory.getTiffStream(stream, n2);
        TiffFrame.save(this, tiffStream, true, this.a, this.d);
    }

    @Override
    protected void updateDimensions(int newWidth, int newHeight) {
        this.c = newWidth;
        this.b = newHeight;
    }

    private void a(RasterImagePixelLoader rasterImagePixelLoader, TiffOptions tiffOptions) {
        this.setDataLoader(rasterImagePixelLoader);
        this.a = tiffOptions;
        this.c = rasterImagePixelLoader.getRasterImage().getWidth();
        this.b = rasterImagePixelLoader.getRasterImage().getHeight();
        this.setPalette(rasterImagePixelLoader.getRasterImage().getPalette());
    }

    private static class PartialSaver
    implements IPartialArgb32PixelLoader {
        private final PartialWriter a;
        private final TiffCodecDataWriter b;

        public PartialSaver(TiffOptions frameOptions, long dataOffset, TiffStream fileStream, int width, int height) {
            this.b = TiffDataWriter.createCompressionObject(frameOptions, width, height);
            long l2 = frameOptions.getRowsPerStrip();
            this.a = new PartialWriter(fileStream, dataOffset, Operators.castToUInt32(this.b.getHeight(), 9), l2, this.b.getOptions().getFillOrder() == 2);
        }

        public PartialWriter getWriter() {
            return this.a;
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            try {
                this.b.encode(pixels, pixelsRectangle.Clone(), this.a);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new OutOfMemoryException("FrameworkException: Fatal error", outOfMemoryError);
            }
        }
    }

    private static class PartialWriter
    implements IAdvancedBufferProcessor {
        private final TiffStream a;
        private final long b;
        private final long[] c;
        private final long[] d;
        private final long e;
        private final boolean f;
        private long g;
        private long h;
        private long i;
        private long j;

        public PartialWriter(TiffStream fileStream, long dataOffset, long height, long rowsPerStrip, boolean isLsbFillOrder) {
            this.f = isLsbFillOrder;
            this.a = fileStream;
            this.g = dataOffset;
            if (Operators.castToUInt32(rowsPerStrip, 10) == 0L) {
                rowsPerStrip = height;
            }
            this.b = rowsPerStrip;
            long l2 = Operators.castToUInt32(Operators.castToUInt32(height, 10) / Operators.castToUInt32(rowsPerStrip, 10), 10);
            if (Operators.castToUInt32(Operators.castToUInt32(height, 10) % Operators.castToUInt32(rowsPerStrip, 10), 10) != 0L) {
                ++l2;
            }
            this.c = new long[(int)Operators.castToUInt32(l2, 10)];
            this.d = new long[(int)Operators.castToUInt32(l2, 10)];
            this.c[0] = dataOffset;
            this.e = height;
        }

        public long[] getStripOffsetsArray() {
            return this.c;
        }

        public long[] getStripByteCountsArray() {
            return this.d;
        }

        public long getRowsPerStrip() {
            return this.b;
        }

        public long getDataOffset() {
            return this.g;
        }

        @Override
        public void processBuffer(byte[] buffer, int bufferLength) {
            if (this.f) {
                TiffCodec.reverseBits(buffer, 0, bufferLength);
            }
            this.a.seek(Operators.castToInt64(this.g, 10), 0);
            this.a.write(buffer, 0, bufferLength);
            this.g = Operators.castToUInt32(Operators.castToUInt32(this.g, 10) + Operators.castToUInt32(Operators.castToUInt32(bufferLength, 9), 10), 10);
            this.j = Operators.castToUInt32(Operators.castToUInt32(this.j, 10) + Operators.castToUInt32(Operators.castToUInt32(bufferLength, 9), 10), 10);
        }

        @Override
        public void finishRow() {
            ++this.h;
            if (Operators.castToUInt32(Operators.castToUInt32(this.h, 10) % Operators.castToUInt32(this.b, 10), 10) == 0L || Operators.castToUInt32(this.h, 10) == Operators.castToUInt32(this.e, 10)) {
                this.d[(int)this.i++] = this.j;
                if (Operators.castToUInt32(this.i, 10) < (long)this.c.length) {
                    this.c[(int)this.i] = this.g;
                }
                this.j = 0L;
            }
        }

        @Override
        public void finishRows(int rowsCount) {
            this.h = Operators.castToUInt32(Operators.castToUInt32(this.h, 10) + Operators.castToUInt32(Operators.castToUInt32(rowsCount, 9), 10), 10);
            if (Operators.castToUInt32(Operators.castToUInt32(this.h, 10) % Operators.castToUInt32(this.b, 10), 10) == 0L || Operators.castToUInt32(this.h, 10) == Operators.castToUInt32(this.e, 10)) {
                this.d[(int)this.i++] = this.j;
                if (Operators.castToUInt32(this.i, 10) < (long)this.c.length) {
                    this.c[(int)this.i] = this.g;
                }
                this.j = 0L;
            }
        }
    }
}

