/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodecDataWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers.TiffCcittWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers.TiffDeflateWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers.TiffJpegWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers.TiffLzwWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers.TiffPackBitsWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers.TiffUncompressedWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffCompressions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffSShortType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffShortType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.internal.ms.lang.Operators;

class TiffDataWriter {
    TiffDataWriter() {
    }

    public static TiffCodecDataWriter createCompressionObject(TiffOptions tiffOptions, int width, int height) {
        TiffCodecDataWriter tiffCodecDataWriter;
        switch (tiffOptions.getCompression()) {
            case 1: {
                tiffCodecDataWriter = new TiffUncompressedWriter(tiffOptions, width, height);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                tiffCodecDataWriter = new TiffCcittWriter(tiffOptions, width, height);
                break;
            }
            case 5: {
                TiffLzwWriter tiffLzwWriter = new TiffLzwWriter(tiffOptions, width, height);
                tiffLzwWriter.setPredictor(tiffOptions.getPredictor());
                tiffLzwWriter.setSamplesPerPixel(Operators.castToInt32(tiffOptions.getSamplesPerPixel(), 8));
                tiffLzwWriter.setBitsPerSample(Operators.castToInt32(tiffOptions.getBitsPerSample()[0], 8));
                tiffLzwWriter.setRowSize(width * Operators.castToInt32(tiffOptions.getSamplesPerPixel(), 8));
                tiffLzwWriter.setCodeLength(8);
                tiffCodecDataWriter = tiffLzwWriter;
                break;
            }
            case 8: 
            case 32946: {
                boolean bl2 = true;
                TiffDeflateWriter tiffDeflateWriter = new TiffDeflateWriter(tiffOptions, width, height, true);
                tiffDeflateWriter.setSamplesPerPixel(tiffOptions.getSamplesPerPixel());
                tiffDeflateWriter.setBitsPerSample(tiffOptions.getBitsPerSample()[0]);
                tiffDeflateWriter.setRowSize(width * tiffOptions.getSamplesPerPixel());
                tiffCodecDataWriter = tiffDeflateWriter;
                break;
            }
            case 7: {
                tiffOptions.setRowsPerStrip(Operators.castToUInt32(height, 9));
                TiffSShortType tiffSShortType = new TiffSShortType(530);
                tiffSShortType.setValues(new short[]{2, 2});
                TiffShortType tiffShortType = new TiffShortType(284);
                tiffShortType.setValues(new int[]{1});
                tiffOptions.addTag(tiffSShortType);
                tiffOptions.addTag(tiffShortType);
                TiffJpegWriter tiffJpegWriter = new TiffJpegWriter(tiffOptions, width, height);
                tiffCodecDataWriter = tiffJpegWriter;
                break;
            }
            case 32773: {
                TiffPackBitsWriter tiffPackBitsWriter = new TiffPackBitsWriter(tiffOptions, width, height);
                tiffCodecDataWriter = tiffPackBitsWriter;
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException(StringExtensions.concat("codec not supported - Codec #", Enum.getName(TiffCompressions.class, tiffOptions.getCompression())));
            }
        }
        return tiffCodecDataWriter;
    }
}

