/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterCachedImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ResolutionSetting;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.PngImageException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.PngFileSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.PngStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.ColorBackgroundChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.FileEndChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.GrayPaletteBackgroundChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.HeaderChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.PaletteBackgroundChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.PaletteChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.PixelSizeChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.PngChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.TransparencyChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.coder.PngImageAccumulator;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.coder.PngImagePixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.coder.PngSaver;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.colorconverters.GrayscaleAlphaPngColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.colorconverters.GrayscalePngColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.colorconverters.PalettePngColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.colorconverters.PngColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.colorconverters.RGBAPngColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.colorconverters.RGBPngColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.PngOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.loaders.PngLoader;
import com.aspose.html.internal.ms.lang.Operators;

public class PngImage
extends RasterCachedImage {
    private PngFileSettings a;

    public PngImage(int width, int height) {
        this(width, height, 2);
    }

    public PngImage(int width, int height, int colorType) {
        this.a(width, height, colorType);
    }

    public PngImage(PngOptions pngOptions, int width, int height) {
        this.setPngFileSettings(new PngFileSettings(pngOptions));
        this.getPngFileSettings().setWidth(Operators.castToUInt32(width, 9));
        this.getPngFileSettings().setHeight(Operators.castToUInt32(height, 9));
        this.a(this.getPngFileSettings());
    }

    public PngImage(PngFileSettings fileSettings, IRasterImageArgb32PixelLoader loader) {
        this.setDataLoader(loader);
        this.a(fileSettings);
    }

    @Override
    public int getBitsPerPixel() {
        switch (this.a.getColorType()) {
            case 0: {
                return Operators.castToInt32(this.getPngFileSettings().getBitDepth(), 6);
            }
            case 2: {
                return Operators.castToInt32(this.getPngFileSettings().getBitDepth(), 6) * 3;
            }
            case 3: {
                return Operators.castToInt32(this.getPngFileSettings().getBitDepth(), 6);
            }
            case 4: {
                return Operators.castToInt32(this.getPngFileSettings().getBitDepth(), 6) * 2;
            }
            case 6: {
                return Operators.castToInt32(this.getPngFileSettings().getBitDepth(), 6) * 4;
            }
        }
        return Operators.castToInt32(this.getPngFileSettings().getBitDepth(), 6);
    }

    @Override
    public int getHeight() {
        return Operators.castToInt32(this.getPngFileSettings().getHeight(), 10);
    }

    @Override
    public double getHorizontalResolution() {
        if (this.getPngFileSettings().getWriteResolution()) {
            return this.getPngFileSettings().getHorizontalResolution();
        }
        return super.getHorizontalResolution();
    }

    @Override
    public void setHorizontalResolution(double value) {
        this.getPngFileSettings().setHorizontalResolution(value);
        this.getPngFileSettings().setWriteResolution(true);
    }

    @Override
    public PixelDataFormat getRawDataFormat() {
        switch (this.getPngFileSettings().getColorType()) {
            case 0: {
                return PixelDataFormat.getGrayscale();
            }
            case 2: {
                return PixelDataFormat.getRgb24BppPng();
            }
            case 3: {
                return PixelDataFormat.getRgbIndexed8Bpp();
            }
            case 4: {
                return PixelDataFormat.getGrayscaleAlpha();
            }
            case 6: {
                return PixelDataFormat.getRgba32Bpp();
            }
        }
        throw new ArgumentOutOfRangeException();
    }

    @Override
    public double getVerticalResolution() {
        return this.getPngFileSettings().getWriteResolution() ? this.getPngFileSettings().getVerticalResolution() : super.getVerticalResolution();
    }

    @Override
    public void setVerticalResolution(double value) {
        this.getPngFileSettings().setVerticalResolution(value);
        this.getPngFileSettings().setWriteResolution(true);
    }

    @Override
    public int getWidth() {
        return Operators.castToInt32(this.getPngFileSettings().getWidth(), 10);
    }

    @Override
    public boolean hasTransparentColor() {
        return this.a.getWriteTransparentColor();
    }

    @Override
    public void setTransparentColor(boolean value) {
        this.a.setWriteTransparentColor(value);
    }

    @Override
    public int getTransparentColor() {
        return this.a.getTransparentColor();
    }

    @Override
    public void setTransparentColor(int value) {
        this.a.setTransparentColor(value);
    }

    @Override
    public boolean hasBackgroundColor() {
        return this.a.hasBackgroundColor();
    }

    @Override
    public void setBackgroundColor(boolean value) {
        this.a.setBackgroundColor(value);
    }

    @Override
    public int getBackgroundColor() {
        return this.a.getBackgroundColor();
    }

    @Override
    public void setBackgroundColor(int value) {
        this.a.setBackgroundColor(value);
    }

    PngFileSettings getPngFileSettings() {
        return this.a;
    }

    public void setPngFileSettings(PngFileSettings value) {
        this.a = value;
        this.setPalette(this.a.getPalette());
    }

    public static void savePng(Stream stream, RasterImage image, PngOptions pngOptions) {
        int n2;
        PngChunk pngChunk;
        pngOptions.validate();
        PngFileSettings pngFileSettings = new PngFileSettings(pngOptions);
        pngFileSettings.setWriteTransparentColor(image.hasTransparentColor());
        if (pngFileSettings.getWriteTransparentColor()) {
            pngFileSettings.setTransparentColor(0);
        }
        pngFileSettings.setBackgroundColor(image.hasBackgroundColor());
        if (pngFileSettings.hasBackgroundColor()) {
            pngFileSettings.setBackgroundColor(image.getBackgroundColor());
        }
        pngFileSettings.setWidth(Operators.castToUInt32(image.getWidth(), 9));
        pngFileSettings.setHeight(Operators.castToUInt32(image.getHeight(), 9));
        PngStream pngStream = new PngStream(stream);
        byte[] byArray = PngLoader.getSignature();
        pngStream.write(byArray, 0, byArray.length);
        HeaderChunk headerChunk = new HeaderChunk(pngFileSettings);
        headerChunk.save(pngStream);
        if (pngFileSettings.getColorType() == 3) {
            PngImage.a(pngStream, pngFileSettings);
        }
        if (pngFileSettings.getWriteResolution()) {
            pngChunk = new PixelSizeChunk();
            double d2 = 39.3701;
            ((PixelSizeChunk)pngChunk).setPPUx(Operators.castToInt32(pngFileSettings.getHorizontalResolution() * 39.3701, 14));
            ((PixelSizeChunk)pngChunk).setPPUy(Operators.castToInt32(pngFileSettings.getVerticalResolution() * 39.3701, 14));
            ((PixelSizeChunk)pngChunk).setUnit(1);
            pngChunk.save(pngStream);
        }
        if (pngFileSettings.getWriteTransparentColor() && (pngFileSettings.getColorType() == 0 || pngFileSettings.getColorType() == 2 || pngFileSettings.getColorType() == 3)) {
            pngChunk = new TransparencyChunk();
            byte[] byArray2 = null;
            n2 = pngFileSettings.getTransparentColor();
            byte by2 = Operators.castToByte(n2 >> 16 & 0xFF, 9);
            byte by3 = Operators.castToByte(n2 >> 8 & 0xFF, 9);
            byte by4 = Operators.castToByte(n2 & 0xFF, 9);
            if (pngFileSettings.getColorType() == 0) {
                byArray2 = new byte[]{0, Operators.castToByte((Operators.castToInt32(by2, 6) + Operators.castToInt32(by3, 6) + Operators.castToInt32(by4, 6)) / 3, 9)};
            }
            if (pngFileSettings.getColorType() == 2) {
                byArray2 = new byte[6];
                byArray2[1] = by2;
                byArray2[3] = by3;
                byArray2[5] = by4;
            }
            if (pngFileSettings.getColorType() == 3) {
                if (pngFileSettings.getPalette() == null) {
                    byArray2 = new byte[]{(byte)pngFileSettings.getTransparentColor()};
                } else {
                    IColorPalette iColorPalette = pngFileSettings.getPalette();
                    int[] nArray = iColorPalette.getArgb32Entries();
                    byArray2 = new byte[nArray.length];
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        byArray2[i2] = (byte)(nArray[i2] >> 24 & 0xFF);
                    }
                }
            }
            ((TransparencyChunk)pngChunk).setBytes(byArray2);
            pngChunk.save(pngStream);
        }
        if (pngFileSettings.hasBackgroundColor()) {
            pngChunk = null;
            switch (pngFileSettings.getColorType()) {
                case 0: 
                case 4: {
                    GrayPaletteBackgroundChunk grayPaletteBackgroundChunk = new GrayPaletteBackgroundChunk();
                    n2 = pngFileSettings.getBackgroundColor();
                    grayPaletteBackgroundChunk.setGrayLevel(Operators.castToUInt16((n2 >> 16 & 255 + (n2 >> 8) & 255 + n2 & 0xFF) / 3, 9));
                    pngChunk = grayPaletteBackgroundChunk;
                    break;
                }
                case 2: 
                case 6: {
                    ColorBackgroundChunk colorBackgroundChunk = new ColorBackgroundChunk();
                    colorBackgroundChunk.setBackgroundColor(pngFileSettings.getBackgroundColor());
                    pngChunk = colorBackgroundChunk;
                    break;
                }
                case 3: {
                    PaletteBackgroundChunk paletteBackgroundChunk = new PaletteBackgroundChunk();
                    IColorPalette iColorPalette = pngFileSettings.getPalette();
                    if (iColorPalette == null) {
                        throw new FrameworkException(StringExtensions.Empty, new PngImageException("You need to specify color palette."));
                    }
                    paletteBackgroundChunk.setBackgroundIndex(iColorPalette.getNearestColorIndex(pngFileSettings.getBackgroundColor()));
                    pngChunk = paletteBackgroundChunk;
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException();
                }
            }
            pngChunk.save(pngStream);
        }
        PngImage.a(pngStream, image, pngFileSettings);
        pngChunk = new FileEndChunk();
        pngChunk.save(pngStream);
    }

    @Override
    protected void saveData(Stream stream) {
        PngOptions pngOptions = new PngOptions();
        pngOptions.setColorType(this.getPngFileSettings().getColorType());
        if (this.getPngFileSettings().getWriteResolution()) {
            pngOptions.setResolutionSettings(new ResolutionSetting(this.getPngFileSettings().getHorizontalResolution(), this.getPngFileSettings().getVerticalResolution()));
        }
        pngOptions.setProgressive(Operators.castToInt32(this.getPngFileSettings().getInterlace(), 6) == 1);
        PngImage.savePng(stream, this, pngOptions);
    }

    @Override
    protected void updateDimensions(int newWidth, int newHeight) {
        this.getPngFileSettings().setHeight(Operators.castToUInt32(newHeight, 9));
        this.getPngFileSettings().setWidth(Operators.castToUInt32(newWidth, 9));
    }

    private static void a(PngStream pngStream, PngFileSettings pngFileSettings) {
        IColorPalette iColorPalette = pngFileSettings.getPalette();
        if (iColorPalette == null) {
            throw new FrameworkException(StringExtensions.Empty, new PngImageException("You need to specify color palette."));
        }
        PaletteChunk paletteChunk = new PaletteChunk(iColorPalette);
        paletteChunk.save(pngStream);
    }

    private static void a(PngStream pngStream, RasterImage rasterImage, PngFileSettings pngFileSettings) {
        PngSaver pngSaver = new PngSaver(pngStream, pngFileSettings);
        if (rasterImage.isRawDataAvailable() && rasterImage.getDitheringSettings() == null) {
            RawDataSettings rawDataSettings = new RawDataSettings();
            switch (pngFileSettings.getColorType()) {
                case 0: {
                    rawDataSettings.setPixelDataFormat(PixelDataFormat.getGrayscale());
                    break;
                }
                case 2: {
                    rawDataSettings.setPixelDataFormat(PixelDataFormat.getRgb24BppPng());
                    break;
                }
                case 3: {
                    rawDataSettings.setPixelDataFormat(PixelDataFormat.getRgbIndexed8Bpp());
                    rawDataSettings.setColorPalette(pngFileSettings.getPalette());
                    break;
                }
                case 4: {
                    rawDataSettings.setPixelDataFormat(PixelDataFormat.getGrayscaleAlpha());
                    break;
                }
                case 6: {
                    rawDataSettings.setPixelDataFormat(PixelDataFormat.getRgba32Bpp());
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException();
                }
            }
            rawDataSettings.setCustomColorConverter(rasterImage.getRawDataSettings().getCustomColorConverter());
            rawDataSettings.setDitheringMethod(rasterImage.getRawDataSettings().getDitheringMethod());
            rawDataSettings.setFallbackIndex(rasterImage.getRawDataSettings().getFallbackIndex());
            rawDataSettings.setLineSize(rasterImage.getWidth() * rawDataSettings.getPixelDataFormat().getBitsPerPixel() / 8);
            PngImageAccumulator pngImageAccumulator = new PngImageAccumulator(pngFileSettings, pngSaver);
            rasterImage.loadRawData(rasterImage.getBounds().Clone(), rawDataSettings, pngImageAccumulator);
        } else {
            PngColorConverter pngColorConverter;
            PngImageAccumulator pngImageAccumulator = new PngImageAccumulator(pngFileSettings, pngSaver);
            switch (pngFileSettings.getColorType()) {
                case 0: {
                    pngColorConverter = new GrayscalePngColorConverter(pngImageAccumulator);
                    break;
                }
                case 2: {
                    pngColorConverter = new RGBPngColorConverter(pngImageAccumulator);
                    break;
                }
                case 3: {
                    pngColorConverter = new PalettePngColorConverter(pngImageAccumulator, pngFileSettings.getPalette());
                    break;
                }
                case 4: {
                    pngColorConverter = new GrayscaleAlphaPngColorConverter(pngImageAccumulator);
                    break;
                }
                case 6: {
                    pngColorConverter = new RGBAPngColorConverter(pngImageAccumulator);
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException();
                }
            }
            rasterImage.loadPartialArgb32Pixels(rasterImage.getBounds().Clone(), pngColorConverter);
        }
        pngSaver.flushData();
    }

    private void a(IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, int n2, int n3, int n4) {
        this.setDataLoader(iRasterImageArgb32PixelLoader);
        if (iRasterImageArgb32PixelLoader != null && Operators.is(iRasterImageArgb32PixelLoader, PngImagePixelLoader.class)) {
            this.setPngFileSettings(((PngImagePixelLoader)iRasterImageArgb32PixelLoader).getPngFileSettings());
        } else {
            this.a(n2, n3, n4);
        }
    }

    private void a(int n2, int n3, int n4) {
        if (n3 <= 0) {
            throw new PngImageException("The height should be positive.");
        }
        if (n2 <= 0) {
            throw new PngImageException("The width should be positive.");
        }
        this.setPngFileSettings(new PngFileSettings());
        this.getPngFileSettings().setColorType(n4);
        this.getPngFileSettings().setHeight(Operators.castToUInt32(n3, 9));
        this.getPngFileSettings().setWidth(Operators.castToUInt32(n2, 9));
        this.getPngFileSettings().setBitDepth((byte)8);
        this.a(this.getPngFileSettings());
    }

    private void a(PngFileSettings pngFileSettings) {
        this.setPngFileSettings(pngFileSettings);
    }
}

