/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.PngOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.lang.Operators;

public class PngFileSettings {
    private int a = 0;
    private byte b;
    private int c;
    private boolean d;
    private long e;
    private double f;
    private byte g;
    private IColorPalette h;
    private int i = 0;
    private double j;
    private long k;
    private boolean l;
    private boolean m;
    private int n;
    private int o;

    public PngFileSettings() {
    }

    public PngFileSettings(PngOptions pngOptions) {
        this.setColorType(pngOptions.getColorType());
        this.o = pngOptions.getCompressionLevel();
        this.setWriteResolution(pngOptions.getResolutionSettings() != null);
        if (pngOptions.getResolutionSettings() != null) {
            this.j = pngOptions.getResolutionSettings().getVerticalResolution();
            this.f = pngOptions.getResolutionSettings().getHorizontalResolution();
        }
        this.g = Operators.castToByte(pngOptions.getProgressive() ? 1 : 0, 9);
        this.h = pngOptions.getPalette();
        this.n = pngOptions.getFilterType();
        this.setBitDepth(pngOptions.getBitDepth());
    }

    public int getBackgroundColor() {
        return this.a;
    }

    public void setBackgroundColor(int value) {
        this.a = value;
    }

    public byte getBitDepth() {
        return this.b;
    }

    public void setBitDepth(byte value) {
        this.b = value;
    }

    public int getColorType() {
        return this.c;
    }

    public void setColorType(int value) {
        this.c = value;
    }

    public int getChannelsCount() {
        switch (this.getColorType()) {
            case 0: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 6: {
                return 4;
            }
        }
        throw new ArgumentOutOfRangeException();
    }

    public boolean hasBackgroundColor() {
        return this.d;
    }

    public void setBackgroundColor(boolean value) {
        this.d = value;
    }

    public long getHeight() {
        return this.e;
    }

    public void setHeight(long value) {
        this.e = value;
    }

    public double getHorizontalResolution() {
        return this.f;
    }

    public void setHorizontalResolution(double value) {
        this.f = value;
    }

    public byte getInterlace() {
        return this.g;
    }

    public void setInterlace(byte value) {
        this.g = value;
    }

    public IColorPalette getPalette() {
        return this.h;
    }

    public void setPalette(IColorPalette value) {
        this.h = value;
    }

    public int getCompressionLevel() {
        return this.o;
    }

    public void setCompressionLevel(int value) {
        this.o = value;
    }

    public int getTransparentColor() {
        return this.i;
    }

    public void setTransparentColor(int value) {
        this.i = value;
    }

    public double getVerticalResolution() {
        return this.j;
    }

    public void setVerticalResolution(double value) {
        this.j = value;
    }

    public long getWidth() {
        return this.k;
    }

    public void setWidth(long value) {
        this.k = value;
    }

    public boolean getWriteResolution() {
        return this.l;
    }

    public void setWriteResolution(boolean value) {
        this.l = value;
    }

    public boolean getWriteTransparentColor() {
        return this.m;
    }

    public void setWriteTransparentColor(boolean value) {
        this.m = value;
    }

    public int getFilterType() {
        return this.n;
    }

    public void setFilterType(int value) {
        this.n = value;
    }

    public int lineByteLen(int samplesCount) {
        return Operators.castToInt32(msMath.ceiling((double)(Operators.castToInt32(this.getBitDepth(), 6) * this.getChannelsCount() * samplesCount) / 8.0), 14);
    }

    public int getSampleLen() {
        return Operators.castToInt32(this.getBitDepth(), 6) * this.getChannelsCount() >> 3;
    }
}

