/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exif;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exif.TagValidator;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffRational;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffSRational;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffASCIIType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffByteType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffLongType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffRationalType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffSRationalType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffShortType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffUndefinedType;
import com.aspose.html.internal.ms.lang.Operators;

public class TiffDataTypeController {
    private final Dictionary<Integer, ExifTagInfo> a = new Dictionary();

    protected boolean exists(int tagId) {
        return this.a.containsKey(tagId);
    }

    protected void removeTagByID(int tagId) {
        if (this.a.containsKey(tagId)) {
            this.a.removeItemByKey(tagId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TiffDataType[] getSectionTags(int section) {
        List<TiffDataType> list = new List<TiffDataType>();
        IGenericEnumerator iGenericEnumerator = ((Dictionary.ValueCollection)this.a.getValues()).iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                ExifTagInfo exifTagInfo = (ExifTagInfo)iGenericEnumerator.next();
                if (section != -1 && exifTagInfo.getSection() != section) continue;
                list.addItem(exifTagInfo.getTiffTag());
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return list.toArray(new TiffDataType[0]);
    }

    protected void setSectionTags(int section, TiffDataType[] tags) {
        if (section == -1) {
            this.a.clear();
        }
        if (tags != null) {
            for (TiffDataType tiffDataType : tags) {
                ExifTagInfo.setValue(this.a, tiffDataType, section);
            }
        }
    }

    protected long getTiffLongTypeValue(int key, long defaultValue) {
        TiffLongType tiffLongType;
        long l2 = defaultValue;
        TiffDataType tiffDataType = this.getTiffType(key);
        if (Operators.is(tiffDataType, TiffLongType.class) && (tiffLongType = (TiffLongType)tiffDataType).getValues().length > 0) {
            l2 = tiffLongType.getValues()[0];
        }
        return l2;
    }

    protected void setTiffLongTypeValue(int key, long value, int section) {
        TiffLongType tiffLongType = new TiffLongType(key);
        tiffLongType.setValues(new long[]{value});
        ExifTagInfo.setValue(this.a, tiffLongType, section);
    }

    protected byte[] getTiffByteValue(int key) {
        byte[] byArray = null;
        TiffDataType tiffDataType = this.getTiffType(key);
        if (Operators.is(tiffDataType, TiffByteType.class)) {
            byArray = ((TiffByteType)tiffDataType).getValues();
        }
        return byArray;
    }

    protected void setTiffByteValue(int key, byte[] value, int section) {
        TiffByteType tiffByteType = new TiffByteType(key);
        tiffByteType.setValues(value);
        ExifTagInfo.setValue(this.a, tiffByteType, section);
    }

    protected TiffSRational getTiffSRationalValue(int key) {
        TiffSRationalType tiffSRationalType;
        TiffSRational tiffSRational = null;
        TiffDataType tiffDataType = this.getTiffType(key);
        if (Operators.is(tiffDataType, TiffSRationalType.class) && (tiffSRationalType = (TiffSRationalType)tiffDataType).getValues().length > 0) {
            tiffSRational = tiffSRationalType.getValues()[0];
        }
        return tiffSRational;
    }

    protected void setTiffSRationalValue(int key, TiffSRational rational, int section) {
        TiffSRationalType tiffSRationalType = new TiffSRationalType(key);
        tiffSRationalType.setValues(new TiffSRational[]{rational});
        ExifTagInfo.setValue(this.a, tiffSRationalType, section);
    }

    protected TiffRational[] getTiffRationalArray(int key) {
        TiffRational[] tiffRationalArray = null;
        TiffDataType tiffDataType = this.getTiffType(key);
        if (Operators.is(tiffDataType, TiffRationalType.class)) {
            tiffRationalArray = ((TiffRationalType)tiffDataType).getValues();
        }
        return tiffRationalArray;
    }

    protected void setTiffRationalArray(int key, TiffRational[] rational, int section) {
        TiffRationalType tiffRationalType = new TiffRationalType(key);
        tiffRationalType.setValues(rational);
        ExifTagInfo.setValue(this.a, tiffRationalType, section);
    }

    protected TiffRational getTiffRationalValue(int key) {
        TiffRationalType tiffRationalType;
        TiffRational tiffRational = null;
        TiffDataType tiffDataType = this.getTiffType(key);
        if (Operators.is(tiffDataType, TiffRationalType.class) && (tiffRationalType = (TiffRationalType)tiffDataType).getValues().length > 0) {
            tiffRational = tiffRationalType.getValues()[0];
        }
        return tiffRational;
    }

    protected void setTiffRational(int key, TiffRational rational, int section) {
        TiffRationalType tiffRationalType = new TiffRationalType(key);
        tiffRationalType.setValues(new TiffRational[]{rational});
        ExifTagInfo.setValue(this.a, tiffRationalType, section);
    }

    protected String getTiffStringValue(int key) {
        String string = null;
        TiffDataType tiffDataType = this.getTiffType(key);
        if (Operators.is(tiffDataType, TiffASCIIType.class)) {
            string = ((TiffASCIIType)tiffDataType).getText();
        }
        return string;
    }

    protected void setTiffStringValue(int key, String text, int section) {
        TiffASCIIType tiffASCIIType = new TiffASCIIType(key);
        tiffASCIIType.setText(text);
        ExifTagInfo.setValue(this.a, tiffASCIIType, section);
    }

    protected byte[] getTiffUndefinedValue(int key) {
        byte[] byArray = null;
        TiffDataType tiffDataType = this.getTiffType(key);
        if (Operators.is(tiffDataType, TiffUndefinedType.class)) {
            byArray = ((TiffUndefinedType)tiffDataType).getData();
        }
        return byArray;
    }

    protected void setTiffUndefinedValue(int key, byte[] data, int section) {
        TiffUndefinedType tiffUndefinedType = new TiffUndefinedType(key);
        tiffUndefinedType.setData(data);
        ExifTagInfo.setValue(this.a, tiffUndefinedType, section);
    }

    protected int getTiffShortValue(int key, int defaultValue) {
        TiffShortType tiffShortType;
        int n2 = defaultValue;
        TiffDataType tiffDataType = this.getTiffType(key);
        if (Operators.is(tiffDataType, TiffShortType.class) && (tiffShortType = (TiffShortType)tiffDataType).getValues().length > 0) {
            n2 = tiffShortType.getValues()[0];
        }
        return n2;
    }

    protected void setTiffShortValue(int key, int value, int section) {
        TiffShortType tiffShortType = new TiffShortType(key);
        tiffShortType.setValues(new int[]{value});
        ExifTagInfo.setValue(this.a, tiffShortType, section);
    }

    protected int[] getTiffShortArray(int key) {
        int[] nArray = null;
        TiffDataType tiffDataType = this.getTiffType(key);
        if (Operators.is(tiffDataType, TiffShortType.class)) {
            nArray = ((TiffShortType)tiffDataType).getValues();
        }
        return nArray;
    }

    protected void setTiffShortArray(int key, int[] value, int section) {
        TiffShortType tiffShortType = new TiffShortType(key);
        tiffShortType.setValues(value);
        ExifTagInfo.setValue(this.a, tiffShortType, section);
    }

    protected TiffDataType getTiffType(int key) {
        TiffDataType tiffDataType = null;
        if (this.a.containsKey(key)) {
            tiffDataType = this.a.get_Item(key).getTiffTag();
        }
        return tiffDataType;
    }

    protected void setTiffType(TiffDataType tiffDataType, int section) {
        ExifTagInfo.setValue(this.a, tiffDataType, section);
    }

    private static class ExifTagInfo {
        private int a;
        private TiffDataType b;

        private ExifTagInfo() {
        }

        public int getSection() {
            return this.a;
        }

        private void a(int n2) {
            this.a = n2;
        }

        public TiffDataType getTiffTag() {
            return this.b;
        }

        private void a(TiffDataType tiffDataType) {
            this.b = tiffDataType;
        }

        public Object getValue() {
            Object object = null;
            if (this.getTiffTag() != null) {
                object = this.getTiffTag().getValue();
            }
            return object;
        }

        public static void setValue(Dictionary<Integer, ExifTagInfo> dictionary, TiffDataType value, int section) {
            if (value == null) {
                throw new ArgumentNullException("value");
            }
            int n2 = value.getId();
            if (section == -1) {
                section = dictionary.containsKey(n2) ? dictionary.get_Item(n2).getSection() : (TagValidator.TagSectionTable.containsKey(n2) ? TagValidator.TagSectionTable.get_Item(n2) : 0);
            }
            ExifTagInfo exifTagInfo = new ExifTagInfo();
            exifTagInfo.a(value);
            exifTagInfo.a(section);
            dictionary.set_Item(value.getId(), exifTagInfo);
        }

        public String toString() {
            return Operators.as(this.getValue(), String.class);
        }
    }
}

