/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.dithering;

import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.dithering.DitheringBase;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.lang.Operators;

public class FloydSteinbergDithering
extends DitheringBase {
    private final IPartialArgb32PixelLoader a;
    private final int[] b;
    private final int[] c;
    private final int[] d;
    private final int[] e;
    private int f;
    private Rectangle g = new Rectangle();
    private int h;

    public FloydSteinbergDithering(int width, int height, Rectangle desiredRectangle, int bits, IColorPalette palette, IPartialArgb32PixelLoader finalProcessor, boolean skipEmptyColor, int colorToSkip, int substituteColor) {
        super(width, height, bits, desiredRectangle.Clone(), finalProcessor, skipEmptyColor, colorToSkip, substituteColor, palette);
        this.a = finalProcessor;
        this.c = new int[width + 2];
        this.d = new int[width + 2];
        ColorInfo colorInfo = ColorHelper.allocate(desiredRectangle.Clone());
        if (colorInfo.getRectangle().getHeight() < 1 || colorInfo.getRectangle().getWidth() < 1) {
            throw new FrameworkException("Cannot allocate buffer. Fatal exception.");
        }
        this.b = colorInfo.getColors();
        colorInfo.getRectangle().CloneTo(this.g);
        this.e = new int[this.Palette.getEntriesCount()];
        int[] nArray = this.Palette.getArgb32Entries();
        Buffer.blockCopy(Array.boxing(nArray), 0, Array.boxing(this.e), 0, this.Palette.getEntriesCount() << 2);
    }

    public IPartialArgb32PixelLoader getFinalProcessor() {
        return this.a;
    }

    @Override
    public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
        int n2;
        int n3 = pixelsRectangle.getWidth();
        int n4 = n3 * pixelsRectangle.getHeight();
        int n5 = pixelsRectangle.getTop();
        int n6 = pixelsRectangle.getLeft();
        boolean bl2 = pixelsRectangle.getRight() == this.getWidth();
        boolean bl3 = false;
        for (int i2 = 0; i2 < n4 || bl3; i2 += n2) {
            int n7;
            n2 = msMath.min(this.getWidth(), n3);
            int[] nArray = this.d;
            if (this.h == 0) {
                nArray = this.c;
            }
            if (bl3) {
                for (n7 = 0; n7 < nArray.length; ++n7) {
                    nArray[n7] = this.SubstituteColorArgb;
                }
                continue;
            }
            nArray[0] = this.SubstituteColorArgb;
            nArray[this.getWidth() + 1] = this.SubstituteColorArgb;
            Buffer.blockCopy(Array.boxing(pixels), i2 << 2, Array.boxing(nArray), n6 + 1 << 2, n2 << 2);
            if (!bl2) continue;
            ++this.h;
            if (this.h < 2) continue;
            this.a(this.c, this.d);
            n7 = i2 / n3 - 2 + n5;
            this.a(n7);
            if (n7 == this.DesiredRectangle.getBottom() - 1 || n7 == this.getHeight() - 1) break;
            Array.copy(Array.boxing(this.d), Array.boxing(this.c), this.c.length);
            bl3 = n7 == this.getHeight() - 2;
        }
        this.a();
    }

    private void a(int n2) {
        Rectangle rectangle = new Rectangle(0, n2, this.getWidth(), 1);
        Rectangle rectangle2 = Rectangle.intersect(this.DesiredRectangle.Clone(), rectangle.Clone()).Clone();
        if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0) {
            if (this.g.getWidth() == this.DesiredRectangle.getWidth()) {
                this.a();
                int n3 = this.f * this.g.getWidth();
                int n4 = this.DesiredRectangle.getLeft() + 1;
                int n5 = this.g.getWidth();
                Buffer.blockCopy(Array.boxing(this.c), n4 << 2, Array.boxing(this.b), n3 << 2, n5 << 2);
                ++this.f;
            } else {
                int n6 = this.DesiredRectangle.getLeft();
                int n7 = this.DesiredRectangle.getRight();
                int n8 = this.g.getWidth();
                int n9 = msMath.min(n7 - n6, n8);
                while (n9 > 0) {
                    Buffer.blockCopy(Array.boxing(this.c), n6 + 1 << 2, Array.boxing(this.b), 0, n9 << 2);
                    Rectangle rectangle3 = new Rectangle(n6, this.g.getTop(), n9, 1);
                    this.a.process(rectangle3.Clone(), this.b, rectangle3.getLocation().Clone(), new Point(rectangle3.getRight(), rectangle3.getBottom()));
                    n9 = msMath.min(n7 - (n6 += n9), n8);
                }
                this.g.offset(0, 1);
            }
        }
    }

    private void a() {
        if (this.f >= this.g.getHeight()) {
            Rectangle rectangle = new Rectangle(this.DesiredRectangle.getLeft(), this.g.getTop(), this.g.getWidth(), this.g.getHeight());
            this.a.process(rectangle.Clone(), this.b, rectangle.getLocation().Clone(), new Point(this.g.getRight(), this.g.getBottom()));
            this.g.offset(0, this.f);
            if (this.g.getBottom() > this.DesiredRectangle.getBottom()) {
                Rectangle.fromLeftTopRightBottom(this.g.getLeft(), this.g.getTop(), this.g.getRight(), this.DesiredRectangle.getBottom()).CloneTo(this.g);
            }
            this.f = 0;
        }
    }

    private void a(int[] nArray, int[] nArray2) {
        for (int i2 = 1; i2 < this.getWidth() + 1; ++i2) {
            int n2 = nArray[i2];
            int n3 = nArray[i2 + 1];
            int n4 = nArray2[i2 - 1];
            int n5 = nArray2[i2];
            int n6 = nArray2[i2 + 1];
            if (this.SkipEmptyColor && (n2 == this.ColorToSkipArgb || n3 == this.ColorToSkipArgb || n4 == this.ColorToSkipArgb || n5 == this.ColorToSkipArgb || n6 == this.ColorToSkipArgb)) continue;
            int n7 = this.e[this.PaletteHash.getNearestColorIndex(n2)];
            n7 = this.switchColor(n7);
            int n8 = n7 >> 16 & 0xFF;
            int n9 = n7 >> 8 & 0xFF;
            int n10 = n7 & 0xFF;
            int n11 = n2 >> 16 & 0xFF;
            int n12 = n2 >> 8 & 0xFF;
            int n13 = n2 & 0xFF;
            double d2 = (double)(n11 - n8) / 16.0;
            double d3 = (double)(n12 - n9) / 16.0;
            double d4 = (double)(n13 - n10) / 16.0;
            nArray[i2] = n7;
            int n14 = this.b(Operators.castToInt32((double)(n3 >> 16 & 0xFF) + 7.0 * d2, 14));
            int n15 = this.b(Operators.castToInt32((double)(n3 >> 8 & 0xFF) + 7.0 * d3, 14));
            int n16 = this.b(Operators.castToInt32((double)(n3 & 0xFF) + 7.0 * d4, 14));
            nArray[i2 + 1] = this.switchColor(0xFF000000 | n14 << 16 | n15 << 8 | n16);
            int n17 = this.b(Operators.castToInt32((double)(n4 >> 16 & 0xFF) + 3.0 * d2, 14));
            int n18 = this.b(Operators.castToInt32((double)(n4 >> 8 & 0xFF) + 3.0 * d3, 14));
            int n19 = this.b(Operators.castToInt32((double)(n4 & 0xFF) + 3.0 * d4, 14));
            nArray2[i2 - 1] = this.switchColor(0xFF000000 | n17 << 16 | n18 << 8 | n19);
            int n20 = this.b(Operators.castToInt32((double)(n5 >> 16 & 0xFF) + 5.0 * d2, 14));
            int n21 = this.b(Operators.castToInt32((double)(n5 >> 8 & 0xFF) + 5.0 * d3, 14));
            int n22 = this.b(Operators.castToInt32((double)(n5 & 0xFF) + 5.0 * d4, 14));
            nArray2[i2] = this.switchColor(0xFF000000 | n20 << 16 | n21 << 8 | n22);
            int n23 = this.b(Operators.castToInt32((double)(n6 >> 16 & 0xFF) + d2, 14));
            int n24 = this.b(Operators.castToInt32((double)(n6 >> 8 & 0xFF) + d3, 14));
            int n25 = this.b(Operators.castToInt32((double)(n6 & 0xFF) + d4, 14));
            nArray2[i2 + 1] = this.switchColor(0xFF000000 | n23 << 16 | n24 << 8 | n25);
        }
    }

    private int b(int n2) {
        return msMath.max(0, msMath.min(255, n2));
    }
}

