/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;

public class Rgb16ToRgb24PngConverter
extends ColorConverter {
    private static final int a = 2;

    public Rgb16ToRgb24PngConverter(int width, int height, int lineSize, PixelDataFormat sourceFormat, Rectangle desiredRectangle, PixelDataFormat destinationFormat, int destinationLineSize) {
        super(width, height, lineSize, sourceFormat, desiredRectangle.Clone(), destinationFormat, destinationLineSize);
    }

    @Override
    protected void convert(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destinationBytesPerLine) {
        for (int i2 = 0; i2 < linesCount; ++i2) {
            int n2 = offset + this.LineSize * i2;
            int n3 = i2 * destinationBytesPerLine + outputOffset;
            int n4 = 0;
            for (int i3 = 0; i3 < samplesCount; ++i3) {
                int n5 = data[n2 + n4] & 0xFF | (data[n2 + n4 + 1] & 0xFF) << 8;
                byte by2 = (byte)(8.225806451612904 * (double)((n5 & 0x7C00) >> 10) + 0.5);
                byte by3 = (byte)(8.225806451612904 * (double)((n5 & 0x3E0) >> 5) + 0.5);
                byte by4 = (byte)(8.225806451612904 * (double)(n5 & 0x1F) + 0.5);
                outputData[n3++] = by2;
                outputData[n3++] = by3;
                outputData[n3++] = by4;
                n4 += 2;
            }
        }
    }
}

