/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.RgbToIndexedConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;

public class Rgb16ToIndexedConverter
extends RgbToIndexedConverter {
    private byte a;

    public Rgb16ToIndexedConverter(int width, int height, int lineSize, PixelDataFormat sourceFormat, Rectangle desiredRectangle, PixelDataFormat destinationFormat, int destinationLineSize, IColorPalette destinationPalette, int fallbackIndex) {
        super(width, height, lineSize, sourceFormat, desiredRectangle.Clone(), destinationFormat, destinationLineSize, destinationPalette, fallbackIndex);
    }

    @Override
    protected void convertToIndexed(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destBytesCount, int lineStartShift) {
        for (int i2 = 0; i2 < linesCount; ++i2) {
            int n2 = offset + this.LineSize * i2;
            int n3 = i2 * destBytesCount + outputOffset;
            int n4 = lineStartShift;
            for (int i3 = 0; i3 < samplesCount; ++i3) {
                int n5 = i3 * this.SampleSize;
                int n6 = data[n2 + n5] & 0xFF | (data[n2 + n5 + 1] & 0xFF) << 8;
                int n7 = (int)(8.225806451612904 * (double)((n6 & 0x7C00) >> 10) + 0.5);
                int n8 = (int)(8.225806451612904 * (double)((n6 & 0x3E0) >> 5) + 0.5);
                int n9 = (int)(8.225806451612904 * (double)(n6 & 0x1F) + 0.5);
                int n10 = 0xFF000000 | n7 << 16 | n8 << 8 | n9;
                int n11 = this.DestinationPalette.getNearestColorIndex(n10);
                if (n11 > this.DestMask) {
                    n11 = this.FallbackIndex;
                }
                byte by2 = (byte)(n11 << n4);
                this.a = (byte)(this.a & 0xFF | by2 & 0xFF);
                if ((n4 -= this.DestinationPixelSize) >= 0 && i3 + 1 != samplesCount) continue;
                n4 = this.InitialBitShift;
                outputData[n3++] = this.a;
                this.a = 0;
            }
        }
    }
}

