/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.IccProfileHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.CachedIccCmm;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccCmm;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccInvalidProfileException;

public class IccColorConverter
extends ColorConverter {
    protected IccCmm converter;
    private Dictionary<IccConvertItem, double[]> a = new Dictionary();

    public IccColorConverter(int width, int height, int lineSize, PixelDataFormat sourceFormat, Rectangle desiredRectangle, PixelDataFormat destinationFormat, int destinationLineSize, StreamContainer sourceIcc, StreamContainer destinationIcc) {
        super(width, height, lineSize, sourceFormat, desiredRectangle.Clone(), destinationFormat, destinationLineSize);
        this.converter = new CachedIccCmm();
        try {
            this.converter.addXform(sourceIcc.getStream());
        }
        catch (IccInvalidProfileException iccInvalidProfileException) {
            this.converter.addXform(IccProfileHelper.getDefaultCmykProfile().getStream());
        }
        try {
            this.converter.addXform(destinationIcc.getStream());
        }
        catch (IccInvalidProfileException iccInvalidProfileException) {
            this.converter.addXform(IccProfileHelper.getDefaultRGBProfile().getStream());
        }
    }

    @Override
    protected void convert(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destinationBytesPerLine) {
        int n2 = this.SourceFormat.getChannelsCount();
        int n3 = this.DestinationFormat.getChannelsCount();
        for (int i2 = 0; i2 < linesCount; ++i2) {
            int n4 = offset + this.LineSize * i2;
            int n5 = i2 * destinationBytesPerLine + outputOffset;
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n3];
            int n6 = n4;
            for (int i3 = 0; i3 < samplesCount; ++i3) {
                int n7;
                for (n7 = 0; n7 < n2; ++n7) {
                    dArray[n7] = (double)(data[n6++] & 0xFF) / 255.0;
                }
                this.converter.apply(dArray, dArray2);
                for (n7 = 0; n7 < n3; ++n7) {
                    outputData[n5++] = (byte)(dArray2[n7] * 255.0);
                }
            }
        }
    }

    private void a(double[] dArray, double[] dArray2) {
        IccConvertItem iccConvertItem = new IccConvertItem(dArray);
        double[] dArray3 = null;
        double[][] dArrayArray = new double[][]{dArray3};
        boolean bl2 = this.a.tryGetValue(iccConvertItem, (Object[])dArrayArray);
        dArray3 = dArrayArray[0];
        if (bl2) {
            System.arraycopy(dArray3, 0, dArray2, 0, dArray3.length);
        } else {
            this.converter.apply(dArray, dArray2);
            this.a.set_Item(iccConvertItem, ArrayHelper.copyDouble(dArray2));
        }
    }

    static class IccConvertItem {
        private double[] a;

        public IccConvertItem(double[] srcPixels) {
            this.a = ArrayHelper.copyDouble(srcPixels);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ObjectExtensions.getType(this) != ObjectExtensions.getType(obj)) {
                return false;
            }
            IccConvertItem iccConvertItem = (IccConvertItem)obj;
            return IccConvertItem.equalsArr(this.a, iccConvertItem.a);
        }

        public int hashCode() {
            return IccConvertItem.hashCode(this.a);
        }

        public static int hashCode(double[] array) {
            if (array == null) {
                return 0;
            }
            int n2 = 1;
            for (int i2 = 0; i2 < array.length; ++i2) {
                double d2 = array[i2];
                long l2 = BitConverter.doubleToInt64Bits(d2);
                n2 = 31 * n2 + (int)(l2 ^ l2 >> 32);
            }
            return n2;
        }

        public static boolean equalsArr(double[] array1, double[] array2) {
            if (array1 == array2) {
                return true;
            }
            if (array1 == null || array2 == null || array1.length != array2.length) {
                return false;
            }
            for (int i2 = 0; i2 < array1.length; ++i2) {
                if (BitConverter.doubleToInt64Bits(array1[i2]) == BitConverter.doubleToInt64Bits(array2[i2])) continue;
                return false;
            }
            return true;
        }
    }
}

