/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;

public class GrayscaleToCMYKColorConverter
extends ColorConverter {
    public GrayscaleToCMYKColorConverter(int width, int height, int lineSize, PixelDataFormat sourceFormat, Rectangle desiredRectangle, PixelDataFormat destinationFormat, int destinationLineSize) {
        super(width, height, lineSize, sourceFormat, desiredRectangle.Clone(), destinationFormat, destinationLineSize);
    }

    @Override
    protected void convert(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destinationBytesPerLine) {
        for (int i2 = 0; i2 < linesCount; ++i2) {
            int n2 = offset + this.LineSize * i2;
            int n3 = i2 * destinationBytesPerLine + outputOffset;
            for (int i3 = 0; i3 < samplesCount; ++i3) {
                int n4 = i3 + n2;
                byte by2 = data[n4];
                double d2 = (double)(by2 & 0xFF) / 255.0;
                double d3 = (double)(by2 & 0xFF) / 255.0;
                double d4 = (double)(by2 & 0xFF) / 255.0;
                double d5 = msMath.min(msMath.min(msMath.min(1.0, d3), d4), d2);
                if (msMath.abs(d5 - 1.0) < 0.001) {
                    d2 = 0.0;
                    d4 = 0.0;
                    d3 = 0.0;
                } else {
                    d3 = (d3 - d5) / (1.0 - d5);
                    d4 = (d4 - d5) / (1.0 - d5);
                    d2 = (d2 - d5) / (1.0 - d5);
                }
                outputData[n3++] = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * d3));
                outputData[n3++] = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * d4));
                outputData[n3++] = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * d2));
                outputData[n3++] = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * d5));
            }
        }
    }
}

