/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.drawing.Color;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.lang.Operators;
import java.util.HashMap;
import java.util.Map;

public final class RgbEntriesPaletteHash
implements IColorPalette {
    private final IColorPalette a;
    private final OptimizedHasher b;

    public RgbEntriesPaletteHash(IColorPalette palette) {
        this.b = palette.getEntriesCount() <= 256 ? new OptimizedHasherUsingMap(palette) : (palette.getEntriesCount() <= 65536 ? new OptimizedHasher16(palette) : new OptimizedHasher32(palette));
        this.a = palette;
    }

    @Override
    public int getEntriesCount() {
        return this.a.getEntriesCount();
    }

    @Override
    public int[] getArgb32Entries() {
        return this.a.getArgb32Entries();
    }

    @Override
    public Color[] getEntries() {
        return this.a.getEntries();
    }

    @Override
    public boolean isCompactPalette() {
        return this.a.isCompactPalette();
    }

    @Override
    public int getNearestColorIndex(int argb32Color) {
        return this.b.getNearestColorIndex(argb32Color);
    }

    @Override
    public int getNearestColorIndex(Color color) {
        return this.getNearestColorIndex(color);
    }

    @Override
    public int getArgb32Color(int index) {
        return this.a.getArgb32Color(index);
    }

    @Override
    public Color getColor(int index) {
        return this.a.getColor(index);
    }

    private static class OptimizedHasherUsingMap
    extends OptimizedHasher {
        private final Map<Integer, Integer> a = new HashMap<Integer, Integer>();

        public OptimizedHasherUsingMap(IColorPalette colorPalette) {
            super(colorPalette);
        }

        @Override
        public int getNearestColorIndex(int argb32Color) {
            Integer n2 = this.a.get(argb32Color);
            if (n2 == null) {
                n2 = this.Palette.getNearestColorIndex(argb32Color);
                this.a.put(argb32Color, n2);
            }
            return n2;
        }
    }

    private static class OptimizedHasher8
    extends OptimizedHasher {
        private final byte[] a = new byte[0x1000000];
        private final byte[] b = new byte[0x1000000];

        public OptimizedHasher8(IColorPalette colorPalette) {
            super(colorPalette);
        }

        @Override
        public int getNearestColorIndex(int argb32Color) {
            byte by2;
            int n2 = argb32Color & 0xFFFFFF;
            if (Operators.castToInt32(this.b[n2], 6) > 0) {
                by2 = this.a[n2];
            } else {
                by2 = Operators.castToByte(this.Palette.getNearestColorIndex(argb32Color), 9);
                this.b[n2] = 1;
                this.a[n2] = by2;
            }
            return Operators.castToInt32(by2, 6);
        }
    }

    private static class OptimizedHasher16
    extends OptimizedHasher {
        private final short[] a = new short[0x1000000];
        private final byte[] b = new byte[0x1000000];

        public OptimizedHasher16(IColorPalette colorPalette) {
            super(colorPalette);
        }

        @Override
        public int getNearestColorIndex(int argb32Color) {
            short s2;
            int n2 = argb32Color & 0xFFFFFF;
            if (Operators.castToInt32(this.b[n2], 6) > 0) {
                s2 = this.a[n2];
            } else {
                s2 = Operators.castToInt16(this.Palette.getNearestColorIndex(argb32Color), 9);
                this.b[n2] = 1;
                this.a[n2] = s2;
            }
            return s2;
        }
    }

    private static class OptimizedHasher32
    extends OptimizedHasher {
        private final int[] a = new int[0x1000000];
        private final byte[] b = new byte[0x1000000];

        public OptimizedHasher32(IColorPalette colorPalette) {
            super(colorPalette);
        }

        @Override
        public int getNearestColorIndex(int argb32Color) {
            int n2;
            int n3 = argb32Color & 0xFFFFFF;
            if (Operators.castToInt32(this.b[n3], 6) > 0) {
                n2 = this.a[n3];
            } else {
                n2 = this.Palette.getNearestColorIndex(argb32Color);
                this.b[n3] = 1;
                this.a[n3] = n2;
            }
            return n2;
        }
    }

    private static abstract class OptimizedHasher {
        protected final IColorPalette Palette;

        protected OptimizedHasher(IColorPalette colorPalette) {
            this.Palette = colorPalette;
        }

        public abstract int getNearestColorIndex(int var1);
    }
}

