/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PointF;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RectangleF;
import com.aspose.html.internal.ms.lang.Operators;

public class MathHelpers {
    public static long ensureWordBoundary(long value) {
        long l2 = value;
        long l3 = 4L - Operators.castToUInt32(Operators.castToUInt32(value, 10) % 4L, 10);
        if (Operators.castToUInt32(l3, 10) != 4L) {
            l2 = Operators.castToUInt32(Operators.castToUInt32(l2, 10) + Operators.castToUInt32(l3, 10), 10);
        }
        return l2;
    }

    public static double distance(PointF point, PointF point2) {
        return msMath.sqrt(msMath.pow(point.getX() - point2.getX(), 2.0) + msMath.pow(point.getY() - point2.getY(), 2.0));
    }

    public static double degreesToRadians(double degrees) {
        return Math.PI / 180 * degrees;
    }

    public static double radiansToDegrees(double radians) {
        return 57.29577951308232 * radians;
    }

    public static RectangleF rectangleFromPoints(PointF point1, PointF point2) {
        float f2 = msMath.min(point1.getX(), point2.getX());
        float f3 = msMath.min(point1.getY(), point2.getY());
        float f4 = msMath.max(point1.getX(), point2.getX());
        float f5 = msMath.max(point1.getY(), point2.getY());
        return RectangleF.fromLeftTopRightBottom(f2, f3, f4, f5);
    }

    public static Rectangle rectangleFromPoints(Point point1, Point point2) {
        int n2 = msMath.min(point1.getX(), point2.getX());
        int n3 = msMath.min(point1.getY(), point2.getY());
        int n4 = msMath.max(point1.getX(), point2.getX());
        int n5 = msMath.max(point1.getY(), point2.getY());
        return Rectangle.fromLeftTopRightBottom(n2, n3, n4, n5);
    }

    public static Point getCenter(Point point1, Point point2) {
        return new Point((point1.getX() + point2.getX()) / 2, (point1.getY() + point2.getY()) / 2);
    }

    public static PointF getCenter(PointF point1, PointF point2) {
        return new PointF((point1.getX() + point2.getX()) / 2.0f, (point1.getY() + point2.getY()) / 2.0f);
    }

    public static Point getCenter(Rectangle rect) {
        return new Point((rect.getLeft() + rect.getRight()) / 2, (rect.getTop() + rect.getBottom()) / 2);
    }

    public static PointF getCenter(RectangleF rect) {
        return new PointF((rect.getLeft() + rect.getRight()) / 2.0f, (rect.getTop() + rect.getBottom()) / 2.0f);
    }

    public static PointF getCenter(PointF[] points) {
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        if (points.length > 0) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (PointF pointF : points) {
                f2 += pointF.getX();
                f3 += pointF.getY();
            }
            return new PointF(f2 / (float)points.length, f3 / (float)points.length);
        }
        return PointF.getEmpty();
    }

    public static Rectangle getBounds(Point[] points) {
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        if (points.length == 0) {
            return Rectangle.getEmpty();
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        for (Point point : points) {
            if (point.getX() < n2) {
                n2 = point.getX();
            }
            if (point.getX() > n3) {
                n3 = point.getX();
            }
            if (point.getY() > n5) {
                n5 = point.getY();
            }
            if (point.getY() >= n4) continue;
            n4 = point.getY();
        }
        return Rectangle.fromLeftTopRightBottom(n2, n4, n3, n5);
    }

    public static RectangleF getBounds(PointF[] points) {
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        if (points.length == 0) {
            return RectangleF.getEmpty();
        }
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        float f4 = Float.MAX_VALUE;
        float f5 = -3.4028235E38f;
        for (PointF pointF : points) {
            if (pointF.getX() < f2) {
                f2 = pointF.getX();
            }
            if (pointF.getX() > f3) {
                f3 = pointF.getX();
            }
            if (pointF.getY() > f5) {
                f5 = pointF.getY();
            }
            if (!(pointF.getY() < f4)) continue;
            f4 = pointF.getY();
        }
        return RectangleF.fromLeftTopRightBottom(f2, f4, f3, f5);
    }

    public static RectangleF getBounds(RectangleF[] rectangles) {
        if (rectangles == null) {
            throw new ArgumentNullException("rectangles");
        }
        RectangleF rectangleF = RectangleF.getEmpty().Clone();
        for (RectangleF rectangleF2 : rectangles) {
            if (rectangleF2.isEmpty()) continue;
            if (rectangleF.isEmpty()) {
                rectangleF2.CloneTo(rectangleF);
                continue;
            }
            RectangleF.union(rectangleF2.Clone(), rectangleF.Clone()).CloneTo(rectangleF);
        }
        return rectangleF;
    }

    public static PointF getPointByAngleInDegrees(RectangleF rectangle, double angle) {
        double d2 = (double)rectangle.getWidth() / 2.0;
        double d3 = (double)rectangle.getHeight() / 2.0;
        double d4 = MathHelpers.degreesToRadians(angle);
        return new PointF(Operators.castToFloat(msMath.cos(d4) * d2, 14) + rectangle.getLeft() + rectangle.getWidth() / 2.0f, Operators.castToFloat(msMath.sin(d4) * d3, 14) + rectangle.getTop() + rectangle.getHeight() / 2.0f);
    }

    public static double getAngleInRadians(PointF leftTop, PointF rightTop, PointF leftBottom) {
        double d2 = 0.0;
        if (!(leftTop.getX() < rightTop.getX()) || leftTop.getY() != rightTop.getY()) {
            double d3 = MathHelpers.distance(leftTop.Clone(), rightTop.Clone());
            double d4 = MathHelpers.distance(leftTop.Clone(), leftBottom.Clone());
            if (d3 > 0.0 && d4 > 0.0) {
                double d5 = rightTop.getY() - leftTop.getY();
                d2 = msMath.asin(d5 / d3);
                if (rightTop.getX() < leftTop.getX()) {
                    d2 = Math.PI - d2;
                }
            }
        }
        return d2;
    }

    public static PointF getPointByAngleInDegrees(PointF leftTop, PointF rightTop, PointF leftBottom, double angle) {
        double d2 = MathHelpers.distance(leftTop.Clone(), rightTop.Clone());
        double d3 = MathHelpers.distance(leftTop.Clone(), leftBottom.Clone());
        double d4 = d2 / 2.0;
        double d5 = d3 / 2.0;
        double d6 = MathHelpers.a(leftTop.Clone(), rightTop.Clone(), d2, d3);
        double d7 = MathHelpers.degreesToRadians(angle) + d6;
        PointF pointF = MathHelpers.getCenter(leftBottom.Clone(), rightTop.Clone()).Clone();
        return new PointF(Operators.castToFloat(msMath.cos(d7) * d4 + (double)pointF.getX(), 14), Operators.castToFloat(msMath.sin(d7) * d5 + (double)pointF.getY(), 14));
    }

    private static double a(PointF pointF, PointF pointF2, double d2, double d3) {
        double d4 = 0.0;
        if ((!(pointF.getX() < pointF2.getX()) || pointF.getY() != pointF2.getY()) && d2 > 0.0 && d3 > 0.0) {
            double d5 = pointF2.getY() - pointF.getY();
            d4 = msMath.asin(d5 / d2);
            if (pointF2.getX() < pointF.getX()) {
                d4 = Math.PI - d4;
            }
        }
        return d4;
    }
}

