/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.drawing.Color;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.ColorPaletteCacherUsingAlpha;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorPaletteCacher;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;

public final class ColorPalette
implements IColorPalette {
    private int[] a;
    private ColorPaletteCacher b;
    private boolean c;

    public ColorPalette(int[] entries, boolean isCompactPalette) {
        this.a(entries, isCompactPalette);
    }

    public ColorPalette(int[] entries) {
        this(entries, false);
    }

    public ColorPalette(Color[] entries) {
        int[] nArray = new int[entries.length];
        for (int i2 = 0; i2 < entries.length; ++i2) {
            nArray[i2] = entries[i2].toArgb();
        }
        this.a(nArray, false);
    }

    private void a(int[] nArray, boolean bl2) {
        boolean bl3 = true;
        for (int n2 : nArray) {
            int n3 = n2 >> 24 & 0xFF;
            if (n3 == 255) continue;
            bl3 = false;
            break;
        }
        this.b = bl3 ? new ColorPaletteCacher(nArray) : new ColorPaletteCacherUsingAlpha(nArray);
        this.a = nArray;
        this.c = bl2;
    }

    @Override
    public int getEntriesCount() {
        return this.a.length;
    }

    @Override
    public int[] getArgb32Entries() {
        int[] nArray = ArrayHelper.getColors(this.a.length);
        System.arraycopy(this.a, 0, nArray, 0, this.a.length);
        return nArray;
    }

    @Override
    public Color[] getEntries() {
        Color[] colorArray = new Color[this.a.length];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            colorArray[i2] = Color.fromArgb(this.a[i2]);
        }
        return colorArray;
    }

    @Override
    public boolean isCompactPalette() {
        return this.c;
    }

    public static ColorPalette copyPalette(IColorPalette colorPalette, boolean useCompactPalette) {
        ColorPalette colorPalette2 = null;
        if (colorPalette != null) {
            int[] nArray = ArrayHelper.getColors(colorPalette.getEntriesCount());
            Array.boxing(colorPalette.getArgb32Entries()).copyTo(Array.boxing(nArray), 0);
            colorPalette2 = new ColorPalette(nArray, useCompactPalette);
        }
        return colorPalette2;
    }

    public static ColorPalette copyPalette(IColorPalette colorPalette) {
        return ColorPalette.copyPalette(colorPalette, colorPalette != null ? colorPalette.isCompactPalette() : false);
    }

    @Override
    public int getNearestColorIndex(int color) {
        return this.b.getNearestColorIndex(color);
    }

    @Override
    public int getNearestColorIndex(Color color) {
        return this.getNearestColorIndex(color.toArgb());
    }

    @Override
    public int getArgb32Color(int index) {
        if (index >= this.a.length || index < 0) {
            throw new ArgumentOutOfRangeException("index", "The specified index lies out of the entries length.");
        }
        return this.a[index];
    }

    @Override
    public Color getColor(int index) {
        return Color.fromArgb(this.getArgb32Color(index));
    }
}

